package com.yeejoin.precontrol.common.enums;

/**
 * @Description: 打卡枚举 
 * @Author: duanwei
 * @Date: 2020/10/29 
 */
public enum ClockInOutEum {
    /*
     * 入场
     */
    in("入场", 0),
    /*
     * 出场
     */
    out("出场", 1);

    private String label;
    private int value;

    ClockInOutEum(String label, int value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public static String getLabelByValue(int value) {
        String label = null;
        for (ClockInOutEum type : ClockInOutEum.values()) {
            if (type.getValue() == value) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
