package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum ProcessTypeEnum {
    项目立项("projectApproval", "项目立项流程", "tz_ugp_project"),
    项目结项("projectClosing",  "项目结项流程",""),
    问题处理("problemHandling",  "问题处理流程","tz_ugp_quality_problem"),
    人工处理("manualHandling", "人工处理流程","");

    String type;
    String name;
    String tableName;

    public static Map<String,String> getCodeByName = new HashMap<String,String>();

    static {
        for(ProcessTypeEnum processTypeEnum:ProcessTypeEnum.values()){
            getCodeByName.put(processTypeEnum.name,processTypeEnum.type);
        }
    }
}
