package com.yeejoin.amos.boot.biz.common.permission;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.List;

/**
 * @author Administrator
 */
@Component
public class PermissionOfUser {

    @Autowired
    RedissonClient redissonClient;

    @Autowired
    RedisUtils redisUtil;

    private static final String LOCK_KEY_PREFIX = "PERMISSION_SET_KEY_";

    public ReginParams getSelectedOrgInfo() {
        ReginParams reginParams = new ReginParams();
        String userId = RequestContext.getExeUserId();
        String prefix = "REGIN_PARAM_" + userId + "_";
        String reginParamKey = prefix + RequestContext.getToken();
        if (redisUtil.hasKey(reginParamKey)) {
            reginParams = JSON.parseObject(redisUtil.get(reginParamKey).toString(), ReginParams.class);
        } else {
            RLock lock = redissonClient.getLock(LOCK_KEY_PREFIX + userId);
            try {
                lock.lock();
                if (redisUtil.hasKey(reginParamKey)) {
                    reginParams = JSON.parseObject(redisUtil.get(reginParamKey).toString(), ReginParams.class);
                } else {
                    this.deleteOldKey(prefix);
                    List<CompanyModel> companyModels = FeignUtil.remoteCall(() -> Privilege.companyClient.queryListByChild(userId));
                    if (companyModels != null && !companyModels.isEmpty()) {
                        CompanyBo companyBo = new CompanyBo();
                        Bean.copyExistPropertis(companyModels.get(0), companyBo);
                        AgencyUserModel agencyUserModel = new AgencyUserModel();
                        agencyUserModel.setUserId(userId);
                        agencyUserModel.setCompanys(companyModels);
                        reginParams.setCompany(companyBo);
                        reginParams.setUserModel(agencyUserModel);
                        redisUtil.set(reginParamKey,JSON.toJSONString(reginParams),24 * 60 * 60L);
                    }
                }
            } finally {
                lock.unlock();
            }
        }
        return reginParams;
    }

    /**
     * 删除redis 里面登录过期的key
     * @param prefix redis前缀
     */
    private void deleteOldKey(String prefix) {
        redisUtil.getAndDeletePatternKeys(prefix + "*");
    }


}
