package com.yeejoin.amos.boot.biz.config;


import lombok.extern.slf4j.Slf4j;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


@Configuration
@Slf4j
public class RedissonManager {

    /**
     * 集群环境使用
     */
    @Value("${spring.redis.cluster.nodes:default}")
    private String clusterNodes;

    /**
     * 通用
     */
    @Value("${spring.redis.password}")
    private String password;

    /**
     * 单机环境使用
     */
    @Value("${spring.redis.host:default}")
    private String host;

    /**
     * 单机环境使用
     */
    @Value("${spring.redis.port:default}")
    private String port;

    @Bean
    @ConditionalOnProperty(name = "spring.redis.mode", havingValue = "cluster")
    public RedissonClient redissonClusterClient() {
        //集群环境使用
        Config config = new Config();
        config.useClusterServers()
                .addNodeAddress(clusterNodes.split(","))
                .setPassword(password);
        return Redisson.create(config);
    }

    @Bean
    @ConditionalOnProperty(name = "spring.redis.mode", havingValue = "singleton", matchIfMissing = true)
    public RedissonClient redissonSingletonClient() {
        // 单机打包使用
        Config config = new Config();
        config.useSingleServer().setAddress(host + ":" + port).setPassword(password);
        return Redisson.create(config);
    }
}
