package com.yeejoin.amos.supervision.business.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 消防设施资源数据对象 mt_maintenance_resource_data
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
@Data
@ApiModel(value = "MaintenanceResourceDataVo", description = "维保设施资源数据Vo")
public class MaintenanceResourceData {

    private Long id;

    /**
     * 维保资源ID
     */
    private Long maintenanceResourceId;

    /**
     * 维保单位ID
     */
    private Long maintenanceCompanyId;

    /**
     * 维保单位编码
     */
    private String maintenanceCompanyCode;

    /**
     * 维保单位名称
     */
    private String maintenanceCompanyName;

    /**
     * 业主单位ID
     */
    private Long ownerUnitId;

    /**
     * 业主单位编码
     */
    private String ownerUnitCode;

    /**
     * 业主单位名称
     */
    @Excel(name = "所属单位", width = 30, orderNum = "7")
    private String ownerUnitName;

    /**
     * 消防系统ID
     */
    private Long fireFightSysId;

    /**
     * 消防系统编码
     */
    private String fireFightSysCode;

    /**
     * 消防系统名称
     */
    @Excel(name = "所属消防系统", width = 30, orderNum = "4")
    private String fireFightSysName;

    /**
     * 分类ID
     */
    private Long classifyId;

    /**
     * 分类编码
     */
    private String classifyCode;

    /**
     * 分类名称
     */
    @Excel(name = "设施类型", width = 30, orderNum = "3")
    private String classifyName;

    /**
     * 分类类型
     */
    private String classifyType;

    /**
     * 消防设施ID
     */
    private Long fireFacilityId;

    /**
     * 消防设施编码
     */
    @Excel(name = "设施编码", width = 30, orderNum = "6")
    private String fireFacilityCode;

    /**
     * 消防设施名称
     */
    @Excel(name = "设施名称", width = 30, orderNum = "1")
    private String fireFacilityName;

    /**
     * 消防设施类型
     */
    private String fireFacilityType;

    /**
     * 维保到期时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "到期维保时间", exportFormat = "yyyy-MM-dd HH:mm:ss", importFormat = "yyyy-MM-dd HH:mm:ss", width = 30, orderNum = "5")
    private Date maintenanceExpirationTime;

    /**
     * 位置
     */
    @Excel(name = "安装或设置位置", width = 50, orderNum = "2")
    private String location;

    /**
     * 建筑层级IDS
     */
    private String buildTierIds;

    /**
     * 新增和更新执行
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "添加时间", exportFormat = "yyyy-MM-dd HH:mm:ss", importFormat = "yyyy-MM-dd HH:mm:ss", width = 30, orderNum = "8")
    private Date createDate;

    /**
     * 建筑ID
     */
    private Long buildingId;

    /**
     * 建筑名称
     */
    private String buildingName;

    /**
     * 是否已关联
     */
    private List<Long> buildingIds;

    /**
     * 是否已关联
     */
    private Boolean isRelation;

//    public void setRelation(Boolean relation) {
//        isRelation = relation == null ? null : false;
//    }
}
