package com.yeejoin.precontrol.common.start;

import java.util.List;
import java.util.Timer;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.TaskTimedTask;
import com.yeejoin.precontrol.common.service.ITaskTimedTaskService;
import com.yeejoin.precontrol.common.task.RiskTimerTask;
import com.yeejoin.precontrol.common.utils.StringUtil;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
//@DependsOn("liquibase")
public class StartRiskService {

	@Autowired
	private ITaskTimedTaskService iTaskTimedTaskService;

	public void doTimerTask() {

		List<TaskTimedTask> list = iTaskTimedTaskService
				.list(new LambdaQueryWrapper<TaskTimedTask>().eq(TaskTimedTask::isExecuted, false));
		Timer timer = new Timer();
		if (StringUtil.isNotEmpty(list)) {
			list.forEach(i -> {
				RiskTimerTask riskTimerTask = new RiskTimerTask(i.getTaskId());
				timer.schedule(riskTimerTask, i.getExecuteTime());
			});
		}
	}
}
