package com.yeejoin.amos.boot.module.elevator.flc.biz.controller;

import com.yeejoin.amos.boot.module.elevator.flc.api.dto.PersonEducationDto;
import com.yeejoin.amos.boot.module.elevator.flc.biz.service.impl.PersonEducationServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 企业人员资质信息表
 *
 * @author system_generator
 * @date 2021-11-22
 */
@RestController
@Api(tags = "企业人员资质信息表Api")
@RequestMapping(value = "/flc-person-education")
public class PersonEducationController extends BaseController {

    @Autowired
	PersonEducationServiceImpl personEducationServiceImpl;

    /**
     * 新增企业人员资质信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增企业人员资质信息表", notes = "新增企业人员资质信息表")
	public ResponseModel<PersonEducationDto> save(@RequestBody PersonEducationDto model) {
	    model = personEducationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新企业人员资质信息表", notes = "根据sequenceNbr更新企业人员资质信息表")
	public ResponseModel<PersonEducationDto> updateBySequenceNbrFlcPersonEducation(@RequestBody PersonEducationDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(personEducationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除企业人员资质信息表", notes = "根据sequenceNbr删除企业人员资质信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(personEducationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个企业人员资质信息表",  notes = "根据sequenceNbr查询单个企业人员资质信息表")
	public ResponseModel<PersonEducationDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(personEducationServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "企业人员资质信息表分页查询",  notes = "企业人员资质信息表分页查询")
	public ResponseModel<Page<PersonEducationDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size) {
	    Page<PersonEducationDto> page = new Page<PersonEducationDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(personEducationServiceImpl.queryForFlcPersonEducationPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "企业人员资质信息表列表全部数据查询",   notes = "企业人员资质信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PersonEducationDto>> selectForList() {
	    return ResponseHelper.buildResponse(personEducationServiceImpl.queryForFlcPersonEducationList());
	}
}
