package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.openapi.service.XiAnDataDockServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;


@RestController
@Api(tags = "西安数据对接 API")
@RequestMapping(value = "/xi-an")
public class XiAnDataDockController {

    private final XiAnDataDockServiceImpl xiAnDataDockService;

    public XiAnDataDockController(XiAnDataDockServiceImpl xiAnDataDockService) {
        this.xiAnDataDockService = xiAnDataDockService;
    }

    /**
     * 西安除电梯外七大类设备批量导入
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/importData")
    @ApiOperation(httpMethod = "POST", value = "西安除电梯外七大类设备批量导入", notes = "西安除电梯外七大类设备批量导入")
    public Object importPressureData(@RequestParam MultipartFile file) {
        // 校验文件是否为空
        if (file.isEmpty()) {
            return ResponseHelper.buildResponse("文件不能为空");
        }

        // 校验文件类型为 Excel
        String contentType = file.getContentType();
        String fileExtension = FilenameUtils.getExtension(file.getOriginalFilename());

        // 校验 Excel 文件的 MIME type 和扩展名
        if (!("application/vnd.ms-excel".equals(contentType) ||
                "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType)) ||
                !("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension))) {
            return ResponseHelper.buildResponse("文件类型必须是 Excel 文件");
        }
        return xiAnDataDockService.importEquipmentData(file);
    }

    /**
     * 西安电梯历史设备以及业务数据批量导入
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/importElevatorData")
    @ApiOperation(httpMethod = "POST", value = "西安电梯历史设备以及业务数据批量导入", notes = "西安电梯历史设备以及业务数据批量导入")
    public Object importElevatorData(@RequestParam MultipartFile file, @RequestParam(required = false, defaultValue = "true") Boolean isRegistration) {
        if (file.isEmpty()) {
            return ResponseHelper.buildResponse("文件不能为空");
        }
        String contentType = file.getContentType();
        String fileExtension = FilenameUtils.getExtension(file.getOriginalFilename());
        if (!("application/vnd.ms-excel".equals(contentType) ||
                "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(contentType)) ||
                !("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension))) {
            return ResponseHelper.buildResponse("文件类型必须是 Excel 文件");
        }
        return xiAnDataDockService.importElevatorData(file, isRegistration);
    }
}

