package com.yeejoin.amos.boot.module.statistics.api.mapper;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface JGStatisticsMapper {

    List<Map<String, Object>> maintenanceCountTopTen(@Param("orgCodeList") List<String> orgCodeList);

    List<Map<String, Object>> maintenanceCount(@Param("orgCodeList") List<String> orgCodeList);

    List<Map<String, Object>> installEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);

    List<Map<String, Object>> maintenanceEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);

    List<Map<String, Object>> reformEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);

    List<Map<String, Object>> transferEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);


    List<Map<String, Object>> useEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeReformEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeTransferEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);

    List<Map<String, Object>> changeUnitEquCount(@Param("orgCode") String orgCode, @Param("startTime") String startTime);

    List<Map<String, Object>> newRegEquCountByMonth(@Param("orgCode") String orgCode);

    List<Map<String, Object>> newVehicleEquCountByMonth(@Param("orgCode") String orgCode);

    List<Map<String, Object>> newRegEquCountByPeriod(@Param("orgCode") String orgCode, @Param("startTime") DateTime startTime, @Param("endTime") DateTime endTime);

    List<Map<String, Object>> newVehicleEquCountByPeriod(@Param("orgCode") String orgCode, @Param("startTime") DateTime startTime, @Param("endTime") DateTime endTime);

    String newVehicleCountByPeriod(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("startTime") DateTime startTime);

    long certificateCountByOrgCode(@Param("orgCode") String orgCode);

    long useCountByOrgCode(@Param("orgCode") String orgCode);

    Long over15yearsCount(@Param("orgCode") String orgCode, @Param("time") String time);

    Long constructionNoticeCount(@Param("dto") DPFilterParamDto dto);

    Long changeCountByOrgCode(@Param("dto") DPFilterParamDto dto);

    List<Map<String, Object>> selectNoticeList(@Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamDto dto);

    Page<Map<String, Object>> selectNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectAZNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectWXNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectGZNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    Page<Map<String, Object>> selectYZNoticeDetailList(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamForDetailDto dpFilterParamDto);

    List<Map<String, Object>> selectNoticeCountTopTen(@Param("orgCode") String orgCode, @Param("time") String time, @Param("dto") DPFilterParamDto dto);

    /**
     *  告知类业务平均办理时效，统计维度：接收机构所在的行政区域;
     *  @param dpFilterParamDto 过滤条件
     * @param orgCode 登录人或者选择区域转换后的orgCode
     * @return  告知类业务平均办理时效
     */
    List<CountDto> queryNoticeAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryUseAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryChangeAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryDisableAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    List<CountDto> queryCancelAvgDayByReceiveCompany(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode);

    Page<Map<String, Object>> countBizFinishedNumForDPListSGGZ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListSYDJ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListBGDJ(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListTYQY(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListZXBF(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Page<Map<String, Object>> countBizFinishedNumForDPListAll(@Param("page") Page<Map<String, Object>> page, @Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto, @Param("treeValue") String treeValue);

    Long getNoticeCountTopChart(@Param("dto") DPFilterParamForDetailDto dto);

    Page<Map<String, Object>> noticeCountTopPageNew(@Param("page") Page<Map<String, Object>> page, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);


    List<String> getOrgCodeListByRegionCode(@Param("regionCode") String regionCode);
    List<Map<String, Object>> noticeCountTopPageByUseUnitCode(@Param("unitCodeList") List<String> unitCodeList, @Param("dto") DPFilterParamForDetailDto dto);
}
