package com.yeejoin.amos.fas.business.controller;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.service.intfc.IDictService;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.Dict;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api")
@Api(tags="数据字典api")
public class DictController extends AbstractBaseController{
	@Autowired
	private IDictService dictService;
	
	private final Logger log = LoggerFactory.getLogger(DictController.class);
	
	/**
	 * 根据查询条件列出字典列表
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据查询条件列出字典列表", notes = "根据查询条件列出字典列表")
	@RequestMapping(value = "/dict/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	//@Authorization(ingore=true)
	public CommonResponse page(Dict dict,
			@ApiParam(value = "分页参数", defaultValue = "pageNumber=0&pageSize=10") CommonPageable commonPageable){
		try {
			Page<Dict> dictList = dictService.getDictPage(dict, commonPageable);
			return CommonResponseUtil.success(dictList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询字典信息失败");
		}
	}
	
	/**
	 * 根据查询条件列出字典列表
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据查询条件列出字典列表", notes = "根据查询条件列出字典列表")
	@RequestMapping(value = "/dict/list", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	//@Authorization(ingore=true)
	public CommonResponse list(Dict dict){
		try {
			List<Dict> dictList = dictService.getDictList(dict);
			return CommonResponseUtil.success(dictList);
		} catch (Exception e) {
			log.error(e.getMessage(), e);
			return CommonResponseUtil.failure("查询字典信息失败");
		}
	}
	
	/**
	 * 根据IDs查询字典详情
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据IDs查询字典详情", notes = "根据IDs查询字典详情")
	@RequestMapping(value = "/dict/list/{ids}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	//@Authorization(ingore=true)
	public CommonResponse list(Long[] ids){
		List<Dict> dictList = dictService.getDictListByIds(ids);
		return CommonResponseUtil.success(dictList);
	}
	
	/**
	 * 根据ID查询字典详情
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据ID查询字典详情", notes = "根据ID查询字典详情")
	@RequestMapping(value = "/dict/list/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	//@Authorization(ingore=true)
	public CommonResponse list(long id){
		Dict dict = dictService.getDictById(id);
		return CommonResponseUtil.success(dict);
	}
	
	
	/**
	 * 根据ID删除字典
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE",value = "根据ID删除字典", notes = "根据ID删除字典")
	@RequestMapping(value = "/dict/delete/{id}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
	//@Authorization(ingore=true)
	public CommonResponse delete(long id){
		dictService.deleteDictById(id);
		return CommonResponseUtil.success();
	}
	
	/**
	 * 根据IDs删除字典
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE",value = "根据IDs删除字典", notes = "根据IDs删除字典")
	@RequestMapping(value = "/dict/delete/{ids}", produces = "application/json;charset=UTF-8", method = RequestMethod.DELETE)
	//@Authorization(ingore=true)
	public CommonResponse deletes(long[] ids){
		dictService.deleteDictByIds(ids);
		return CommonResponseUtil.success();
	}
	
	/**
	 * 新增字典
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "新增字典", notes = "新增字典")
	@RequestMapping(value = "/dict/add", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
	//@Authorization(ingore=true)
	public CommonResponse add(@RequestBody Dict dict){
		dictService.saveDict(dict);
		return CommonResponseUtil.success();
	}
	
	/**
	 * 编辑字典信息
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT",value = "编辑字典信息", notes = "编辑字典信息")
	@RequestMapping(value = "/dict/edit", produces = "application/json;charset=UTF-8", method = RequestMethod.PUT)
	//@Authorization(ingore=true)
	public CommonResponse edit(@RequestBody Dict dict){
		dictService.saveDict(dict);
		return CommonResponseUtil.success();
	}
}
