package com.yeejoin.amos.latentdanger.business.service.intfc;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerDto;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerExecuteParam;
import com.yeejoin.amos.latentdanger.business.param.PageParam;
import com.yeejoin.amos.latentdanger.common.enums.LatentDangerLevelEnum;
import org.springframework.data.domain.Page;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.RoleBo;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.latentdanger.business.dto.DangerExecuteSubmitDto;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerListParam;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerNormalParam;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerPatrolParam;
import com.yeejoin.amos.latentdanger.business.util.CommonResponse;
import com.yeejoin.amos.latentdanger.business.vo.DangerTimeAxisVo;
import com.yeejoin.amos.latentdanger.core.common.response.DangerListResponse;

/**
 * @author keyong
 * @title: ILatentDangerService
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/1/26 14:44
 */
public interface ILatentDangerService {

    CommonResponse saveNormal(LatentDangerNormalParam latentDangerParam, String userId, String userRealName,
                              String departmentId, String departmentName, String companyId, String orgCode, RoleBo role);

    CommonResponse savePatrol(List<LatentDangerDto> latentDangerDtoList, String userId, String userRealName,
                              String departmentId, String departmentName, String companyId, String orgCode, RoleBo role) throws IllegalAccessException, InstantiationException;

    CommonResponse list(String toke, String product, String appKey, LatentDangerListParam latentDangerListParam, AgencyUserModel user, String loginOrgCode, String deptId);

    /**
     * 隐患流程执行
     *
     * @param latentDangerExecuteParam
     * @param userId
     * @param userRealName
     * @param departmentId
     * @param departmentName
     * @param role
     * @return
     */
    DangerExecuteSubmitDto execute(LatentDangerExecuteParam latentDangerExecuteParam, String userId,
                                   String userRealName, String departmentId, String departmentName, RoleBo role);

    CommonResponse detail(String id, String userId,boolean isFinish);

    CommonResponse getByInstanceId(String instanceId);

    DangerExecuteSubmitDto executeCallBack(String instanceId, Integer actionType, String remark, String token, String userId,
                                           String userRealName, String departmentId, String departmentName);

    void updateDangerStateOfOvertime();

    CommonResponse listFlowRecord(String token, String product, String appKey, Long id);

    void sendLatentDangerExecuteResult(DangerExecuteSubmitDto executeSubmitDto);

    void freshRiskJudgmentLangerCount(LatentDangerExecuteParam latentDangerExecuteParam);

    /**
     * 获取隐患等级字典值
     *
     * @return
     */
    List<DictionarieValueModel> getDangerLevel();

    /**
     * 获取隐患治理方式字典值
     *
     * @return
     */
    List<DictionarieValueModel> getDangerGovernance();

//    /**
//     * 根据等级字符串获取等级字典对象
//     *
//     * @param dangerLevelStr 等级（"1","2","0"）
//     * @return
//     */
//    JSONObject getDangerLevelJsonObject(String dangerLevelStr, String token, String product, String appKey, String dictCode);

    /**
     * 根据隐患id获取评审信息
     *
     * @param dangerId
     * @return
     */
    JSONObject getReviewInfo(Long dangerId);

    Page<DangerListResponse> listDanger(PageParam pageParam);

    List<DangerListResponse> export(PageParam pageParam);

    List<DangerTimeAxisVo> queryExecuteLog(Integer dateTime);

}
