package com.yeejoin.amos.latentdanger.core.aop;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.latentdanger.business.constants.Constants;
import com.yeejoin.amos.latentdanger.common.enums.LatentDangerLevelEnum;
import com.yeejoin.amos.latentdanger.common.enums.LatentDangerReformTypeEnum;
import com.yeejoin.amos.latentdanger.common.enums.LatentDangerStateEnum;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author DELL
 */
@Aspect
@Component
public class EnumFillAop {
    @Pointcut("execution(public * com.yeejoin.amos.latentdanger.business.controller..*(..))")
    public void fillEnum() {

    }

    @Before("fillEnum()")
    public void doBefore(JoinPoint joinPoint) {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String bizType = request.getHeader("bizType");
        if (bizType == null) {
            bizType = request.getParameter("bizType");
        }

        // 获取隐患等级枚举
        if (ValidationUtil.isEmpty(LatentDangerLevelEnum.enumMap)) {
            List<DictionarieValueModel> dicResult =
                    Systemctl.dictionarieClient.dictValues(bizType + LatentDangerLevelEnum.dictCode).getResult();
            dicResult.forEach(dic -> LatentDangerLevelEnum.addEnumDynamic(dic.getDictDataDesc(), dic.getDictDataValue(), dic.getDictDataKey(),
                    "", dic.getOrderNum()));
        }
        // 获取治理方式枚举
        if (ValidationUtil.isEmpty(LatentDangerReformTypeEnum.enumMap)) {
            List<DictionarieValueModel> dicResult =
                    Systemctl.dictionarieClient.dictValues(bizType + LatentDangerReformTypeEnum.dictCode).getResult();
            dicResult.forEach(dic -> LatentDangerReformTypeEnum.addEnumDynamic(dic.getDictDataDesc(), dic.getDictDataValue(), dic.getDictDataKey()));
        }
        // 获取治理状态枚举
        if (ValidationUtil.isEmpty(LatentDangerStateEnum.enumMap)) {
            List<DictionarieValueModel> dicResult =
                    Systemctl.dictionarieClient.dictValues(bizType + LatentDangerStateEnum.dictCode).getResult();
            dicResult.forEach(dic -> LatentDangerStateEnum.addEnumDynamic(dic.getDictDataDesc(), dic.getDictDataValue(), dic.getDictDataKey()));
        }
    }
}
