package com.yeejoin.amos.supervision.business.controller;

import com.yeejoin.amos.supervision.business.service.intfc.IRoutePointItemService;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.business.util.CommonResponseUtil;
import com.yeejoin.amos.supervision.dao.entity.Plan;
import com.yeejoin.amos.supervision.dao.entity.RoutePointItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

/**
 * @author gaojianqiang
 * @date 2021/09/10 11:28
 */
@RestController
@RequestMapping(value = "/api/routePointItem")
@Api(tags = "巡检路线点项api")
public class RoutePointItemController extends AbstractBaseController {

    private final Logger log = LoggerFactory.getLogger(RoutePointItemController.class);

    @Autowired
    private IRoutePointItemService routePointItemService;

    /**
     * 增加巡检路线点项关系
     *
     * @param plan         巡检计划
     * @param inputItemIds 巡检项IDS
     * @return CommonResponse
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "新增巡检路线点项关系", notes = "新增巡检路线点项关系")
    @PostMapping(value = "/addRoutePointItem", produces = "application/json;charset=UTF-8")
    public CommonResponse addRoute(@ApiParam(value = "巡检计划", required = true) @RequestBody Plan plan,
                                   @ApiParam(value = "检查项IDS", required = true) @RequestParam List<Long> inputItemIds) {
        try {
            String userId = getUserId();
            if (StringUtils.isNotBlank(userId)) {
                List<RoutePointItem> list = routePointItemService.addRoutePointItemList(plan, inputItemIds, userId);
                if (CollectionUtils.isNotEmpty(list)) {
                    return CommonResponseUtil.success();
                }
                return CommonResponseUtil.failure("路线点或检查项为空！");
            }
            return CommonResponseUtil.failure("创建用户为空！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("巡检路线点项关系新增失败！");
        }
    }
}
