package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 厂(场)内机动车辆
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialVehicleModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 设备全省唯一编号
     */
    private String sequenceCode;
    /**
     * 运行速度(km/h)
     */
    private String runningSpeed;
    /**
     * 最高时速(km/h)
     */
    private String topSpeed;
    /**
     * 额定载荷(kg)
     */
    private String ratedLoad;
    /**
     * 动力方式
     */
    private String powerMode;
    /**
     * 车牌号码
     */
    private String carNum;
    /**
     * 驱动
     */
    private String drive;
    /**
     * 空车重量
     */
    private String emptyWeight;
    /**
     * 发动机编号
     */
    private String engineNum;
    /**
     * 有否拖挂车
     */
    private String isTrailer;
    /**
     * 设备型号/厂牌型号
     */
    private String equModel;
    /**
     * 座位数量
     */
    private String seatNum;
    /**
     * 底盘编号
     */
    private String chassisNum;
    /**
     * 燃料种类
     */
    private String fuelType;
    /**
     * 颜色（字典）
     */
    private String colour;

}
