package com.yeejoin.amos.boot.module.tcm.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.*;

import java.util.Date;

/**
 * 风险报送表
 *
 * @author system_generator
 * @date 2025-08-08
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("tzs_risk_report")
public class RiskReport extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 报送编号
     */
	@TableField("report_no")
    private String reportNo;

    /**
     * 风险类型code 平台字典值 RISK_TYPE
     */
    @TableField("risk_type_code")
    private String riskTypeCode;

    /**
     * 风险类型name 平台字典值 RISK_TYPE
     */
    @TableField("risk_type_name")
    private String riskTypeName;

    /**
     * 报送单位seq
     */
	@TableField("report_company_seq")
    private String reportCompanySeq;

    /**
     * 报送单位code
     */
	@TableField("report_company_code")
    private String reportCompanyCode;

    /**
     * 报送单位name
     */
	@TableField("report_company_name")
    private String reportCompanyName;

    /**
     * 风险企业seq
     */
	@TableField("risk_company_seq")
    private String riskCompanySeq;

    /**
     * 风险企业code
     */
	@TableField("risk_company_code")
    private String riskCompanyCode;

    /**
     * 风险企业name
     */
	@TableField("risk_company_name")
    private String riskCompanyName;

    /**
     * 风险处置单位seq
     */
	@TableField("risk_disposal_unit_seq")
    private String riskDisposalUnitSeq;

    /**
     * 风险处置单位code
     */
	@TableField("risk_disposal_unit_code")
    private String riskDisposalUnitCode;

    /**
     * 风险处置单位name
     */
	@TableField("risk_disposal_unit_name")
    private String riskDisposalUnitName;

    /**
     * 风险处置单位orgCode（考虑到转办，当前单位和此orgCode相同才有处置权限，转办会更新此三项）
     */
	@TableField("risk_disposal_unit_org_code")
    private String riskDisposalUnitOrgCode;

    /**
     * 经手的风险处置单位orgCode（转办会增加此项内容）
     */
	@TableField("all_risk_disposal_unit_org_code")
    private String allRiskDisposalUnitOrgCode;

    /**
     * 风险关联设备recod(目前没用到，冗余)
     */
	@TableField("risk_equip_record")
    private String riskEquipRecord;

    /**
     * 操作人userId
     */
    @TableField("operation_user_id")
    private String operationUserId;

    /**
     * 风险正文-标题
     */
	@TableField("risk_main_title")
    private String riskMainTitle;

    /**
     * 风险正文-内容
     */
	@TableField("risk_main_content")
    private String riskMainContent;

    /**
     * 风险正文-附件
     */
	@TableField("risk_main_file")
    private String riskMainFile;

    /**
     * 报送员userId
     */
	@TableField("report_user_id")
    private String reportUserId;

    /**
     * 报送员userName
     */
	@TableField("report_user_name")
    private String reportUserName;

    /**
     * 报送员phone
     */
	@TableField("report_user_phone")
    private String reportUserPhone;

    /**
     * 当前阶段（草稿/监管处置/企业整改）
     */
	@TableField("current_stage")
    private String currentStage;

    /**
     * 当前状态（草稿/待处理/待整改/待确认/已办理）
     */
	@TableField("current_status")
    private String currentStatus;

    /**
     * 处置结束时间
     */
	@TableField("end_date")
    private Date endDate;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人id
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

}
