package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 大屏筛选过滤对象
 *
 * @author Administrator
 */
@Data
public class DPFilterParamDto {
    /**
     * 区域
     */
    @NotBlank(message = "区域编码不能为空！")
    private String cityCode;

    /**
     * 数据统计的开始日期
     */
    private String beginDate;

    /**
     * 数据统计的结束日期
     */
    private String endDate;

    /**
     * 业务类型0告知管理，1使用登记，2变更登记，3停用启用，4注销报废
     */
    private String businessKey;

    /**
     * month , year
     */
    private String searchType;
    /**
     * 1生产单位 2使用单位 3充装单位 4检验检测机构
     */
    private String companyType;
    /**
     * 监管单位名称（接收单位/管辖机构）
     */
    private String superviseUnitName;

    /**
     * 企业单位名称（发起单位/使用单位）
     */
    private String companyName;
}
