package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.CylinderFillingRecordStatisticsDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.CylinderDPStatisticsServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.dto.SubTreeDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.ESCylinderFillingRecordDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 气瓶基本信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@RestController
@Api(tags = "大屏-气瓶统计Api")
@RequestMapping(value = "/dp/cylinder")
public class CylinderDPStatisticsController extends BaseController {

    private CylinderDPStatisticsServiceImpl dpStatisticsService;

    public CylinderDPStatisticsController(CylinderDPStatisticsServiceImpl dpStatisticsService) {
        this.dpStatisticsService = dpStatisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getCylinderStatisticsData")
    @ApiOperation(httpMethod = "GET", value = "大屏-气瓶-企业气瓶数量排名", notes = "大屏-气瓶-企业气瓶数量排名")
    public ResponseModel<List<Map<String, Object>>> getCylinderStatisticsData(@RequestParam(value = "regionCode") String regionCode) throws IOException {
        List<Map<String, Object>> result = dpStatisticsService.getCylinderStatisticsData(regionCode);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getCylinderStatisticsDataByCity")
    @ApiOperation(httpMethod = "POST", value = "大屏-气瓶-区域统计", notes = "大屏-气瓶-区域统计")
    public ResponseModel<Map<String, Object>> getCylinderStatisticsDataByCity(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult bindingResult) throws Exception {
        List<FieldError> fieldErrors = bindingResult.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Map<String, Object> result = dpStatisticsService.getCylinderStatisticsDataByCity(dpFilterParamDto);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getCylinderStatisticsDataByCityForTotal")
    @ApiOperation(httpMethod = "POST", value = "大屏-气瓶-地图统计图列", notes = "大屏-气瓶-地图统计图列")
    public ResponseModel<Map<String, Object>> getCylinderStatisticsDataByCityForTotal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult bindingResult) throws Exception {
        List<FieldError> fieldErrors = bindingResult.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Map<String, Object> result = dpStatisticsService.getCylinderStatisticsDataByCityForTotal(dpFilterParamDto);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getCylinderStatisticsDataByCityForMap")
    @ApiOperation(httpMethod = "POST", value = "大屏-气瓶-中间地图", notes = "大屏-气瓶-中间地图")
    public ResponseModel<List<Map<String, Object>>> getCylinderStatisticsDataByCityForMap(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult bindingResult) throws Exception {
        List<FieldError> fieldErrors = bindingResult.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        List<Map<String, Object>> result = dpStatisticsService.getCylinderStatisticsDataByCityForMap(dpFilterParamDto);
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "30天的充装量、卸液量数据")
    @GetMapping(value = "/fillingTimesAndQuantity")
    public ResponseModel<List<CylinderFillingRecordStatisticsDto>> fillingTimesAndQuantity(@RequestParam("regionCode") String reginCode) {
        return ResponseHelper.buildResponse(dpStatisticsService.fillingTimesAndQuantity(reginCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏气瓶问题列表")
    @PostMapping(value = "/cylinderIssueMonthList")
    public ResponseModel<List<Map<String, Object>>> cylinderIssueMonthList(@RequestBody Map<String, Object> map) {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        return ResponseHelper.buildResponse(dpStatisticsService.cylinderIssueMonthList(regionCode.toString()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "区域气站对接率排名")
    @PostMapping(value = "/stationRate")
    public ResponseModel<List<Map<String, Object>>> stationRate(@RequestBody DPFilterParamDto dpFilterParamDto) {
        return ResponseHelper.buildResponse(dpStatisticsService.stationRate(dpFilterParamDto));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "区域安全指数排名下钻树节点")
    @PostMapping(value = "/securityIndexSubTree")
    public ResponseModel<SubTreeDto> securityIndexSubTree() {
        return ResponseHelper.buildResponse(dpStatisticsService.securityIndexSubTree());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "区域安全指数排名下钻柱状图")
    @PostMapping(value = "/securityIndexSubChart")
    public ResponseModel<Map<String, Object>> securityIndexSubChart(@RequestBody DPFilterParamDto dpFilterParamDto) {
        return ResponseHelper.buildResponse(dpStatisticsService.securityIndexSubChart(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "充装量/卸液量下钻树节点")
    @PostMapping(value = "/getFillingSubTree")
    public ResponseModel<SubTreeDto> getFillingSubTree() {
        return ResponseHelper.buildResponse(dpStatisticsService.getFillingSubTree());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "充装量/卸液量下钻柱状图")
    @PostMapping(value = "/getFillingSubChart")
    public ResponseModel<Map<String, Object>> getFillingSubChart(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        return ResponseHelper.buildResponse(dpStatisticsService.getFillingSubChart(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "充装量/卸液量下钻列表")
    @PostMapping(value = "/getFillingSubPage")
    public ResponseModel<Page<ESCylinderFillingRecordDto>> getFillingSubPage(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        return ResponseHelper.buildResponse(dpStatisticsService.getFillingSubPage(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "充装量/卸液量下钻气瓶充装异常情况下拉")
    @PostMapping(value = "/getFillingSubAnomalyType")
    public ResponseModel<Object> getFillingSubAnomalyType() {
        return ResponseHelper.buildResponse(dpStatisticsService.getFillingSubAnomalyType());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "区域气站对接率下钻树节点")
    @PostMapping(value = "/getStationRateSubTree")
    public ResponseModel<SubTreeDto> getStationRateSubTree() {
        return ResponseHelper.buildResponse(dpStatisticsService.getStationRateSubTree());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "区域气站对接率下钻图")
    @PostMapping(value = "/getStationRateSubChart")
    public ResponseModel<Map<String, Object>> getStationRateSubChart(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        return ResponseHelper.buildResponse(dpStatisticsService.getStationRateSubChart(dpFilterParamForDetailDto));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "区域气站对接率下钻列表")
    @PostMapping(value = "/getStationRateSubPage")
    public ResponseModel<IPage<TzBaseEnterpriseInfoDto>> getStationRateSubPage(@RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        return ResponseHelper.buildResponse(dpStatisticsService.getStationRateSubPage(dpFilterParamForDetailDto));
    }




}
