package com.yeejoin.amos.boot.module.elevator.api.service;


import com.yeejoin.amos.boot.module.elevator.api.dto.RescueProcessDto;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import java.text.ParseException;

/**
 * 救援过程表接口类
 *
 * @author kongfm
 * @date 2021-08-03
 */
public interface IRescueProcessService {

    /**
     * 根据警情id 创建救援过程表 或者获取 救援过程表
     * @param alertId
     * @return
     */
    RescueProcessDto getProcessByAlertId(Long alertId);

    /**
     * 根据警情id 更新救援过程表
     * @param rescueProcessDto
     * @return
     */
    Boolean updateByAlertId(RescueProcessDto rescueProcessDto, AgencyUserModel sendUser) throws ParseException;

    /**
     * 根据警情id 更新救援过程表
     * @param rescueProcessDto
     * @return
     */
    Boolean updateByAlertId(RescueProcessDto rescueProcessDto);

}
