package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.FireChemicalDto;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireChemicalServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;
import java.util.List;


/**
 * 危化品
 *
 * @author system_generator
 * @date 2021-06-29
 */
@RestController
@Api(tags = "危化品Api")
@RequestMapping(value = "/common/fire-chemical")
public class FireChemicalController extends BaseController {

    @Autowired
    FireChemicalServiceImpl fireChemicalServiceImpl;

    /**
     * 新增危化品
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增危化品", notes = "新增危化品")
    public ResponseModel<FireChemicalDto> save(@RequestBody FireChemicalDto model) {
        model = fireChemicalServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新危化品", notes = "根据sequenceNbr更新危化品")
    public ResponseModel<FireChemicalDto> updateBySequenceNbrFireChemical(@RequestBody FireChemicalDto model,
                                                                          @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(fireChemicalServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batch")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除危化品", notes = "根据sequenceNbr删除危化品")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam(value = "ids") String sequenceNbr) {

        @SuppressWarnings("rawtypes")
        List lt = Arrays.asList(sequenceNbr.split(","));
        return ResponseHelper.buildResponse(fireChemicalServiceImpl.updateisDelete(lt));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个危化品", notes = "根据sequenceNbr查询单个危化品")
    public ResponseModel<FireChemicalDto> seleteOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireChemicalServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "危化品分页查询", notes = "危化品分页查询")
    public ResponseModel<Page<FireChemicalDto>> queryForPage(@RequestParam(value = "current") int current,
                                                             @RequestParam(value = "size") int size, String casNo,
                                                             String formula, String name, String typeCode) {
        Page<FireChemicalDto> page = new Page<FireChemicalDto>();
        page.setCurrent(current);
        page.setSize(size);
        boolean isDelete = false;
        return ResponseHelper.buildResponse(fireChemicalServiceImpl.queryForFireChemicalPage(page, casNo, formula,
                name, typeCode, isDelete));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "危化品列表全部数据查询", notes = "危化品列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireChemicalDto>> selectForList() {
        return ResponseHelper.buildResponse(fireChemicalServiceImpl.queryForFireChemicalList(null,null,null,null,false));
    }
}
