package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonDto;
import com.yeejoin.amos.boot.module.common.api.entity.DutyPersonShift;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 值班人员日期关联关系表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-07-06
 */
public interface DutyPersonShiftMapper extends BaseMapper<DutyPersonShift> {

    /**
     * 计算班次最大执勤人数，时间区间内
     * 计算天的最大班次数量，时间区间内
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @param appKey    应用标识
     * @param groupCode 分组标识
     * @return Map
     */
    Map<String, Long> calMaxPersonAndShiftNum(
            @Param("beginDate") String beginDate,
            @Param("endDate") String endDate,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode
    );

    /**
     * 银行日历视图
     *
     * @param dutyDate  日期
     * @param appKey    应用标识
     * @param groupCode 分组标识
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> bankViewData(
            @Param("dutyDate") String dutyDate,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode
    );

    /**
     * 换流站日历视图
     *
     * @param dutyDate  日期
     * @param appKey    应用标识
     * @param groupCode 分组标识
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> stationViewData(
            @Param("dutyDate") String dutyDate,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode
    );
    
    List<Map<String, Object>> newStationViewData(
            @Param("dutyDate") String dutyDate,
            @Param("groupCode") String groupCode
    );
    /**
     * 利用mysql 生成连续时间区间
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> genRangeDate(
            @Param("beginDate") String beginDate,
            @Param("endDate") String endDate
    );
    /**
     * 获取指定日期下的当前排班的人员列表
     * eg : {"name":"夜班","value":"李某某、张作霖、张作相"}
     * @param dutyDate
     * @param groupCode
     * @param targetFiled
     * @return
     */
    List<Map<String, Object>> getSpecifyDateList(String dutyDate,String groupCode,String[] instanceIds,String params);
    
    /**
     * 获取指定日期下的装备ID、eg:车辆、微型消防站
     * @param dutyDate
     * @param groupCode
     * @param targetFiled
     * @return
     */
    List<Map<String, Object>> getEquipmentForSpecifyDate(String dutyDate,String groupCode,String equipmentId,String equipmentName,String teamName,String groupByName);
    
    
    /**
     * 通过装备ID查询指定如期下的该装备所包含的InstanceId
     * @param dutyDate
     * @param groupCode
     * @param targetId eg: carId
     * @return
     */
    Map<String, Object>  getInstanceIdForSpecifyDateAndEquipment(String dutyDate,String groupCode,String targetId);
    
    /**
     * 获取指定日期装备的操作人员，例如车辆的驾驶员
     * @param dutyDate
     * @param groupCode
     * @param instanceIds
     * @param operator
     * @return
     */
    Map<String, Object>  getEquipmentOperator(String dutyDate,String groupCode,String[] instanceIds,String operator,String duty);
    
    
    /**
     * 获取指定日期下的排班人员与岗位等信息
     * @param dutyDate
     * @param groupCode
     * @param instanceIds
     * @return
     */
    List<Map<String, Object>> getPositionStaffDutyForSpecifyDate(String dutyDate,String groupCode,String[] instanceIds,String duty);
    
    
    /**
     * 获取指定日期下的班次信息
     * @param duty
     * @return
     */
    List<Map<String, Object>>  getDutyForSpecifyDate(String duty);
    
    Map<String, Object>   getFireTeamBySequenceNbr (long sequenceNbr);
    
    List<Map<String, Object>>   getFirstAidForTypeCodeAndCompanyId(long company);

    List<Map<String, Object>> queryByCompanyId(@Param(value="bizNames") List<String> bizNames);

    List<Map<String, Object>>  queryByCompanyNew(String bizOrgName);
    
    List<Map<String, Object>> getNewEquipmentForSpecifyDate(String dutyDate,String groupCode,String equipmentId,String equipmentName,String groupByName);

    String getFirstAidCompanyId ();
}
