package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import org.apache.ibatis.annotations.Select;
import org.checkerframework.checker.index.qual.SameLen;

import java.util.List;

/**
 * 用于业务变更过程中的历史数据处理的mapper层
 */
public interface DataHandlerMapper {

    @Select("SELECT ui.\"RECORD\" \n" +
            "FROM \"amos_tzs_biz\".\"idx_biz_jg_use_info\" ui \n" +
            "INNER JOIN \"amos_tzs_biz\".\"idx_biz_jg_register_info\" ri \n" +
            "    ON ui.\"RECORD\" = ri.\"RECORD\"\n" +
            "WHERE ui.\"DATA_SOURCE\" = 'jg_his' \n" +
            "AND ui.\"EQU_STATE\" IS NULL \n" +
            "AND ri.\"EQU_CATEGORY\" = '2300' \n" +
            "AND NOT EXISTS (\n" +
            "    SELECT 1 \n" +
            "    FROM amos_tzs_biz.tzs_jg_scrap_cancel_eq sceq\n" +
            "    INNER JOIN amos_tzs_biz.tzs_jg_scrap_cancel sc \n" +
            "        ON sceq.\"equip_transfer_id\" = sc.\"sequence_nbr\"\n" +
            "    WHERE sc.\"audit_status\" = '已完成' \n" +
            "    AND sceq.\"equ_id\" = ui.\"RECORD\"\n" +
            ")\n" +
            "AND NOT EXISTS (\n" +
            "    SELECT 1 \n" +
            "    FROM amos_tzs_biz.tzs_jg_enable_disable_eq edeq\n" +
            "    INNER JOIN amos_tzs_biz.tzs_jg_enable_disable ed \n" +
            "        ON edeq.\"enable_disable_apply_id\" = ed.\"sequence_nbr\"\n" +
            "    WHERE ed.\"audit_status\" = '已完成' \n" +
            "    AND edeq.\"equ_id\" = ui.\"RECORD\"\n" +
            ")")
    List<String> selectOrdinaryHisGasCylinder();

    @Select("SELECT ui.\"RECORD\" \n" +
            "FROM \"amos_tzs_biz\".\"idx_biz_jg_use_info\" ui \n" +
            "INNER JOIN \"amos_tzs_biz\".\"idx_biz_jg_register_info\" ri \n" +
            "    ON ui.\"RECORD\" = ri.\"RECORD\"\n" +
            "WHERE ui.\"DATA_SOURCE\" = 'jg' \n" +
            "AND ui.\"EQU_STATE\" IS NULL \n" +
            "AND ri.\"EQU_CATEGORY\" = '2300' \n" +
            "AND NOT EXISTS (\n" +
            "    SELECT 1 \n" +
            "    FROM amos_tzs_biz.tzs_jg_use_registration_eq ureq\n" +
            "    INNER JOIN amos_tzs_biz.tzs_jg_use_registration ur \n" +
            "        ON ureq.\"equip_transfer_id\" = ur.\"sequence_nbr\"\n" +
            "    WHERE ur.\"status\" = '已完成' \n" +
            "    AND ureq.\"equ_id\" = ui.\"RECORD\"\n" +
            ")")
    List<String> selectOrdinaryGasCylinder();
}

