package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.jg.biz.core.BaseService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgDesignInfoService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgDesignInfo;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgDesignInfoMapper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 安全追溯-设计信息表服务实现类
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Service
public class IdxBizJgDesignInfoServiceImpl extends BaseService<IdxBizJgDesignInfoMapper, IdxBizJgDesignInfo> implements IIdxBizJgDesignInfoService {

    public boolean saveOrUpdateData(IdxBizJgDesignInfo designInfo) {
        return super.saveOrUpdateWithNull(designInfo);
    }

    @Override
    public boolean saveOrUpdateBatch(List<IdxBizJgDesignInfo> designInfoList) {
        return super.saveOrUpdateBatch(designInfoList);
    }

    @Override
    public IdxBizJgDesignInfo getOneData(String record) {
        return this.getOne(new QueryWrapper<IdxBizJgDesignInfo>().eq("RECORD", record));
    }

    @Override
    public void updateBatchByRecord(List<IdxBizJgDesignInfo> toUpdateDesignInfoList) {
        toUpdateDesignInfoList.forEach(info -> super.update(info, new LambdaUpdateWrapper<IdxBizJgDesignInfo>().eq(IdxBizJgDesignInfo::getRecord, info.getRecord())));
    }

    public List<IdxBizJgDesignInfo> checkOverDesignRegNum(List<String> records) {
        if (records == null || records.isEmpty()) {
            return Collections.emptyList();
        }
        List<IdxBizJgDesignInfo> allRecords = list(new QueryWrapper<IdxBizJgDesignInfo>()
                .lambda().in(IdxBizJgDesignInfo::getRecord, records)
                .orderByDesc(IdxBizJgDesignInfo::getRecDate));

        return new ArrayList<>(allRecords.stream()
                .collect(Collectors.toMap(
                        IdxBizJgDesignInfo::getRecord,
                        Function.identity(),
                        (existing, replacement) -> existing,
                        LinkedHashMap::new
                ))
                .values());
    }
}