package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.biz.job.InspectionExpireRemindJob;
import com.yeejoin.amos.boot.module.jyjc.biz.service.TaskModelServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author system_generator
 * @date 2023-12-13
 */
@RestController
@Api(tags = "公共接口controller")
@RequestMapping(value = "/common")
public class CommonController extends BaseController {

    @Autowired
    CommonServiceImpl commonserviceImpl;

    @Autowired
    TaskModelServiceImpl taskModelService;

    @Autowired
    InspectionExpireRemindJob regularlyRemindJob;

    private final static String SBZL_DICT_PRIFIX = "JYJC_SBZL";

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getJyjcPersonByUnitCode")
    @ApiOperation(httpMethod = "GET", value = "根据公司的unitCode获取检测检验人员列表", notes = "根据公司的unitCode获取检测检验人员列表")
    public ResponseModel<List<TzsUserInfo>> getUserInfosByUnitCode(@RequestParam String unitCode) {
        return ResponseHelper.buildResponse(commonserviceImpl.getUserInfosByUnitCode(unitCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getBizUserInfosByUnitCode")
    @ApiOperation(httpMethod = "GET", value = "根据公司的unitCode获取检测检验业务办理人员列表", notes = "根据公司的unitCode获取检测检验人员列表")
    public ResponseModel<List<TzsUserInfo>> getBizUserInfosByUnitCode(@RequestParam String unitCode) {
        return ResponseHelper.buildResponse(commonserviceImpl.getBizUserInfosByUnitCode(unitCode));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getUserPhonesByPersonCode")
    @ApiOperation(httpMethod = "GET", value = "根据公司的unitCode获取检测检验人员联系电话", notes = "根据公司的unitCode获取检测检验人员联系电话")
    public ResponseModel<Map<String, Object>> getUserPhonesByPersonCode(@RequestParam String unitCode) {
        if (unitCode.contains("_")) {
            unitCode = unitCode.split("_")[0];
        }
        List<TzsUserInfo> userPhones = commonserviceImpl.getUserPhonesByPersonCode(unitCode);
        if (CollectionUtils.isEmpty(userPhones)) {
            return null;
        }
        List<String> phones = userPhones.stream().map(TzsUserInfo::getPhone).collect(Collectors.toList());
        String phone = String.join(",", phones);
        Map<String, Object> map = new HashMap<>();
        map.put("phone", phone);
        return ResponseHelper.buildResponse(map);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getInnerPersonCodeByPersonCode")
    @ApiOperation(httpMethod = "POST", value = "根据公司的unitCode获取检测检验人员内部编号", notes = "根据公司的unitCode获取检测检验人员内部编号")
    public ResponseModel<Map<String, Object>> getInnerPersonCodeByPersonCode(@RequestParam String unitCode) {
        if (unitCode.contains("_")) {
            unitCode = unitCode.split("_")[0];
        }
        List<TzsUserInfo> userPhones = commonserviceImpl.getUserPhonesByPersonCode(unitCode);
        if (CollectionUtils.isEmpty(userPhones)) {
            return null;
        }
        List<String> phones = userPhones.stream().filter(e -> StringUtils.isNotEmpty(e.getInnerPersonCode())).map(TzsUserInfo::getInnerPersonCode).collect(Collectors.toList());
        Map<String, Object> map = new HashMap<>();
        if (CollectionUtils.isEmpty(phones)) {
            map.put("innerPersonCode", " ");
        } else {
            String innerPersonCode = String.join(",", phones);
            map.put("innerPersonCode", innerPersonCode);
        }

        return ResponseHelper.buildResponse(map);
    }

    /**
     * 查询检验检测机构列表（基本信息及联系人）
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getInspectionUnitList")
    @ApiOperation(httpMethod = "GET", value = "查询检验检测机构列表（基本信息及联系人）", notes = "查询检验检测机构列表（基本信息及联系人）")
    public ResponseModel<List<TzBaseEnterpriseInfoDto>> getInspectionUnitList(@RequestParam String openBizType) {
        return ResponseHelper.buildResponse(commonserviceImpl.getInspectionUnitList(openBizType));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getInspectionUnit/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "查询检验检测机构基本信息", notes = "查询检验检测机构基本信息")
    public ResponseModel<TzBaseEnterpriseInfo> getInspectionUnitBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(commonserviceImpl.getInspectionUnitBySequenceNbr(sequenceNbr));
    }


    /**
     * 公共转办接口
     * /common/transfer
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/kt/transfer")
    @ApiOperation(httpMethod = "POST", value = "公共转办接口-开通", notes = "公共转办接口-开通")
    public ResponseModel<Object> transferKT(@RequestBody Map<String, Object> map) {
        map.put("key", "workflow_prostance_id");
        Object result = taskModelService.transfer(map);
        return ResponseHelper.buildResponse(result);
    }

    /**
     * 公共转办接口
     * /common/transfer
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/bj/transfer")
    @ApiOperation(httpMethod = "POST", value = "公共转办接口-报检", notes = "公共转办接口-报检")
    public ResponseModel<Object> transferBJ(@RequestBody Map<String, Object> map) {
        map.put("key", "instance_id");
        Object result = taskModelService.transfer2(map);
        return ResponseHelper.buildResponse(result);
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{unitCode}/user-list")
    @ApiOperation(httpMethod = "GET", value = "查询指定公司、指定人员类型的人员列表,范围为检验、检测、检验和检测人员", notes = "查询指定公司、指定人员类型的人员列表")
    public ResponseModel<List<TzsUserInfo>> getBizUserInfosByUnitCode(@ApiParam(value = "公司编码") @PathVariable String unitCode,
                                                                      @ApiParam(value = "人员类型", allowableValues = "jy,jc") @RequestParam String personType) {
        return ResponseHelper.buildResponse(commonserviceImpl.getUserListByUnitCodeAndPost(unitCode, personType));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equList")
    @ApiOperation(httpMethod = "GET", value = "按照业务类型查询设备种类，工作台使用", notes = "按照业务类型查询设备种类，工作台使用")
    public ResponseModel<List<DictionarieValueModel>> equList(@RequestParam(value = "inspectionType") String bizType) {
        String dictCode = String.format("%s_%s", SBZL_DICT_PRIFIX, bizType);
        return ResponseHelper.buildResponse(Systemctl.dictionarieClient.dictValues(dictCode).getResult());
    }

    @ApiOperation(httpMethod = "PUT", value = "检验消息提醒", notes = "检验消息提醒")
    @PutMapping(value = "/test-tip")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public ResponseModel<String> testMsgTip(){
        regularlyRemindJob.sendReminderMessage();
        return ResponseHelper.buildResponse("succese");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "amos/{unitCode}/users")
    @ApiOperation(httpMethod = "GET", value = "查询指定公司、指定人员类型的人员列表", notes = "查询指定公司、指定人员类型的人员列表")
    public ResponseModel<List<AgencyUserModel>> getAmosUseListByCompanyCode(@ApiParam(value = "公司编码") @PathVariable String unitCode) {
        return ResponseHelper.buildResponse(commonserviceImpl.getAmosUseListByCompanyCode(unitCode));
    }
}
