package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 验收状态枚举
 */
@Getter
@AllArgsConstructor
@SuppressWarnings("ALL")
public enum AcceptanceStatusEnum {

    待提交验收("待提交验收", "1","","0"),

    待投融验收("待投融验收", "2", "hygf_ys1","0"),

    投融验收不通过("投融验收不通过", "3", "hygf_ys2","1"),

    待法务验收("待法务验收", "4","hygf_ys2","0"),

    法务验收不通过("法务验收不通过", "5", "hygf_ys3","1"),

    待工程验收("待工程验收", "6", "hygf_ys3","0"),

    工程验收不通过("工程验收不通过", "7", "hygf_ys4","1"),

    是否线下验收("是否线下验收", "11", "hygf_ys4","0"),

    待线下验收("待线下验收", "8", "hygf_ys5","0"),

    线下验收不通过("线下验收不通过", "9", "hygf_ys6","1"),

    验收完成("验收完成", "10", "hygf_ys5","1"),
    线下验收完成("验收完成", "10", "hygf_ys6","0");

    /**
     * 名称，描述
     */
    private final String name;
    /**
     * 编码
     */
    private final String code;

    //节点key
    private final String key;

    //节点key
    private final String state;


    public static AcceptanceStatusEnum getNodeByCode(String code) {
        AcceptanceStatusEnum acceptanceStatusEnum = null;
        for (AcceptanceStatusEnum type : AcceptanceStatusEnum.values()) {
            if (code.equals(type.getCode())) {
                acceptanceStatusEnum = type;
                break;
            }
        }
        return acceptanceStatusEnum;
    }
    public static String getNodeByKey(String Key,String state) {
        AcceptanceStatusEnum acceptanceStatusEnum = null;
        for (AcceptanceStatusEnum type : AcceptanceStatusEnum.values()) {
            if (type.getKey().contains(Key)&&type.getState().equals(state)) {
                acceptanceStatusEnum = type;
                break;
            }
        }
        return acceptanceStatusEnum.getCode();
    }
}
