package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel(value = "AcceptanceDto", description = "验收管理DTO")
public class AcceptanceDto extends BaseDto {
    @ApiModelProperty(value = "电站编号")
    private String powerStationCode;

    @ApiModelProperty(value = "业主姓名")
    private String ownersName;

    @ApiModelProperty(value = "项目地址")
    private String projectAddressName;

    @ApiModelProperty(value = "服务代理商")
    private String serviceAgent;

    @ApiModelProperty(value = "提交日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Object acceptanceRecDate;

    @JsonIgnore
    @ApiModelProperty(value = "开始提交日期-[查询参数使用]")
    private String startSubmitDate;

    @JsonIgnore
    @ApiModelProperty(value = "截至提交日期-[查询参数使用]")
    private Object endSubmitDate;

    @ApiModelProperty(value = "整改单数量")
    private Integer rectificationOrderCount;

    @ApiModelProperty(value = "验收状态")
    private String acceptanceStatus;

    @ApiModelProperty(value = "验收状态描述")
    private String acceptanceStatusDesc;

    @ApiModelProperty(value = "整改状态")
    private String rectificationStatus;

    @ApiModelProperty(value = "整改状态描述")
    private String rectificationStatusDesc;

    @ApiModelProperty(value = "平台经销商单位ID")
    private Long amosDealerId;

    @ApiModelProperty(value = "区域公司ID")
    private Long regionCompanyId;

    @ApiModelProperty(value = "区域公司名称")
    private String regionalCompaniesName;




    /**
     * 工作流实例ID
     */
    private String instanceId;

    ///	下一个节点角色权限
    private String nextExecutorIds;

    //	任务发起人id
    private String promoter;

    //	流程下一节点id
    private String nextTaskId;
    //下一节点可执行人逗号分割	0	0
    private String nextExecuteUserIds;
    //工作流发起人id
    private String createUserId;
    //下个节点名称
    private String nextNodeName;
    //下个节点key
    private String nextNodeKey;


    //并网登记id

    private Long fonGridId;

    private Long workOrderId;

    private Long workOrderPowerStationId;

    private Long peasantHouseholdId;





}
