package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 施工电站施工资料
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PowerStationConstructionDataDto", description="施工电站施工资料")
public class PowerStationConstructionDataDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    private Long workOrderId;

    @ApiModelProperty(value = "施工状态")
    private String constructionStatus;

    @ApiModelProperty(value = "施工交底文件")
    private String constructionInstructionsFile;

    @ApiModelProperty(value = "劳动防护用品配置")
    private String laborProtectionEquipmentConfig;

    @ApiModelProperty(value = "施工前安全措施保障视频")
    private String safetyPrecautionVideo;

    @ApiModelProperty(value = "支架整体图一")
    private String bracketOverallPlan1;

    @ApiModelProperty(value = "支架整体图二")
    private String bracketOverallPlan2;

    @ApiModelProperty(value = "方阵倾角测试照片/规模")
    private String arrayInclinationTestPhoto;

    @ApiModelProperty(value = "方阵整体图一（全景）")
    private String arrayOverallPlan1;

    @ApiModelProperty(value = "方阵整体图二")
    private String arrayOverallPlan2;

    @ApiModelProperty(value = "方阵整体图三")
    private String arrayOverallPlan3;

    @ApiModelProperty(value = "逆变器整体图")
    private String inverterOverallPlan;

    @ApiModelProperty(value = "光伏电缆走线")
    private String photovoltaicCableRouting;

    @ApiModelProperty(value = "电表箱外部整体")
    private String electricityMeterBoxExterior;

    @ApiModelProperty(value = "电表箱内部整体")
    private String electricityMeterBoxInterior;

    @ApiModelProperty(value = "支架接地")
    private String bracketGrounding;

    @ApiModelProperty(value = "接地点")
    private String groundingPoint;

    @ApiModelProperty(value = "交流电缆走线")
    private String acCableRouting;

    @ApiModelProperty(value = "其他照片")
    private String otherPhotos;

    @ApiModelProperty(value = "备案附件")
    private String archiveAttachments;

    @ApiModelProperty(value = "安装人员信息")
    private String installerInfo;

    @ApiModelProperty(value = "施工组件信息")
    private String constructionComponentInfo;

    @ApiModelProperty(value = "施工逆变器信息")
    private String constructionInverterInfo;

    @ApiModelProperty(value = "施工采集器信息")
    private String constructionCollectorBoxInfo;

    @ApiModelProperty(value = "施工并网箱信息")
    private String constructionGridBoxInfo;

    private Long workOrderPowerStationId;

}
