package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * 发货单
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PreparationMoneyDto", description="发货单")
@JsonIgnoreProperties(ignoreUnknown = true)
public class PreparationMoneyDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    /**
     *   发货单号
     */
    private String oddNumbers;



    /**
     *  下单人
     */
    private String orderUser;

    /**
     * 下单时间
     */
    private Date orderTime;


    /**
     * 经销商单位名称
     */
    private String amosUnitName;

    /**
     * 经销商单位id
     */
    private Long amosUnitId;
    /**
     * 经销商orgcode
     */
    private String amosUnitOrgCode;


    /**
     * 所属区域公司id
     */
    private Long regionalCompaniesSeq;

    /**
     * 所属区域公司名称
     */
    private String regionalCompaniesName;

    /**
     * 所属区域公司code
     */
    private String regionalCompaniesCode;

    /**
     * 发货人
     */
    private String shipper;

    /**
     * 预估重量
     */
    private Double estimatedWeight;

    /**
     * 备注
     */
    private String notes;

    /**
     * 发货状态0待发货1已发货成2已作废
     */
    private String deliveryState;

    /**
     * 到货货状态0待发货1已发货成2已作废
     */
    private String arrivalState;
    /**
     * 发货时间
     */
    private Date deliveryTime;
    /**
     * 到货时间
     */
    private Date arrivalTime;

    private String consignee;	//收货人

    private String phone;	//收货人电话

    private String consigneeRegion;	//收货区域

    private List<Integer> consigneeRegionCode;	//收货区域code

    private String address;	//收货详细地址
    //发货单
    private List<Object> deliveryFile;  //发货单

    private List<Object> arrivalFile; //收货单
}
