package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 验收检查项
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_acceptance_check_item",autoResultMap = true)
public class AcceptanceCheckItem extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 施工单ID
     */
    @TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站ID
     */
    @TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户ID
     */
    @TableField("peasant_household_id")
    private Long peasantHouseholdId;

    // ------------------------------------------------组件与组串------------------------------------------------
    /**
     * 型号
     */
    @TableField("assembly_model")
    private String assemblyModel;

    /**
     * 型号（备注）
     */
    @TableField("assembly_model_remark")
    private String assemblyModelRemark;

    /**
     * 功率
     */
    @TableField("assembly_power")
    private String assemblyPower;

    /**
     * 功率（备注）
     */
    @TableField("assembly_power_remark")
    private String assemblyPowerRemark;

    /**
     * 数量-组件
     */
    @TableField("assembly_quantity")
    private String assemblyQuantity;

    /**
     * 数量-组件（备注）
     */
    @TableField("assembly_quantity_remark")
    private String assemblyQuantityRemark;

    /**
     * 数量-组串
     */
    @TableField("string_quantity")
    private String stringQuantity;

    /**
     * 数量-组串（备注）
     */
    @TableField("string_quantity_remark")
    private String stringQuantityRemark;

    /**
     * 平整洁净程度
     */
    @TableField("cleanliness")
    private String cleanliness;

    /**
     * 平整洁净程度（备注）
     */
    @TableField("cleanliness_remark")
    private String cleanlinessRemark;

    /**
     * 完整无破损
     */
    @TableField("intact")
    private String intact;

    /**
     * 完整无破损（备注）
     */
    @TableField("intact_remark")
    private String intactRemark;

    /**
     * 无阴影遮挡
     */
    @TableField("shadow")
    private String shadow;

    /**
     * 无阴影遮挡（备注）
     */
    @TableField("shadow_remark")
    private String shadowRemark;

    /**
     * 组件高差
     */
    @TableField("assembly_height_difference")
    private String assemblyHeightDifference;

    /**
     * 组件高差（备注）
     */
    @TableField("assembly_height_difference_remark")
    private String assemblyHeightDifferenceRemark;

    /**
     * 组件间间距
     */
    @TableField("assembly_spacing")
    private String assemblySpacing;

    /**
     * 组件间间距（备注）
     */
    @TableField("assembly_spacing_remark")
    private String assemblySpacingRemark;

    /**
     * 同组组串倾角/方位角偏差
     */
    @TableField("string_angle_difference")
    private String stringAngleDifference;

    /**
     * 同组组串倾角/方位角偏差（备注）
     */
    @TableField("string_angle_difference_remark")
    private String stringAngleDifferenceRemark;

    /**
     * 组件固定螺栓力矩值
     */
    @TableField("assembly_bolt_force_moment")
    private String assemblyBoltForceMoment;

    /**
     * 组件固定螺栓力矩值（备注）
     */
    @TableField("assembly_bolt_force_moment_remark")
    private String assemblyBoltForceMomentRemark;

    /**
     * 组件序列号检查1
     */
    @TableField("assembly_serial_number_check_one")
    private String assemblySerialNumberCheckOne;

    /**
     * 组件序列号检查2
     */
    @TableField("assembly_serial_number_check_two")
    private String assemblySerialNumberCheckTwo;

    /**
     * 其他
     */
    @TableField("assembly_other")
    private String assemblyOther;

    // ------------------------------------------------逆变器------------------------------------------------
    /**
     * 型号
     */
    @TableField("inverter_model")
    private String inverterModel;

    /**
     * 型号（备注）
     */
    @TableField("inverter_model_remark")
    private String inverterModelRemark;

    /**
     * 完整无破损、受潮
     */
    @TableField("inverter_intact")
    private String inverterIntact;

    /**
     * 完整无破损、受潮（备注）
     */
    @TableField("inverter_intact_remark")
    private String inverterIntactRemark;

    /**
     * 安装高度
     */
    @TableField("inverter_installation_height")
    private String inverterInstallationHeight;

    /**
     * 安装高度（备注）
     */
    @TableField("inverter_installation_height_remark")
    private String inverterInstallationHeightRemark;

    /**
     * 交直流电缆绝缘良好
     */
    @TableField("inverter_cable_insulation")
    private String inverterCableInsulation;

    /**
     * 交直流电缆绝缘良好（备注）
     */
    @TableField("inverter_cable_insulation_remark")
    private String inverterCableInsulationRemark;

    /**
     * 电缆相序、极性正确
     */
    @TableField("inverter_cable_sequence")
    private String inverterCableSequence;

    /**
     * 电缆相序、极性正确（备注）
     */
    @TableField("inverter_cable_sequence_remark")
    private String inverterCableSequenceRemark;

    /**
     * 其他
     */
    @TableField("inverter_other")
    private String inverterOther;

    // ------------------------------------------------支架基础------------------------------------------------
    /**
     * 规格
     */
    @TableField("zipper_specification")
    private String zipperSpecification;

    /**
     * 规格（备注）
     */
    @TableField("zipper_specification_remark")
    private String zipperSpecificationRemark;

    /**
     * 数量（与设计图对比）
     */
    @TableField("zipper_quantity")
    private String zipperQuantity;

    /**
     * 数量（与设计图对比）（备注）
     */
    @TableField("zipper_quantity_remark")
    private String zipperQuantityRemark;

    /**
     * 支架焊接质量
     */
    @TableField("bracket_welding_quality")
    private String bracketWeldingQuality;

    /**
     * 支架焊接质量（备注）
     */
    @TableField("bracket_welding_quality_remark")
    private String bracketWeldingQualityRemark;

    /**
     * 不影响原建筑防水
     */
    @TableField("waterproof")
    private String waterproof;

    /**
     * 不影响原建筑水防（备注）
     */
    @TableField("waterproof_remark")
    private String waterproofRemark;

    /**
     * 支架之间螺丝紧固程度
     */
    @TableField("bracket_screws_tightness")
    private String bracketScrewsTightness;

    /**
     * 支架之间螺丝紧固程度（备注）
     */
    @TableField("bracket_screws_tightness_remark")
    private String bracketScrewsTightnessRemark;

    /**
     * 其他
     */
    @TableField("bracket_other")
    private String bracketOther;

    // ------------------------------------------------并网箱------------------------------------------------
    /**
     * 型号
     */
    @TableField("grid_box_model")
    private String gridBoxModel;

    /**
     * 型号（备注）
     */
    @TableField("grid_box_model_remark")
    private String gridBoxModelRemark;

    /**
     * 外观完整无破损、变形
     */
    @TableField("grid_box_intact")
    private String gridBoxIntact;

    /**
     * 外观完整无破损、变形（备注）
     */
    @TableField("grid_box_intact_remark")
    private String gridBoxIntactRemark;

    /**
     * 警示标识是否齐全
     */
    @TableField("grid_box_warning_mark")
    private String gridBoxWarningMark;

    /**
     * 警示标识是否齐全（备注）
     */
    @TableField("grid_box_warning_mark_remark")
    private String gridBoxWarningMarkRemark;

    /**
     * 箱内走线美观清晰
     */
    @TableField("grid_box_line_neat")
    private String gridBoxLineNeat;

    /**
     * 箱内走线美观清晰（备注）
     */
    @TableField("grid_box_line_neat_remark")
    private String gridBoxLineNeatRemark;

    /**
     * 元器件紧固螺栓完好
     */
    @TableField("grid_box_bolt_intact")
    private String gridBoxBoltIntact;

    /**
     * 元器件紧固螺栓完好（备注）
     */
    @TableField("grid_box_bolt_intact_remark")
    private String gridBoxBoltIntactRemark;

    /**
     * 防火封堵齐全
     */
    @TableField("fire_protection_complete")
    private String fireProtectionComplete;

    /**
     * 防火封堵齐全（备注）
     */
    @TableField("fire_protection_complete_remark")
    private String fireProtectionCompleteRemark;

    /**
     * 表箱接地线安装
     */
    @TableField("meter_box_ground_wire")
    private String meterBoxGroundWire;

    /**
     * 表箱接地线安装（备注）
     */
    @TableField("meter_box_ground_wire_remark")
    private String meterBoxGroundWireRemark;

    /**
     * 箱内无杂物
     */
    @TableField("box_clean")
    private String boxClean;

    /**
     * 箱内无杂物（备注）
     */
    @TableField("box_clean_remark")
    private String boxCleanRemark;

    /**
     * 安装高度
     */
    @TableField("box_installation_height")
    private String boxInstallationHeight;

    @TableField("box_installation_height_remark")
    private String boxInstallationHeightRemark;

    /**
     * 其他
     */
    @TableField("box_other")
    private String boxOther;

    // ------------------------------------------------电缆------------------------------------------------
    /**
     * 交、直、地规格
     */
    @TableField("cable_specification")
    private String cableSpecification;

    /**
     * 交、直、地规格（备注）
     */
    @TableField("cable_specification_remark")
    private String cableSpecificationRemark;

    /**
     * 交直流无同管敷设
     */
    @TableField("cable_laying")
    private String cableLaying;

    /**
     * 交直流无同管敷设（备注）
     */
    @TableField("cable_laying_remark")
    private String cableLayingRemark;

    /**
     * MC4安装牢固
     */
    @TableField("cable_mc4_intact")
    private String cableMc4Intact;

    /**
     * MC4安装牢固（备注）
     */
    @TableField("cable_mc4_intact_remark")
    private String cableMc4IntactRemark;

    /**
     * 电缆绝缘层无破损
     */
    @TableField("cable_insulation_intact")
    private String cableInsulationIntact;

    /**
     * 电缆绝缘层无破损（备注）
     */
    @TableField("cable_insulation_intact_remark")
    private String cableInsulationIntactRemark;

    /**
     * 电缆采用穿管或桥架保护
     */
    @TableField("cable_protection")
    private String cableProtection;

    /**
     * 电缆采用穿管或桥架保护（备注）
     */
    @TableField("cable_protection_remark")
    private String cableProtectionRemark;

    /**
     * 电缆进出箱柜端口有防火泥封堵
     */
    @TableField("cable_firewall")
    private String cableFirewall;

    /**
     * 电缆进出箱柜端口有防火泥封堵（备注）
     */
    @TableField("cable_firewall_remark")
    private String cableFirewallRemark;

    /**
     * 走线横平竖直
     */
    @TableField("cable_neat")
    private String cableNeat;

    /**
     * 走线横平竖直（备注）
     */
    @TableField("cable_neat_remark")
    private String cableNeatRemark;

    /**
     * 管卡间距
     */
    @TableField("cable_spacing")
    private String cableSpacing;

    /**
     * 管卡间距（备注）
     */
    @TableField("cable_spacing_remark")
    private String cableSpacingRemark;

    /**
     * 直角转弯间距
     */
    @TableField("cable_right_angle_spacing")
    private String cableRightAngleSpacing;

    /**
     * 直角转弯间距（备注）
     */
    @TableField("cable_right_angle_spacing_remark")
    private String cableRightAngleSpacingRemark;

    /**
     * 其他
     */
    @TableField("cable_other")
    private String cableOther;

    // ------------------------------------------------接地系统安装------------------------------------------------
    /**
     * 组件之间连接的接地线径
     */
    @TableField("ground_wire_diameter")
    private String groundWireDiameter;

    /**
     * 组件之间连接的接地线径（备注）
     */
    @TableField("ground_wire_diameter_remark")
    private String groundWireDiameterRemark;

    /**
     * 逆变器内部表箱接地接电线需要有鼻子
     */
    @TableField("ground_wire_nose")
    private String groundWireNose;

    /**
     * 支架和电表箱共用接地极接地电阻小于4欧姆
     */
    @TableField("ground_resistance_less_than_4")
    private String groundResistanceLessThan4;

    /**
     * 支架接地需小于10欧姆
     */
    @TableField("ground_resistance_less_than_10")
    private String groundResistanceLessThan10;

    /**
     * 电表箱单独接地符合国家标准，小于4欧姆
     */
    @TableField("ground_resistance_standard_compliant")
    private String groundResistanceStandardCompliant;

    /**
     * 其他
     */
    @TableField("ground_other")
    private String groundOther;

    // ------------------------------------------------电站检查项拍照片保存------------------------------------------------
    /**
     * 逆变器整体图
     */

    @TableField(value ="overall_image",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  overallImage;
    /**
     * 电表箱整体图
     */
    @TableField(value ="meter_box_overall_image",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  meterBoxOverallImage;
    /**
     * 组件方阵图
     */

    @TableField(value ="assembly_array_image",typeHandler = FastjsonTypeHandler.class)
    private List<Object> assemblyArrayImage;
    /**
     * 组件方位角测试照片
     */
    @TableField(value ="assembly_azimuth_image",typeHandler = FastjsonTypeHandler.class)
    private List<Object> assemblyAzimuthImage;
    /**
     * 组件倾斜角测试照片
     */
    @TableField(value ="assembly_dip_angle_image",typeHandler = FastjsonTypeHandler.class)
    private List<Object> assemblyDipAngleImage;


    @TableField("approval_status")
    private  String  approvalStatus;//审核结果,0,1
    @TableField("operator")
    private  String  operator;//操作人
    @TableField("operation_time")
    private String operationTime;//操作时间
    @TableField("comment")
    private  String  comment;//审核意见




    //并网审核id
    @TableField(exist = false)
    private Long basicGridAcceptanceId;

    @TableField(exist = false)
    private  String  approvalStatusxx;//,0,1

    //并网登记id
    @TableField(exist = false)
    private Long fonGridId;


}
