package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.Enum.AcceptanceStatusEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.UserUnitInformationDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.AcceptanceCheckItem;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfOnGrid;
import com.yeejoin.amos.boot.module.hygf.api.mapper.PersonnelBusinessMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IAcceptanceService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;
import java.util.stream.Collectors;

@RestController
@Api(tags = "验收管理")
@RequestMapping(value = "/acceptance")
public class AcceptanceController  extends BaseController {

    @Autowired
    PersonnelBusinessMapper personnelBusinessMapper;
    @Autowired
    private IAcceptanceService acceptanceService;

    @PostMapping(value = "/page")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "Get", value = "获取验收单列表", notes = "获取验收单列表")
    public ResponseModel<IPage<AcceptanceDto>> page(
            @RequestParam(value = "current", required = false, defaultValue = "1") Integer current,
            @RequestParam(value = "size", required = false, defaultValue = "20") Integer size,
            @RequestBody AcceptanceDto param
    ) {
        UserUnitInformationDto userUnitInformationDto = personnelBusinessMapper.getUserUnitInformationDto(getUserInfo().getUserId());
        if(userUnitInformationDto!=null){
            param.setRegionCompanyId(userUnitInformationDto.getRegionalCompaniesSeq());
            param.setAmosDealerId(userUnitInformationDto.getAmosDealerId());
        }

        IPage<AcceptanceDto> page = new Page<>(current, size);
        page = acceptanceService.page(page, param);

        return ResponseHelper.buildResponse(page);
    }

    @GetMapping("/acceptance-details")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "Get", value = "获取验收单列表", notes = "获取验收单列表")
    public ResponseModel<Map<String, Object>> offlineAcceptanceDetails(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(acceptanceService.acceptanceDetails(sequenceNbr));
    }



    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "检查项新增", notes = "检查项新增")
    public ResponseModel save(@RequestBody AcceptanceCheckItem model, @RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(acceptanceService.saveEntity(model, sequenceNbr));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/checkAccept")
    @ApiOperation(httpMethod = "POST", value = "提交验收", notes = "提交验收")
    public ResponseModel checkAccept(@RequestParam Long  basicGridAcceptanceId) {
        acceptanceService.checkAccept(basicGridAcceptanceId,getUserId());
        return ResponseHelper.buildResponse(null);
    }
}
