package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.dto.CompanyTreeDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.ListCompanyModel;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.privilege.model.UserOrgTreeModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/4/25
 */
@RestController
@Api(tags = "平台单位部门树")
@RequestMapping(value = "/companyClient")
public class PrivilegeController extends BaseController{
    @Autowired
    private RedisUtils redisUtils;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryOrgTree")
    @ApiOperation(httpMethod = "GET",value = "查询单位、子单位、部门树",  notes = "查询单位、子单位、部门树")
    public FeignClientResult<Collection<UserOrgTreeModel>> queryOrgTree() {
        //获取当前登录人单位
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);

        Long  companyId=reginParams.getCompany().getSequenceNbr();

        FeignClientResult<Collection<UserOrgTreeModel>> de =Privilege.companyClient.queryOrgTree(companyId);

     return de;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/subcompany")
    @ApiOperation(httpMethod = "GET",value = "查询单位、子单位",  notes = "查询单位、子单位")
    public ResponseModel< Collection<CompanyModel>> subcompany(String orgCode,String type) {
        Long companyId =null;
        if(orgCode!=null){

            LinkedHashMap<Object, Object> l = (LinkedHashMap<Object, Object>) Privilege.companyClient
                    .queryByOrgcode(orgCode).getResult();
            for (Map.Entry<Object, Object> it : l.entrySet()) {

                CompanyModel companyModel = JSONObject.parseObject(JSONObject.toJSONString(it.getValue()),
                        CompanyModel.class);
                if (companyModel != null) {
                    companyId = companyModel.getSequenceNbr();
                }
                break;
            }

        }else{
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            companyId = reginParams.getCompany().getSequenceNbr();
        }
        //获取当前登录人单位
        List<ListCompanyModel> data = new ArrayList();
        FeignClientResult<Collection<CompanyModel>> de = Privilege.companyClient.querySubAgencyTree(companyId);
        FeignClientResult<CompanyModel> dat = Privilege.companyClient.seleteOne(companyId);
        CompanyModel  companyModel=dat.getResult();
        List<CompanyModel> list =new ArrayList<>();
        //如果是公司则获取所有片区
//        86*353*328*364
        if(companyModel.getLevel().equals("categroy_leve2")){
            Collection<CompanyModel> companyModelList= de.getResult();
            companyModelList=companyModelList.stream().filter(companyModel1 ->companyModel1.getCompanyName().contains("区域")).collect(Collectors.toList());
            companyModelList.parallelStream().forEach((companyModel1)->{companyModel1.setChildren(new ArrayList());});
            return ResponseHelper.buildResponse(companyModelList);
        }
        //如果是片区则获取片区
        if(companyModel.getLevel().equals("area")){
            list.add(companyModel);
            return ResponseHelper.buildResponse(list);
        }
        if(!"add".equals(type)){
          if(companyModel.getLevel().equals("station")){
            FeignClientResult<CompanyModel> areaInfo = Privilege.companyClient.seleteOne(companyModel.getParentId());
            list.add(areaInfo.getResult());
        }
        }
        //如果是场站获取片区
//        if(companyModel.getLevel().equals("station")){
//            FeignClientResult<CompanyModel> areaInfo = Privilege.companyClient.seleteOne(companyModel.getParentId());
//            list.add(areaInfo.getResult());
//        }
        return ResponseHelper.buildResponse(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/stationTree")
    @ApiOperation(httpMethod = "GET",value = "查询所属场站",  notes = "查询所属场站")
    public ResponseModel<  Collection<CompanyModel>> stationTree(String orgCode ) {
        Long companyId =null;
        if(orgCode!=null){


            LinkedHashMap<Object, Object> l = (LinkedHashMap<Object, Object>) Privilege.companyClient
                    .queryByOrgcode(orgCode).getResult();
            for (Map.Entry<Object, Object> it : l.entrySet()) {

                CompanyModel companyModel = JSONObject.parseObject(JSONObject.toJSONString(it.getValue()),
                        CompanyModel.class);
                if (companyModel != null) {
                    companyId = companyModel.getSequenceNbr();
                }
                break;
            }

        }else{
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            companyId = reginParams.getCompany().getSequenceNbr();
        }

        List<ListCompanyModel> data = new ArrayList();
          FeignClientResult<Collection<CompanyModel>> de = Privilege.companyClient.querySubAgencyTree(companyId);
          FeignClientResult<CompanyModel> dat = Privilege.companyClient.seleteOne(companyId);
          CompanyModel  companyModel=dat.getResult();
          companyModel.setChildren(de.getResult());
        List<CompanyModel> list =new ArrayList<>();
        list.add(companyModel);
        return ResponseHelper.buildResponse(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/permissionTree")
    @ApiOperation(httpMethod = "GET",value = "查询所属场站",  notes = "查询所属场站")
    public ResponseModel<  Collection<CompanyModel>> permissionTree(@RequestParam(required = false,defaultValue = "86*353*328") String orgCode ) {
        Long companyId =null;
        if(orgCode!=null){
            LinkedHashMap<Object, Object> l = (LinkedHashMap<Object, Object>) Privilege.companyClient
                    .queryByOrgcode(orgCode).getResult();
            for (Map.Entry<Object, Object> it : l.entrySet()) {

                CompanyModel companyModel = JSONObject.parseObject(JSONObject.toJSONString(it.getValue()),
                        CompanyModel.class);
                if (companyModel != null) {
                    companyId = companyModel.getSequenceNbr();
                }
                break;
            }

        }
        List<ListCompanyModel> data = new ArrayList();
        FeignClientResult<Collection<CompanyModel>> de = Privilege.companyClient.querySubAgencyTree(companyId);
        FeignClientResult<CompanyModel> dat = Privilege.companyClient.seleteOne(companyId);
        CompanyModel  companyModel=dat.getResult();
        companyModel.setChildren(de.getResult());
        List<CompanyModel> list =new ArrayList<>();
        list.add(companyModel);
        return ResponseHelper.buildResponse(list);
    }

}
