package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrFormDto;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;
import com.yeejoin.amos.boot.module.ugp.api.constants.XJConstant;
import com.yeejoin.amos.boot.module.ugp.api.dto.PercentOfPassDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.QualityInfo;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import com.yeejoin.amos.boot.module.ugp.api.mapper.IInstallationQualityMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IInstallationQualityService;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import jdk.nashorn.internal.runtime.logging.Logger;
import lombok.extern.log4j.Log4j;
import lombok.extern.slf4j.Slf4j;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Author cpp
 * @Description
 * @Date 2022/10/10
 */
@Service


public class InstallationQualityImpl extends BaseService<PercentOfPassDto, QualityInfo, IInstallationQualityMapper> implements IInstallationQualityService {

    @Resource
    private IInstallationQualityMapper mapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Resource
    private WeldServiceImpl weldService;
    @Resource
    private OrgUsrServiceImpl orgUsrService;
    @Autowired
    OrgServiceImpl orgService;
    @Autowired
    ProjectResourceServiceImpl projectResourceService;





    //分页查询项目质量监检信息
    private static final String LOOK="查看";
    private static final String PERENT="0%";
    @Override
    @BusinessIdentify
    @Transactional
    public Page<PercentOfPassDto> find(int current,int size,PercentOfPassDto pd) {
        Page page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        Set<String> projectIds = new HashSet<>();
        Long companySequenceNbr = orgService.getReginParams().getBusinessInfo().getCompanySequenceNbr();
        OrgUsr orgUsrById = orgService.getOrgUsrById(String.valueOf(companySequenceNbr));

        for (Project project : projectResourceService.getProjectList()) {
            projectIds.add(String.valueOf(project.getSequenceNbr()));
        }
        if (ValidationUtil.isEmpty(projectIds)) {
            return page;
        }
        page = mapper.findss(page, pd, projectIds);

        List<QualityInfo> qfList = page.getRecords();
        List<PercentOfPassDto> list = new ArrayList<> ( );

        for (QualityInfo qualityInfo : qfList) {

            PercentOfPassDto percentOfPassDto = new PercentOfPassDto ( );
            percentOfPassDto.setLength(qualityInfo.getProject().getLength());
            percentOfPassDto.setName (qualityInfo.getProject ( ).getName ( ));
            percentOfPassDto.setAddress (qualityInfo.getProject ( ).getAddress ( ));
            percentOfPassDto.setProgressStatus (qualityInfo.getProject ( ).getProgressStatus ( ));
            percentOfPassDto.setProjectId (qualityInfo.getProjectId ( ));
            percentOfPassDto.setChargePerson (qualityInfo.getProject ( ).getChargePerson ( ));
            percentOfPassDto.setLook(LOOK);
            percentOfPassDto.setCurrentUnit(qualityInfo.getProject().getSupervisionUnit());
            percentOfPassDto.setStartDate (qualityInfo.getProject ( ).getStartDate ( ));
            percentOfPassDto.setConstructionUnit (qualityInfo.getProject ( ).getConstructionUnit ( ));
            percentOfPassDto.setSubmitDate (qualityInfo.getProject ( ).getSubmitDate ( ));
            list.add (percentOfPassDto);

        }

        //创建新的集合来存放数据
        List<PercentOfPassDto> newsData = new ArrayList<> ( );
        if (list != null && list.size ( ) > 0) {
            //遍历数据
            for (PercentOfPassDto pr : list) {
                //获取项目id
                Long projectId = pr.getProjectId ( );
                //通过项目id查询焊口数据
                List<WeldDto> weldDtoList = weldService.getProjectId (projectId);

                if (weldDtoList != null && weldDtoList.size ( ) > 0) {
                    //获取焊口信息总条数
                    int sum = weldDtoList.size ( );
                    List<WeldDto> collect = weldDtoList.stream( ).filter(weldDto -> StageEnum.焊接工艺.getName( ).equals(weldDto.getSuperInspecStatus( )) ||
                            StageEnum.管道耐压.getName( ).equals(weldDto.getSuperInspecStatus( )) ||
                            StageEnum.敷设质量.getName( ).equals(weldDto.getSuperInspecStatus( )) ||
                            StageEnum.定位.getName( ).equals(weldDto.getSuperInspecStatus( )) ||
                            StageEnum.回填.getName( ).equals(weldDto.getSuperInspecStatus( )) ).collect(Collectors.toList( ));

                    //焊口合格数
                    int qualifiedData = collect.size();
                    //合格率
                    BigDecimal sums = new BigDecimal (sum);
                    BigDecimal length = new BigDecimal(pr.getLength());
                    length = length.divide(new BigDecimal(10),2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal qualifiedDatas = new BigDecimal (qualifiedData);
                    Double pass = qualifiedDatas.divide (sums, 2, BigDecimal.ROUND_HALF_UP).multiply (new BigDecimal (100)).doubleValue ( );
                    Double progress = sums.divide (length, 2, BigDecimal.ROUND_HALF_UP).multiply (new BigDecimal (100)).doubleValue ( );

                    //转换成百分比,生成合格率

                    String fpy = pass.toString ( ) + "%";
                    if(progress>100){
                        progress = 100D;
                    }
                    String progressStatus = progress.toString ( ) + "%";
                    //将合格率赋值给数据集合
                    pr.setPercentOfPass (fpy);
                    pr.setProgressStatus(progressStatus);

                    if(ValidationUtil.isEmpty(pr.getPercentOfPass())){
                        pr.setPercentOfPass ("0.0%");
                    }
                    if(ValidationUtil.isEmpty(pr.getProgressStatus())){
                        pr.setProgressStatus ("0.0%");
                    }
                }
                //将数据添加到新集合里面
                newsData.add (pr);
            }
                //如果条件name为空的,直接查询全部
                page.setRecords (newsData);
                page.setTotal (newsData.size ());
                return page;
        }
        return page;
    }
}


