package com.yeejoin.amos.boot.module.elevator.flc.biz.service.impl;

import com.yeejoin.amos.boot.module.elevator.flc.api.entity.CylinderFilling;
import com.yeejoin.amos.boot.module.elevator.flc.api.mapper.CylinderFillingMapper;
import com.yeejoin.amos.boot.module.elevator.flc.api.service.ICylinderFillingService;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.CylinderFillingDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Date;
import java.util.List;

/**
 * 气瓶充装信息--充装前检查服务实现类
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Service
public class CylinderFillingServiceImpl extends BaseService<CylinderFillingDto, CylinderFilling,CylinderFillingMapper> implements ICylinderFillingService {
    /**
     * 分页查询
     */
    public Page<CylinderFillingDto> queryForCylinderFillingPage(Page<CylinderFillingDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderFillingDto> queryForCylinderFillingList()   {
        return this.queryForList("" , false);
    }

    public Double queryIntegirtyByAppId(String appId) {
        return this.baseMapper.queryIntegirtyByAppId(appId);
    }

    public Integer getFillingCountByMonth(String appId, Date time) {
        return this.baseMapper.getFillingCountByMonth(appId,time);
    }

    public Integer getFillingPassedCountByMonth(String appId, Date time) {
        return this.baseMapper.getFillingPassedCountByMonth(appId,time);
    }
}