package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aspose.words.SaveFormat;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.yeejoin.amos.boot.biz.common.annotation.FieldMapping;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.IDataDictionaryService;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.crypto.AESUtil;
import com.yeejoin.amos.boot.module.common.api.enums.CylinderTypeEnum;
import com.yeejoin.amos.boot.module.common.api.enums.JYJCBusinessTypeEnum;
import com.yeejoin.amos.boot.module.common.api.enums.JYJCResultEnum;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.JgRegistrationHistory;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistration;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationManage;
import com.yeejoin.amos.boot.module.jg.api.enums.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationManageMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationTransferService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgMaintainNoticeService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgTransferNoticeService;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler.CbDataDictTypeHandler;
import com.yeejoin.amos.boot.module.jg.biz.feign.PrivilegeFeginService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TaskV2FeignService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.RemindServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.biz.utils.FileExporter;
import com.yeejoin.amos.boot.module.jg.biz.utils.ImageUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.JsonUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.WordTemplateUtils;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.*;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.PermissionModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActTaskDTO;
import com.yeejoin.amos.feign.workflow.model.FlowTaskVo;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import freemarker.template.Configuration;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.PostConstruct;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.DataHandlerServiceImpl.IDX_BIZ_EQUIPMENT_INFO;

/**
 * 装备分类服务实现类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@Service
@Slf4j
public class CommonServiceImpl implements ICommonService {

    public static final String SPECIAL_REGION_CODE = "SpecialRegionCode";
    public static final String YWCJ = "YWCJ";
    public static final String DICT_DATA_KEY = "dictDataKey";
    // 行政区划redis缓存key
    public static final String PROVINCE = "PROVINCE";
    public static final String CITY = "CITY";
    public static final String REGION = "REGION";
    public static final String STREET = "STREET";
    // 行政区划level
    private static final String PROVINCE_LEVEL = "1";
    private static final String CITY_LEVEL = "2";
    private static final String REGION_LEVEL = "3";
    private static final String STREET_LEVEL = "4";
    // 判断行政区划查询市还是区
    private static final String END_CODE = "0000";
    // 判断行政区划查询街道
    private static final String STREET_END_CODE = "00";
    // 管辖机构redis缓存key
    private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";
    /**
     * 接收机构redis缓存key前置
     */
    private static final String PREFIX_NOTICE_RECEIVE_UNIT_TREE = "NOTICE_RECEIVE_UNIT_TREE";
    // 管辖机构redis缓存key
    private static final String REGULATOR_UNIT_TREE_ALL = "REGULATOR_UNIT_TREE_ALL";
    // 行政审批局redis缓存key
    private static final String ADMINISTRATION_UNIT_TREE = "ADMINISTRATION_UNIT_TREE";
    private static final String XZSB = "XZSB";
    private static final String CODE = "code";
    private static final String PL_DR = "PL_DR";
    private static final String DW_LR = "DW_LR";
    // 管辖机构
    private static final String REGULATOR_UNIT = "监管机构";
    // 行政审批局
    private static final String ADMINISTRATION_UNIT = "行政审批局";
    // 业务通用发起——基本信息
    private static final String basic = "basic";
    private static final String useRegFormUpload = "useRegFormUpload";
    public static final String HISTORY_EQU_TYPE = "historyEquType";

    public static final String KEY_REG_TYPE = "regType";
    public static final String HISTORY_SUBMIT_TYPE = "historySubmitType";
    public static final String SECOND = "second";
    // 业务通用发起——告知单详情
    public static final String notice = "notice";
    // 业务通用发起——技术参数-改造变更登记使用
    public static final String techInfo = "techInfo";
    // 业务通用发起——安装告知表单key
    private static final String AZGZ_FORM_ID = "1734141426742095873";
    // 业务通用发起——移装变更表单key
    private static final String YZBG_PAGE_ID = "changeRegistrationTransfer";
    // 业务通用发起——改造告知表单key
    private static final String GZGZ_PAGE_ID = "reformNoticeAdd";
    // 业务通用发起——维修告知表单key
    private static final String WXGZ_PAGE_ID = "maintainInfo";
    // 业务通用发起——移装告知表单key
    private static final String YZGZ_PAGE_ID = "transferNoticeAdd";
    // 业务通用发起——单位变更表单key
    private static final String DWBG_PAGE_ID = "changeRegisInfo";
    // 业务通用发起——设备注销表单key
    private static final String SBZX_PAGE_ID = "jgScrapCancelAdd";
    // 业务通用发起——更名变更表单key
    private static final String GMBG_PAGE_ID = "jgRegistrationInfo";
    private static final String SELECTED_ROLE_SEQS = "selectRoleSeqs";
    private static final String VEHICLE = "vehicle";
    private static final String UNIT = "unit";
    private static final String SET = "set";
    private static final String OVER_DESIGN = "overDesign";
    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    IDataDictionaryService iDataDictionaryService;
    @Autowired
    JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    @Autowired
    PrivilegeFeginService privilegeFeginService;
    @Autowired
    TzBaseEnterpriseInfoMapper enterpriseInfoMapper;
    @Autowired
    ConstructionInfoMapper constructionInfoMapper;
    @Autowired
    CommonMapper commonMapper;
    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;
    @Autowired
    JgMaintenanceContractServiceImpl jgMaintenanceContractServiceImpl;
    @Autowired
    JgUseRegistrationServiceImpl jgUseRegistrationServiceImpl;
    @Autowired
    @Lazy
    JgCertificateReplenishServiceImpl jgCertificateReplenishServiceImpl;
    @Autowired
    @Lazy
    JgEquipTransferServiceImpl jgEquipTransferServiceImpl;
    @Lazy
    @Autowired
    JgReformNoticeServiceImpl jgReformNoticeService;
    @Autowired
    JgChangeRegistrationReformServiceImpl jgChangeRegistrationReformServiceImpl;
    @Autowired
    IJgChangeRegistrationTransferService jgChangeRegistrationTransferService;
    @Autowired
    JgChangeRegistrationUnitServiceImpl jgChangeRegistrationUnitServiceImpl;
    @Autowired
    JgChangeRegistrationNameServiceImpl jgChangeRegistrationNameService;
    @Autowired
    JgEnableDisableServiceImpl jgEnableDisableServiceImpl;
    @Autowired
    JgScrapCancelServiceImpl jgScrapCancelService;
    @Autowired
    ICmWorkflowService cmWorkflowService;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;
    @Autowired
    private JgUseRegistrationManageMapper jgUseRegistrationManageMapper;
    @Autowired
    RedissonClient redissonClient;
    @Value("${redis.cache.failure.time}")
    private Long redisRegionTimeSecond;
    @Autowired
    private RedisUtils redisUtils;
    @Value("classpath:/json/superviseBusinessCategory.json")
    private Resource superviseBusinessCategory;
    @Value("classpath:/json/urlInfo.json")
    private Resource urlInfo;
    @Value("classpath:/json/companyCodeRegName.json")
    private Resource regNameJson;
    @Value("${regulator.unit.code}")
    private String code;
    @Lazy
    @Autowired
    private IJgInstallationNoticeService iJgInstallationNoticeService;
    @Autowired
    private IJgMaintainNoticeService iJgMaintainNoticeService;
    @Autowired
    private IJgTransferNoticeService jgTransferNoticeService;
    @Autowired
    private JgVehicleInformationServiceImpl jgVehicleInformationService;
    private Map<String, String> companyCodeRegNameMap;
    @Autowired
    private TaskV2FeignService taskV2FeignService;
    @Autowired
    private Configuration configuration;
    @Autowired
    EquipTechParamPipelineMapper equipTechParamPipelineMapper;
    @Autowired
    private JgChangeVehicleRegistrationUnitServiceImpl jgChangeVehicleRegistrationUnitService;
    @Autowired
    private JgUseRegistrationManageServiceImpl jgUseRegistrationManageService;
    @Autowired
    JgOverDesignServiceLifeServiceImpl jgOverDesignServiceLifeService;
    @Autowired
    private CodeGenServiceImpl codeGenService;

    @Value("${qrcode.prefix:https://sxtzsb.sxsei.com:19435/tzs}")
    private String qrcodePrefix;

    @Autowired
    @Lazy
    private RemindServiceImpl remindServiceImpl;

    @Autowired
    private CbDataDictTypeHandler dataDictTypeHandler;

    @Autowired
    private JgResumeInfoServiceImpl jgResumeInfoService;

    @Autowired
    private RestHighLevelClient restHighLevelClient;

    public static final String DATA_QUALITY_SCORE = "DATA_QUALITY_SCORE";

    public static byte[] file2byte(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            // 当文件没有结束时，每次读取一个字节显示
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String toQueryParams2(JSONObject jsonObject) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = jsonObject.keySet();
        keys.forEach(key -> {
            Object value = jsonObject.get(key);
            if (sb.length() > 0) {
                sb.append('&');
            }
            try {
                if (value != null && !"".equals(value)) {
                    sb.append(URLEncoder.encode(key, "UTF-8"))
                            .append('=')
                            .append(URLEncoder.encode(value.toString(), "UTF-8"));
                }
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        });
        return sb.toString();
    }

    public static String buildJgExecuteLockKey(String instanceId) {
        return "JG_INSTANCE_LOCK:" + instanceId;
    }

    public static String buildJgInstanceDataKey(String instanceId) {
        return "JG_INSTANCE_DATA:" + instanceId;
    }

    public static void formatTime2StrDateForEquip(JSONObject jsonObject) {
        String[] timeFields = {"designDate", "produceDate", "inspectDate", "nextInspectDate"};
        for (String field : timeFields) {
            if (jsonObject.get(field) != null && jsonObject.get(field) instanceof Long) {
                jsonObject.put(field, DateUtil.format(new Date(Long.parseLong(jsonObject.get(field).toString())), DatePattern.NORM_DATETIME_PATTERN));
            }
        }
    }

    /**
     * 驼峰转下划线
     *
     * @param str
     * @return
     */
    public static String convertToUnderline(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_").append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private static String getSelectedRoleRedisKey() {
        return RequestContext.getToken() + "_" + SELECTED_ROLE_SEQS;
    }

    private static void convertAndAddToUnitList(DictionarieValueModel x, List<Map<String, Object>> unitList) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("useCode", x.getDictDataKey());
        map.put("useUnit", x.getDictDataValue());
        unitList.add(map);
    }

    @PostConstruct
    public void init() {
        companyCodeRegNameMap = JsonUtils.getResourceJson(regNameJson);
    }

    @Override
    public List<EquipmentCategory> getEquipmentCategoryList(String code, String type) {
        List<EquipmentCategory> result = new ArrayList<>();
        LambdaQueryWrapper<EquipmentCategory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(EquipmentCategory::getCode, code);
        EquipmentCategory equipmentCategory = equipmentCategoryMapper.selectOne(wrapper);
        if (ObjectUtils.isEmpty(type)) {
            if (!ValidationUtil.isEmpty(equipmentCategory)) {
                result.add(equipmentCategory);
            }
        } else {
            LambdaQueryWrapper<EquipmentCategory> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.eq(EquipmentCategory::getParentId, equipmentCategory.getId());
            List<EquipmentCategory> equipmentCategories = equipmentCategoryMapper.selectList(wrapper2);
            if (!ValidationUtil.isEmpty(equipmentCategories)) {
                result = equipmentCategories;
            }
        }
        return result;
    }

    @Override
    public List<LinkedHashMap> getRegion(String level, String parentId) {
        List<LinkedHashMap> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(level)) {
            list = (List<LinkedHashMap>) redisUtils.get(PROVINCE);
            return ObjectUtils.isEmpty(list) ? getProvinceList(level) : list;
        } else if (!ObjectUtils.isEmpty(parentId)) {
            String regionCode = parentId.split("_")[0];
            // regionCode不是以00结尾查询街道，以0000结果查询市、否则查询区
            if (!regionCode.endsWith(STREET_END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(STREET)) ? getProvinceList(STREET_LEVEL) : (List<LinkedHashMap>) redisUtils.get(STREET);
            } else if (regionCode.endsWith(END_CODE)) {
                list = ObjectUtils.isEmpty(redisUtils.get(CITY)) ? getProvinceList(CITY_LEVEL) : (List<LinkedHashMap>) redisUtils.get(CITY);
            } else {
                list = ObjectUtils.isEmpty(redisUtils.get(REGION)) ? getProvinceList(REGION_LEVEL) : (List<LinkedHashMap>) redisUtils.get(REGION);
            }
            return list.stream().filter(r -> regionCode.equals(r.get("parentRegionCode").toString())).collect(Collectors.toList());
        } else {
            return new ArrayList<>();
        }
    }

    public List<LinkedHashMap> getProvinceList(String level) {
        FeignClientResult result = privilegeFeginService.getProvince(level);
        List<LinkedHashMap> list = (List<LinkedHashMap>) result.getResult();
        for (LinkedHashMap linkedHashMap : list) {
            linkedHashMap.put("sequenceNbr", linkedHashMap.get("regionCode"));
        }
        switch (level) {
            case PROVINCE_LEVEL:
                redisUtils.set(PROVINCE, list);
                break;
            case CITY_LEVEL:
                redisUtils.set(CITY, list);
                break;
            case REGION_LEVEL:
                redisUtils.set(REGION, list);
                break;
            case STREET_LEVEL:
                redisUtils.set(STREET, list);
                break;
            default:
                log.error("不支持的行政区划：{}", level);
                break;
        }
        return list;
    }

    @Override
    public List<LinkedHashMap> getCreatTree() {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        // 判断redis是否存在管辖机构树
        return !ObjectUtils.isEmpty(result) ? result : creatTree();
    }

    @Override
    public List<LinkedHashMap> loginUnitAndBelowGetTree(String orgCode) {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE + "_" + orgCode);
        // 判断redis是否存在管辖机构树
        return !ObjectUtils.isEmpty(result) ? result : creatlLoginUnitAndBelowGetTree(orgCode);
    }

    @Override
    public List<LinkedHashMap> getCreatTreeByInstallation() {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE_ALL);
        // 判断redis是否存在管辖机构树
        return !ObjectUtils.isEmpty(result) ? result : getCreatTreeByInstallationTree();
    }

    @Override
    public List<LinkedHashMap> getCreatTreeByInstallationTree() {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> treeData = deleteData(result, REGULATOR_UNIT);
        List<LinkedHashMap> supervisionTree = treeData.stream().filter(e -> code.equals(e.get("orgCode"))).collect(Collectors.toList());
        List<LinkedHashMap> resultTree = updateNullChildren(supervisionTree);
        redisUtils.set(REGULATOR_UNIT_TREE_ALL, resultTree);
        return resultTree;
    }

    @Override
    public List<LinkedHashMap> getReceiveUnitTree(String bizType) {
        List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(genRedisKey(bizType));
        // 判断redis是否存在接收机构树
        return !ObjectUtils.isEmpty(result) ? result : creatReceiveUnitTree(bizType);
    }

    /**
     * 验EQUCODE的唯一性
     *
     * @param equCode
     * @return
     */
    @Override
    public Boolean checkUniquenessOfEQUCODE(String equCode) {
        LambdaQueryWrapper<RegistrationInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RegistrationInfo::getEquCode, equCode);
        Integer count = tzsJgRegistrationInfoMapper.selectCount(wrapper);
        return count > 0;
    }

    @Override
    public Map<String, Object> getPermissionTreeWithCompany(String menuAgent, String permissionType, String path, CompanyBo company) {
        Map<String, Object> result = new HashMap<>();
        Object roleSeqs = redisUtils.get(getSelectedRoleRedisKey());
        Collection<PermissionModel> permissionModels;
        // 监管单位
        if (!"company".equals(company.getLevel()) || null == roleSeqs) {
            permissionModels = FeignUtil.remoteCall(() -> Privilege.permissionClient.currentPermissionTree(menuAgent, permissionType, null, path));
        } else {
            permissionModels = FeignUtil.remoteCall(() -> Privilege.permissionClient.treeByRoles(roleSeqs.toString(), menuAgent, permissionType, path, RequestContext.getAppKey()));
        }
        // 过滤非快捷菜单
        permissionModels = filterNonWrapPermission(permissionModels);
        result.put("permission", permissionModels);
        result.put("company", company);
        return result;
    }

    @Override
    public JSONArray allWorkbenchPermission(String businessType, String appCode) {
        Collection<PermissionModel> permissionModels = FeignUtil.remoteCall(() -> Privilege.permissionClient.queryPermissionTree(null, null, null, null, appCode));
        List<PermissionModel> allFilterChildren = flattenChildren(permissionModels);
        List<PermissionModel> collect = allFilterChildren.stream().filter(permissionModel -> permissionModel.getExtraIcon() != null && permissionModel.getExtraIcon().startsWith(businessType)).collect(Collectors.toList());
        JSONArray result = new JSONArray();
        for (PermissionModel permissionModel : collect) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", permissionModel.getExtraIcon());
            jsonObject.put("name", permissionModel.getPermissionName());
            jsonObject.put("permissionName", permissionModel.getPermissionName());
            jsonObject.put("path", permissionModel.getPath());
            jsonObject.put("key",permissionModel.getSequenceNbr());
            result.add(jsonObject);
        }
        return result;
    }


    @Override
    public JSONArray getPermissionTreeWithCompanyV2(String menuAgent, String permissionType, String path, CompanyBo company, JSONArray params) {
        Object roleSeqs = redisUtils.get(getSelectedRoleRedisKey());
        Collection<PermissionModel> permissionModels;
        // 监管单位
        if (!"company".equals(company.getLevel()) || null == roleSeqs) {
            permissionModels = FeignUtil.remoteCall(() -> Privilege.permissionClient.currentPermissionTree(menuAgent, permissionType, null, path));
        } else {
            permissionModels = FeignUtil.remoteCall(() -> Privilege.permissionClient.treeByRoles(roleSeqs.toString(), menuAgent, permissionType, path, RequestContext.getAppKey()));
        }
        // 过滤非快捷菜单
        permissionModels = filterNonWrapPermission(permissionModels);
        // 根据权限过滤菜单
        JSONArray filterMenu = filterMenuByPermission(permissionModels, params);
        return filterMenu;
    }

    private JSONArray filterMenuByPermission(Collection<PermissionModel> permissionModels, JSONArray params) {
        JSONArray result = new JSONArray();
        if (!ValidationUtil.isEmpty(permissionModels)) {
            List<PermissionModel> allFilterChildren = new ArrayList<>();
            for (PermissionModel permissionModel : permissionModels) {
                if (!ObjectUtils.isEmpty(permissionModel.getChildren())) {
                    List<PermissionModel> children = flattenChildren(permissionModel.getChildren());
                    List<PermissionModel> filterChildren = children.stream().filter(child -> child.getExtraIcon() != null).collect(Collectors.toList());
                    allFilterChildren.addAll(filterChildren);
                }
            }
            for (PermissionModel permissionModel : allFilterChildren) {
                Object object = params.stream().filter(param -> permissionModel.getExtraIcon().equals(JSONObject.parseObject(JSONObject.toJSONString(param)).get("code"))).findFirst().get();
                JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(object));
                jsonObject.put("path",permissionModel.getPath());
                jsonObject.put("href",permissionModel.getPath());
                result.add(jsonObject);
            }
        }
        return result;
    }


    private List<PermissionModel> flattenChildren(Collection<PermissionModel> permissionModels) {
        List<PermissionModel> flattenedList = new ArrayList<>();
        if (!ValidationUtil.isEmpty(permissionModels)) {
            for (PermissionModel permissionModel : permissionModels) {
                // 将当前节点添加到列表中（如果需要）
                flattenedList.add(permissionModel);
                // 如果有子节点，则递归调用flattenChildren方法
                if (!ObjectUtils.isEmpty(permissionModel.getChildren())) {
                    flattenedList.addAll(flattenChildren(permissionModel.getChildren()));
                }
            }
        }
        return flattenedList;
    }

    private Collection<PermissionModel> filterNonWrapPermission(Collection<PermissionModel> permissionModels) {
        if (!ValidationUtil.isEmpty(permissionModels)) {
            permissionModels.forEach(permissionModel -> {
                if (!ValidationUtil.isEmpty(permissionModel.getChildren())) {
                    permissionModel.setChildren(filterNonWrapPermission(permissionModel.getChildren()));
                }
            });
            permissionModels = permissionModels.stream().filter(permissionModel -> permissionModel.getIsWarp() || (!permissionModel.getIsWarp() && !ValidationUtil.isEmpty(permissionModel.getChildren()))).collect(Collectors.toList());
        }
        return ValidationUtil.isEmpty(permissionModels) ? null : permissionModels;
    }

    @Override
    public void useFlagGenerate(UseFlagParamDto useFlagParamDto, HttpServletResponse response) {
        Objects.requireNonNull(useFlagParamDto, "参数不能为空");

        Map<String, Object> paramMap = Bean.BeantoMap(useFlagParamDto);
        // 二维码设置
        setQrCode(useFlagParamDto, paramMap);
        // 日期设置
        setNextDate(useFlagParamDto, paramMap);
        // 登记机关调整为H列内容（原因目前公司结构无行政审批局）
        setRegName(useFlagParamDto, paramMap);
        String ftlPath = this.getFtlPathByBiz(useFlagParamDto);
        if (StringUtils.isEmpty(ftlPath)) {
            throw new BadRequest("无法找到使用标志模板！");
        }

        File pdfFile = null;
        try {
            pdfFile = this.wordToPdf("特种设备使用标志_", ftlPath, paramMap);
            byte[] bytes = file2byte(pdfFile);
            String docTitle = pdfFile.getName();
            FileExporter.exportFile(FileExporter.FileType.valueOf("pdf"), docTitle, bytes, response);
        } catch (Exception e) {
            log.error("特种设备使用标志生成失败", e);
            throw new RuntimeException("特种设备使用标志生成失败", e);
        } finally {
            if (pdfFile != null) {
                pdfFile.delete();
            }
        }
    }

    private void setRegName(UseFlagParamDto useFlagParamDto, Map<String, Object> paramMap) {
        String receiveOrgName = companyCodeRegNameMap.getOrDefault(useFlagParamDto.getReceiveCompanyCode(), useFlagParamDto.getReceiveOrgName());
        paramMap.put("receiveOrgName", receiveOrgName);
    }

    public String getRegName(String receiveCompanyCode, String defaultName) {
        return companyCodeRegNameMap.getOrDefault(receiveCompanyCode, defaultName);
    }

    private void setNextDate(UseFlagParamDto useFlagParamDto, Map<String, Object> paramMap) {
        if (useFlagParamDto.getNextInspectionDate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(useFlagParamDto.getNextInspectionDate());
            paramMap.put("year", DateUtil.year(useFlagParamDto.getNextInspectionDate()) + "");
            paramMap.put("month", DateUtil.month(useFlagParamDto.getNextInspectionDate()) + 1);
            paramMap.put("day", calendar.get(Calendar.DAY_OF_MONTH));
            paramMap.put("nextInspectionTime", paramMap.get("year") + "年" + paramMap.get("month") + "月" + paramMap.get("day") + "日");
        }
    }

    private void setQrCode(UseFlagParamDto useFlagParamDto, Map<String, Object> paramMap) {
        String qrCode = ImageUtils.generateQRCode(getEncodeQrCode(useFlagParamDto.getCertificateNo(), "useFlag", useFlagParamDto.getVersion() + ""), 100, 100);
        paramMap.put("qrCode", qrCode);
    }

    private String getFtlPathByBiz(UseFlagParamDto useFlagParamDto) {
        String ftlPath = "";
        // 锅炉、压力容器(气瓶除外)、起重机械、客运索道、大型游乐设施、场(厂)内专用机动车辆 使用式样一
        String[] flag1EquipList = {"1000", "2000", "4000", "5000", "9000", "6000"};
        if (Arrays.asList(flag1EquipList).contains(useFlagParamDto.getEquListCode())) {
            ftlPath = "flag1-use-equip.ftl";
        }
        // 电梯使用式样二
        String[] flag2EquipList = {"3000"};
        if (Arrays.asList(flag2EquipList).contains(useFlagParamDto.getEquListCode())) {
            ftlPath = "flag2-use-equip.ftl";
        }
        // 车用气瓶使用式样三, 约定 车用气瓶为 0000
        String[] flag3EquipList = {"0000"};
        if (Arrays.asList(flag3EquipList).contains(useFlagParamDto.getEquListCode())) {
            ftlPath = "flag3-use-equip.ftl";
        }
        return ftlPath;
    }

    /**
     * 用户选择信心redis获取
     **/
    protected ReginParams getSelectedOrgInfo() {
        return JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
    }

    /**
     * 查询设备在jg业务中的记录
     *
     * @param record
     * @return
     */
    @Override
    public List<Map<String, String>> equOnJgServiceOperationRecords(String record) {
        return commonMapper.equOnJgServiceOperationRecords(record).stream()
                .map(x -> {
                    Map<String, String> map = new HashMap<>();
                    map.put("operatingTime", x.get("recDate"));
                    String content = String.format("%s  创建人：%s  单号【%s】  审批单位：%s",
                            x.get("businessType"), x.get("recUserName"), x.get("applyNo"), x.get("approvalUnit"));
                    map.put("content", content);
                    map.put("routePath", x.get("routePath"));
                    return map;
                })
                .collect(Collectors.toList());
    }

    /**
     * 查询当前登录用户公司下的管理员对应联系方式
     *
     * @param name
     * @return
     */
    @Override
    public Map<String, Object> getUserPhone(String name) {
        ReginParams reginParams = getSelectedOrgInfo();
        String companyCode = reginParams.getCompany().getCompanyCode();
        return commonMapper.getUserPhone(name, companyCode);
    }

    @Override
    public List<LinkedHashMap> getTree(String client, ReginParams reginParams) {
        // 企业逻辑
        if (reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY) || "jgLook".equals(client)) {
            List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
            // 判断redis是否存在管辖机构树
            return !ObjectUtils.isEmpty(result) ? result : creatTree();
        } else {
            return Collections.singletonList((LinkedHashMap) BeanUtil.beanToMap(reginParams.getCompany()));
        }

    }

    @Override
    public List<LinkedHashMap> creatTree() {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> treeData = deleteTreeData(result, REGULATOR_UNIT);
        List<LinkedHashMap> supervisionTree = treeData.stream().filter(e -> code.equals(e.get("orgCode"))).collect(Collectors.toList());
        List<LinkedHashMap> resultTree = updateNullChildren(supervisionTree);
        redisUtils.set(REGULATOR_UNIT_TREE, resultTree);
        return resultTree;
    }

    public List<LinkedHashMap> creatlLoginUnitAndBelowGetTree(String orgCode) {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> treeData = deleteTreeData(result, REGULATOR_UNIT);
        List<LinkedHashMap> supervisionTree = orgCodeAndBelowGetTree(treeData, orgCode);
        List<LinkedHashMap> resultTree = updateNullChildren(supervisionTree);
        redisUtils.set(REGULATOR_UNIT_TREE + "_" + orgCode, resultTree);
        return resultTree;
    }

    private List<LinkedHashMap> orgCodeAndBelowGetTree(List<LinkedHashMap> treeData, String orgCode) {
        if (treeData != null) {
            for (LinkedHashMap node : treeData) {
                if (orgCode.equals(node.get("orgCode"))) {
                    return Collections.singletonList(node);
                }
                if (node.get("children") != null) {
                    List<LinkedHashMap> result = orgCodeAndBelowGetTree((List<LinkedHashMap>) node.get("children"), orgCode);
                    if (!result.isEmpty()) {
                        return result;
                    }
                }
            }
        }
        return Collections.emptyList();
    }


    private List<LinkedHashMap> creatReceiveUnitTree(String bizType) {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        // 删除非监管机构的单位
        deleteData(result, REGULATOR_UNIT);
        // 过滤符合指定业务的监管单位
        filterTreeDataByType(result, bizType);
        List<LinkedHashMap> supervisionTree = result.stream().filter(e -> code.equals(e.get("orgCode"))).collect(Collectors.toList());
        List<LinkedHashMap> resultTree = updateNullChildren(supervisionTree);
        redisUtils.set(genRedisKey(bizType), resultTree, 60 * 60 * 2);
        return resultTree;
    }

    private String genRedisKey(String bizType) {
        return PREFIX_NOTICE_RECEIVE_UNIT_TREE + "_" + bizType;
    }

    @Override
    public List<LinkedHashMap> getApproveTree(ReginParams reginParams) {
        // 企业逻辑
        if (reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            List<LinkedHashMap> result = (List<LinkedHashMap>) redisUtils.get(ADMINISTRATION_UNIT_TREE);
            // 判断redis是否存在行政审批局树
            return !ObjectUtils.isEmpty(result) ? result : creatApproveTree();
        } else {
            // 监管单位逻辑
            return Collections.singletonList((LinkedHashMap) BeanUtil.beanToMap(reginParams.getCompany()));
        }

    }

    @Override
    public List<LinkedHashMap> creatApproveTree() {
        FeignClientResult tree = privilegeFeginService.queryAgencyTreeForCache(RequestContext.getToken(), RequestContext.getAppKey(), RequestContext.getProduct());
        List<LinkedHashMap> result = (List<LinkedHashMap>) tree.getResult();
        List<LinkedHashMap> children = (List<LinkedHashMap>) result.get(0).get("children");
        List<LinkedHashMap> treeData = deleteTreeData(children, REGULATOR_UNIT);
        List<LinkedHashMap> resultTree = updateNullChildren(treeData);
        redisUtils.set(ADMINISTRATION_UNIT_TREE, resultTree);
        return resultTree;
    }

    @Override
    public List<Map<String, Object>> superviseBusinessCategory(String businessType, String dataSource) {
        ReginParams reginParams = getSelectedOrgInfo();
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(superviseBusinessCategory);
        if (XZSB.equals(businessType) && CompanyTypeEnum.CONSTRUCTION.getName().equals(reginParams.getCompany().getCompanyType())) {
            Iterator<Map<String, Object>> iterator = resourceJson.get(businessType).iterator();
            while (iterator.hasNext()) {
                Map<String, Object> item = iterator.next();
                if (item.get(CODE).equals(DW_LR)) {
                    iterator.remove();
                }
            }
            return resourceJson.get(businessType);
        }
        // 历史有证设备(气瓶、管道)只能通过导入进系统，不能按单位录入进系统
        if (EquipSourceEnum.jg_his.getType().equals(dataSource)) {
            resourceJson.get(businessType).removeIf(item -> item.get(CODE).equals(DW_LR));
            return resourceJson.get(businessType);
        }
        return resourceJson.get(businessType);
    }

    @Override
    public List<Map<String, Object>> businessScenarios(String type) {
        ReginParams reginParams = getSelectedOrgInfo();
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(superviseBusinessCategory);
        // 新增设备 或者 安改维单位 只有按照设备种类选择的业务
        if (PL_DR.equals(type) || CompanyTypeEnum.CONSTRUCTION.getName().equals(reginParams.getCompany().getCompanyType())) {
            Iterator<Map<String, Object>> iterator = resourceJson.get(YWCJ).iterator();
            while (iterator.hasNext()) {
                Map<String, Object> item = iterator.next();
                if (item.get(DICT_DATA_KEY).equals("1")) {
                    iterator.remove();
                }
            }
            return resourceJson.get(YWCJ);
        }
        return resourceJson.get(YWCJ);

    }

    private List<LinkedHashMap> deleteTreeData(List<LinkedHashMap> result, String companyType) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            // 删除非监管机构
            Object companyTypeObj = e.get("companyType");
            if (companyTypeObj == null || !companyTypeObj.toString().contains(companyType)) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteTreeData((List<LinkedHashMap>) e.get("children"), companyType);
            }
        }
        return result;
    }

    private List<LinkedHashMap> filterTreeDataByType(List<LinkedHashMap> result, String type) {
        Iterator<LinkedHashMap> it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = it.next();
            if (!(e.get("description") != null && (e.get("description").toString().contains(type) || e.get("description").toString().contains("all")))) {
                // 过滤非全部（all）公共及指定类型外的
                it.remove();
            }
            // disabled的节点设置下不可编辑属性
            if (e.get("description") != null && e.get("description").toString().contains(type + "-disabled")) {
                // 过滤非全部（all）公共及指定类型外的
                e.put("disabled", true);
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                filterTreeDataByType((List<LinkedHashMap>) e.get("children"), type);

            }
        }
        return result;
    }

    private List<LinkedHashMap> deleteData(List<LinkedHashMap> result, String companyType) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            // 删除非指定的单位类型
            if (e.get("companyType") != null && !e.get("companyType").toString().contains(companyType)) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteData((List<LinkedHashMap>) e.get("children"), companyType);
            }
        }
        return result;
    }

    public List<Map<String, Object>> getTcmUnitListByType(String unitType, String unitName) {
        return commonMapper.getTcmUnitListByType(unitType, unitName);
    }

    @Override
    public List<Map<String, Object>> getUnitListByType(String type, String business, Boolean needAuth) {
        List<Map<String, Object>> unitList = new ArrayList<>();
        String internalType;
        switch (type) {
            case "use":
                internalType = "使用单位";
                break;
            case "maintenance":
                internalType = "安装改造维修单位";
                break;
            case "inspection":
                // 拆分：包含检验机构和检测机构
                internalType = "检验机构|检测机构";
                break;
            case "manufacture":
                internalType = "制造单位";
                break;
            case "all":
                internalType = "all";
                break;
            default:
                internalType = type;
                break;
        }

        // 提取字典逻辑（抽成方法）
        if ("gasCylindersForCars".equals(business)) {
            if ("检验机构|检测机构".equals(internalType)) {
                addDictUnitsToList("OLD_INSPECTION_TESTING_UNIT", unitList);
            }
            if ("安装改造维修单位".equals(internalType)) {
                addDictUnitsToList("OLD_INSTALLATION_UNIT", unitList);
            }
            if ("使用单位".equals(internalType)) {
                addDictUnitsToList("OLD_USE_UNIT", unitList);
            }
        }

        List<Map<String, Object>> unitListByType;
        if ("检验机构|检测机构".equals(internalType)) {
            // 合并两种子类型的数据
            List<Map<String, Object>> list1 = needAuth
                    ? commonMapper.getUnitInfoListByType("检验机构")
                    : commonMapper.getUnitListByType("检验机构");

            List<Map<String, Object>> list2 = needAuth
                    ? commonMapper.getUnitInfoListByType("检测机构")
                    : commonMapper.getUnitListByType("检测机构");

            unitListByType = new ArrayList<>();
            unitListByType.addAll(list1);
            unitListByType.addAll(list2);
        } else {
            unitListByType = needAuth
                    ? commonMapper.getUnitInfoListByType(internalType)
                    : commonMapper.getUnitListByType(internalType);
        }

        return new ArrayList<>(Stream.concat(unitList.stream(), unitListByType.stream())
                .collect(Collectors.toMap(
                        map -> String.valueOf(map.get("useCode")),
                        map -> map,
                        (existing, replacement) -> existing
                ))
                .values());
    }

    private void addDictUnitsToList(String dictKey, List<Map<String, Object>> unitList) {
        List<DictionarieValueModel> result = Systemctl.dictionarieClient.dictValues(dictKey).getResult();
        if (result != null) {
            result.forEach(x -> convertAndAddToUnitList(x, unitList));
        }
    }

    @Override
    public List<Map<String, Object>> getAllInspectionInfo(String type) {
        List<Map<String, Object>> unitList = new ArrayList<>();
        if ("检验机构".equals(type)|| "检测机构".equals(type)) {
            Systemctl.dictionarieClient.dictValues("OLD_INSPECTION_TESTING_UNIT").getResult()
                    .forEach(x -> convertAndAddToUnitList(x, unitList));
        }
        unitList.addAll(commonMapper.getUnitListByType(type));
        return unitList;
    }


    @Override
    public List<Map<String, Object>> getSecurityAdmin(String type, String companyCode) {
        if (ObjectUtils.isEmpty(companyCode)) {
            ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            companyCode = company.getCompanyCode();
        }
        List<String> post = new ArrayList<>();
        if (type.equals("use")) {
            post.add("6617");//安全管理员
        }
        if (type.equals("jyjc")) {
            post.add("66151");//检验人员
            post.add("66152");//检测人员
        }
        if (type.equals("agw")) {
            post.add("6553");// 安改维负责人
        }
        if (type.equals("wbry")) {
            post.add("6618");//维保人员
        }
        return ObjectUtils.isEmpty(post) ? new ArrayList<>() : commonMapper.getSecurityAdmin(companyCode, post);
    }

    @Override
    public Map<String, Object> getUserInfo(String sequenceNbr) {
        return commonMapper.getUserInfo(sequenceNbr.split("_")[0]);
    }

    @Override
    public Map<String, Object> getEnterpriseInfo(String useCode) {
        return commonMapper.getEnterpriseInfo(useCode);
    }

    @Override
    public List<Map<String, Object>> getEnterpriseEmployee(String unitCode) {
        return commonMapper.getEnterpriseEmployee(unitCode);
    }

    /**
     * 将管辖机构树中children为[]的修改为null
     *
     * @param result
     * @return
     */
    private List<LinkedHashMap> updateNullChildren(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            // 将管辖机构树中children为[]的修改为null
            if (e.get("children") != null) {
                if (((List<LinkedHashMap>) e.get("children")).size() == 0) {
                    e.put("children", null);
                }
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                updateNullChildren((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }

    /**
     * 删除管辖机构树中level为使用单位的数据
     *
     * @param result 管辖机构树
     * @return 筛选过滤后不包含使用单位的管辖机构树
     */
    private List<LinkedHashMap> deleteRegulatorTreeData(List<LinkedHashMap> result) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            LinkedHashMap e = (LinkedHashMap) it.next();
            // 删除使用单位
            if ("company".equals(e.get("level"))) {
                it.remove();
            }
            if (e.get("companyName").toString().contains("行政审批局")) {
                it.remove();
            }
            // 删除检验机构、检测机构
            String companyType = e.get("companyType").toString();
            if (!"company".equals(e.get("level")) && (companyType.contains("检验机构") || companyType.contains("检测机构"))) {
                it.remove();
            }
            if (!ObjectUtils.isEmpty(e.get("children"))) {
                deleteRegulatorTreeData((List<LinkedHashMap>) e.get("children"));
            }
        }
        return result;
    }

    @Override
    public void generateCertificateReport(Map<String, Object> map, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        String wordPath = "equipment-registration-certificate-report.ftl";
        wordPath = "unit".equals(map.get("manageType")) ? "unit-registration-certificate-report.ftl" : wordPath;
        // 组装模板变量
        map.put("useRegistrationCode", Optional.ofNullable(map.get("useRegistrationCode")).orElse("").toString()); // 编号
        map.put("useUnitName", Optional.ofNullable(map.get("useUnitName")).orElse("").toString());  // 使用单位名称
        map.put("fullAddress", Optional.ofNullable(map.get("fullAddress")).orElse("").toString());  // 设备使用地点
        map.put("equList", Optional.ofNullable(map.get("equList")).orElse("").toString());  // 设备种类
        map.put("equListCode", Optional.ofNullable(map.get("equListCode")).orElse("").toString());  // 设备种类Code
        map.put("equipDefine", Optional.ofNullable(map.get("equipDefine")).orElse("").toString());  // 设备品种
        map.put("equipCode", Optional.ofNullable(map.get("equipCode")).orElse("").toString());  // 设备代码
        map.put("equipCategory", Optional.ofNullable(map.get("equipCategory")).orElse("").toString());  // 设备类别
        map.put("useInnerCode", Optional.ofNullable(map.get("useInnerCode")).orElse("").toString());  // 单位内编号
        map.put("factoryNum", Optional.ofNullable(map.get("factoryNum")).orElse("").toString());  // 产品编号
        map.put("receiveOrgName", Optional.ofNullable(map.get("receiveOrgName")).orElse("").toString());  // 登记机关
        map.put("giveOutYear", Optional.ofNullable(map.get("giveOutYear")).orElse("").toString());  // 发证日期-年
        map.put("giveOutMonth", Optional.ofNullable(map.get("giveOutMonth")).orElse("").toString());  // 发证日期-月
        map.put("giveOutDay", Optional.ofNullable(map.get("giveOutDay")).orElse("").toString());  // 发证日期-日
        map.put("reissueDateYear", Optional.ofNullable(map.get("reissueDateYear")).orElse("").toString());  // 发证日期-年
        map.put("reissueDateMonth", Optional.ofNullable(map.get("reissueDateMonth")).orElse("").toString());  // 发证日期-月
        map.put("reissueDateDay", Optional.ofNullable(map.get("reissueDateDay")).orElse("").toString());  // 发证日期-日
        map.put("excelType", Optional.ofNullable(map.get("excelType")).orElse("使用登记").toString());  // 发证日期-日
        map.put("tableName", Optional.ofNullable(map.get("tableName")).orElse("特种设备使用登记证").toString());  // 发证日期-日
        map.put("carNumber", Optional.ofNullable(map.get("carNumber")).orElse("").toString());  // 车牌号
        map.put("overDesign", Optional.ofNullable(map.get("overDesign")).orElse("").toString());  // 超设计使用年限
        // 生成二维码,之前为设备监管码，调整为证编号
        String qrCode = ImageUtils.generateQRCode(getEncodeQrCode(Optional.ofNullable(map.get("certificateNo")).orElse("").toString(), "useCert", Optional.ofNullable(map.get("version")).orElse("").toString()), 100, 100);
        map.put("supervisoryCode", qrCode);  // 监管二维码
        // 默认普打
        map.put("printingType", PrintingTypeEnum.REGULAR.getCode());
        // word转pdf
        File pdfFile;
        try {
            pdfFile = this.wordToPdf("特种设备使用登记证_", wordPath, map);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }


        try {
            byte[] bytes = file2byte(pdfFile);
            String docTitle = pdfFile.getName();
            FileExporter.exportFile(FileExporter.FileType.valueOf("pdf"), docTitle, bytes, response);
        } catch (Exception e) {
            log.error("pdf文件转换失败", e);
        } finally {
            try {
                Files.deleteIfExists(pdfFile.toPath());
            } catch (Exception e) {
                log.error("文件找不到，删除失败", e);
            }
        }
    }

    private String getEncodeQrCode(String certNo, String certType, String version) {
        // aes加密并base64编码
        String certNoEncrypt = AESUtil.encrypt(certNo);
        // base64编码
        String certTypeBase64 = Base64Encoder.encode(certType, StandardCharsets.UTF_8);
        // aes加密并base64编码
        String versionEncrypt = AESUtil.encrypt(version);
        return qrcodePrefix +
                "?certNo=" +
                certNoEncrypt +
                "&certType=" +
                certTypeBase64 +
                "&version=" +
                versionEncrypt;
    }

    /**
     * 使用登记证套打生成Word
     *
     * @param map      参数
     * @param response 返回值
     */
    public void generateCertificateReportDoc(Map<String, Object> map, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException("参数不能为空");
        }

        // Populate template variables with default values if not present
        String[] keys = {"useRegistrationCode", "useUnitName", "fullAddress", "equList", "equipDefine", "equipCode",
                "equipCategory", "useInnerCode", "factoryNum", "receiveOrgName", "giveOutYear",
                "giveOutMonth", "giveOutDay", "excelType", "tableName", "carNumber", "overDesign"};
        String[] defaultValues = {"", "", "", "", "", "", "", "", "", "", "", "", "", "", "使用登记", "特种设备使用登记证", ""};

        for (int i = 0; i < keys.length; i++) {
            map.put(keys[i], Optional.ofNullable(map.get(keys[i])).orElse(defaultValues[i]).toString());
        }
        String qrCode = ImageUtils.generateQRCode(getEncodeQrCode(Optional.ofNullable(map.get("certificateNo")).orElse("").toString(), "useCert", Optional.ofNullable(map.get("version")).orElse("").toString()), 100, 100);
        map.put("supervisoryCode", qrCode);
        map.put("printingType", PrintingTypeEnum.OVERPLAY.getCode());
        String manageType = Optional.ofNullable(map.get("manageType")).orElse("").toString();
        String templateFileName = "use-registration-model.ftl";
        if ("unit".equals(manageType)) {
            templateFileName = "unit-use-registration-model.ftl";
        }
        File file = null;
        try (ServletOutputStream out = response.getOutputStream()) {
            file = WordTemplateUtils.createDoc("/templates/use-registration-model.ftl", map, configuration.getTemplate(templateFileName, "UTF-8"));

            try (InputStream fin = Files.newInputStream(file.toPath())) {
                response.setCharacterEncoding("utf-8");
                response.setContentType("application/msword");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("使用登记证套打.docx", "UTF-8"));

                byte[] buffer = new byte[512];
                int bytesRead;
                while ((bytesRead = fin.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("Error generating the certificate report", e);
        } finally {
            if (file != null && file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    /**
     * 返回附件
     *
     * @param map      参数
     * @param response 响应
     */
    @Override
    @Deprecated
    public void generatePdfPrint(Map<String, Object> map, HttpServletResponse response) {
        String[] DEFAULT_KEYS = {
                "useRegistrationCode", "useUnitName", "fullAddress", "equList", "equipDefine",
                "equipCode", "equipCategory", "useInnerCode", "factoryNum", "giveOutYear",
                "giveOutMonth", "giveOutDay"
        };

        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException("参数不能为空");
        }

        // 设置默认值
        Arrays.stream(DEFAULT_KEYS)
                .forEach(key -> map.computeIfAbsent(key, k -> ""));

        // 生成二维码,之前为设备监管码，调整为证编号
        String qrCode = ImageUtils.generateQRCode(getEncodeQrCode(Optional.ofNullable(map.get("certificateNo")).orElse("").toString(), "useCert", Optional.ofNullable(map.get("version")).orElse("").toString()), 100, 100);
        map.put("supervisoryCode", qrCode);  // 监管二维码 代码优化
        this.fillParamValueToPdf(map, response, "templates/use-registration-model.pdf", "套打使用登记证.pdf", 12.0f);
    }

    @Override
    public byte[] generateSummaryOfCylinderInfo(Map<String, Object> map, String wordPath, String filePrefix) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        // word转pdf
        File pdfFile;
        try {
            pdfFile = this.wordToPdf("", wordPath, map);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        // file转字节流
        try {
            return file2byte(pdfFile);
        } catch (Exception e) {
            log.error("pdf文件转换失败：{}", e);
        } finally {
            try {
                Files.deleteIfExists(pdfFile.toPath());
            } catch (Exception e) {
                log.error("文件找不到，删除失败：{}", e);
            }
        }
        return new byte[0];
    }

    /**
     * 根据参数填充PDF文本域
     *
     * @param map           参数
     * @param response      response
     * @param pathResource  PDF模版路径
     * @param printFileName 生成文件名称
     * @param textSize      字体大小
     */
    void fillParamValueToPdf(Map<String, Object> map, HttpServletResponse response, String pathResource, String printFileName, float textSize) {
        // 读取资源文件夹下的模板
        ClassPathResource resource = new ClassPathResource(pathResource);

        PdfReader reader = null;
        ByteArrayOutputStream bos = null;
        try {
            InputStream inputStream = resource.getInputStream();
            reader = new PdfReader(inputStream);
            bos = new ByteArrayOutputStream();
            PdfStamper pdfStamper = new PdfStamper(reader, bos);
            AcroFields acroFields = pdfStamper.getAcroFields();
            // 中文字体
            BaseFont font = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);

            for (Map.Entry<String, Object> param : map.entrySet()) {
                // 设置文本域的字体为中文字体
                acroFields.setFieldProperty(param.getKey(), "textfont", font, null);
                // 设置字体大小
                acroFields.setFieldProperty(param.getKey(), "textsize", textSize, null);
                // 将 map 中的值写到 pdf 模板对应的文本域中
                acroFields.setField(param.getKey(), param.getValue() + "");
            }

            // 如果为false那么生成的PDF文件还能编辑，所以一定要设为true
            pdfStamper.setFormFlattening(true);
            pdfStamper.close();

            this.writeAttachment(response, bos.toByteArray(), printFileName);
        } catch (IOException | DocumentException e) {
            e.printStackTrace();
        } finally {
            try {
                assert bos != null;
                bos.close();
                reader.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 返回附件
     *
     * @param response 响应
     * @param content  附件内容
     */
    private void writeAttachment(HttpServletResponse response, byte[] content, String printFileName) throws IOException {
        // 设置 header 和 contentType
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(printFileName, "UTF-8"));
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
        // 输出附件
        IoUtil.write(response.getOutputStream(), false, content);
    }

    /**
     * word 转 pdf
     *
     * @param wordPath word文件路径
     */
    public File wordToPdf(String filePrefix, String wordPath, Map<String, Object> placeholders) throws Exception {
        Assert.hasText(wordPath, "word文件路径不能为空");

        String tempFileName = filePrefix + System.currentTimeMillis() + Thread.currentThread().getName() + "_temp.pdf";

        WordTemplateUtils instance = WordTemplateUtils.getInstance();

        return instance.fillAndConvertDocFile(wordPath, tempFileName, placeholders, SaveFormat.PDF);
    }

    /**
     * 上传文件至文件服务器
     *
     * @param file 文件
     * @param path 路径
     */
    public String uploadFile(File file, String path) {
        Assert.notNull(file, "文件不能为空");

        MultipartFile multipartFile = new ByteArrayMultipartFile("file", "file.pdf", "application/pdf", file2byte(file));
        // 返回路径 ： upload/common/${path}/xxx.xx
        FeignClientResult<Map<String, String>> result = Systemctl.fileStorageClient.updateCommonFileFree(multipartFile, path);
        String urlString = "";
        if (result != null) {
            for (String s : result.getResult().keySet()) {
                urlString = s;
            }
        }
        return urlString;
    }

    @Override
    public Object invokeBusinessProcess(String submitType, Map<String, Object> map, ReginParams reginParams) {
        Map<String, Object> basicObj = (Map<String, Object>) map.get(basic);
        Map<String, Object> noticeObj = (Map<String, Object>) map.get(notice);
        Map<String, Object> techInfoObj = (Map<String, Object>) map.get(techInfo);
        Map<String, Object> useRegFormUploadObj = (Map<String, Object>) map.get(useRegFormUpload);
        Map<String, Object> provideMap = new HashMap<>();

        String type = (String) basicObj.get("type");
        noticeObj.put("businessCode", type);
        if (type.equals(ApplicationFormTypeEnum.AZGZ.getBusinessCode())) {
            JgInstallationNoticeDto jgInstallationNoticeDto = JSON.parseObject(JSON.toJSONString(noticeObj), JgInstallationNoticeDto.class);
            jgInstallationNoticeDto.setReceiveOrgCreditCode(!ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject1 = (JSONObject) JSONObject.toJSON(jgInstallationNoticeDto);
            provideMap.put(AZGZ_FORM_ID, jsonObject1);
            JSONObject jsonObject = new JSONObject(provideMap);
            return iJgInstallationNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.GZGZ.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(GZGZ_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return jgReformNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.WXGZ.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(WXGZ_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return iJgMaintainNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.YZGZ.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(YZGZ_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return jgTransferNoticeService.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.SYDJ.getBusinessCode())) {
            String businessScenarios = (String) basicObj.get("businessScenarios");
            String code = (String) basicObj.get("code");
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            if (submitType.equals("1")) {
                jsonObject.put("submit", Boolean.TRUE);
            }
            jsonObject.putAll(useRegFormUploadObj);
            // 判断是否为车用气瓶使用登记或者设备使用登记
            return "1".equals(businessScenarios) && CylinderTypeEnum.CYLINDER.getCode().equals(code) ?
                    jgVehicleInformationService.save(submitType, jsonObject) : jgUseRegistrationServiceImpl.save(jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.GZBG.getBusinessCode())) {
            // 兼容业务逻辑代码
            if (submitType.equals("1")) {
                noticeObj.put("submit", "true");
            }
            noticeObj.put("receiveCompanyCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            noticeObj.put("techInfo", techInfoObj);
            JSONObject jsonObject = new JSONObject(noticeObj);
            return jgChangeRegistrationReformServiceImpl.save(jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.YZBG.getBusinessCode())) {
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(YZBG_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return jgChangeRegistrationTransferService.createTransfer(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.DWBG.getBusinessCode()) && !ObjectUtils.isEmpty(basicObj.get("equCategory")) && CylinderTypeEnum.SPECIAL_CYLINDER.getCode().equals(basicObj.get("equCategory").toString())) {
            noticeObj.put("submit", submitType);
            noticeObj.put("formType", "add");
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            return jgChangeVehicleRegistrationUnitService.saveMessage(jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.DWBG.getBusinessCode()) && !ObjectUtils.isEmpty(noticeObj.get("EQU_LIST_CODE")) && PipelineEnum.PRESSURE_PIPELINE.getCode().equals(noticeObj.get("EQU_LIST_CODE").toString())) {
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(DWBG_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return jgChangeRegistrationUnitServiceImpl.saveUnitByProjectContraption(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.DWBG.getBusinessCode())) {
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(DWBG_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return jgChangeRegistrationUnitServiceImpl.saveNotice(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.WBBA.getBusinessCode())) {
            noticeObj.put("equList", basicObj.get("code"));
            noticeObj.put("pageType", "add");
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            return jgMaintenanceContractServiceImpl.saveOrSubmit(submitType, jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.SBYJ.getBusinessCode())) {
            noticeObj.put("businessCode", type);
            JSONObject jsonObject = new JSONObject(noticeObj);
            return jgEquipTransferServiceImpl.saveTransfer(submitType, jsonObject, reginParams);
        } else if (type.contains(ApplicationFormTypeEnum.ZX.getBusinessCode()) || type.contains(ApplicationFormTypeEnum.BF.getBusinessCode())) {
            noticeObj.put("cancelType", type.equals("BF_ZX") ? "1" : "2");
            noticeObj.put("receiveOrgCreditCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(SBZX_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return jgScrapCancelService.saveList(submitType, jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.GMBG.getBusinessCode())) {

            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            provideMap.put(GMBG_PAGE_ID, noticeObj);
            JSONObject jsonObject = new JSONObject(provideMap);
            return jgChangeRegistrationNameService.save2(submitType, jsonObject);
        } else if (type.equals(ApplicationFormTypeEnum.SBQY.getBusinessCode()) || type.equals(ApplicationFormTypeEnum.SBTY.getBusinessCode())) {
            noticeObj.put("submit", submitType);
            noticeObj.put("formType", "add");
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            return jgEnableDisableServiceImpl.saveOrUpdate(jsonObject, reginParams);
        } else if (type.equals(ApplicationFormTypeEnum.CSJ.getBusinessCode())) {
            String uploadMode = Objects.toString(useRegFormUploadObj != null ? useRegFormUploadObj.get("uploadMode") : "", "");
            noticeObj.put("submit", "1".equals(uploadMode) ? "1" : "0");
            noticeObj.put("formType", "add");
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            jsonObject.putAll(useRegFormUploadObj);
            return jgOverDesignServiceLifeService.saveOrUpdate(jsonObject, reginParams);
        }  else if (ApplicationFormTypeEnum.BZDJ.getBusinessCode().equals(type)) {
            noticeObj.put("receiveOrgCode", !ObjectUtils.isEmpty(basicObj.get("receiveOrgCreditCode")) ? String.valueOf(basicObj.get("receiveOrgCreditCode")) : String.valueOf(basicObj.get("receiveOrgCreditCode1")));
            JSONObject jsonObject = new JSONObject(noticeObj);
            jsonObject.put(JgCertificateReplenishServiceImpl.SHOULD_SUBMIT, "1".equals(submitType) ? JgCertificateReplenishServiceImpl.SUBMITTED : JgCertificateReplenishServiceImpl.DRAFT);
            jsonObject.putAll(useRegFormUploadObj);
            return jgCertificateReplenishServiceImpl.save(jsonObject);
        }
        return null;
    }

    @Override
    @FieldMapping({
            @FieldMapping.FieldMap(sourceField = "second.estateUnitSeq",
                    targetField = "second.estateUnitName",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryTcmUnitCreditCodeAndNameBySeq",
                    secondParamValue = "CQ"
            )
    })
    public Object invokeBusinessType(Map<String, Object> map) {
        String historyEquType = (String) map.get(HISTORY_EQU_TYPE);
        String historySubmitType = (String) map.get(HISTORY_SUBMIT_TYPE);
        JSONObject jsonObject = new JSONObject((Map<String, Object>) map.get(SECOND));
        Map<String, Object> useRegFormUploadObj = (Map<String, Object>) map.get(useRegFormUpload);
        String uploadMode = String.valueOf(useRegFormUploadObj.get("uploadMode"));
        jsonObject.put("historySubmitType", historySubmitType);
        jsonObject.put("historyEquType", historyEquType);

        Map<String, Function<JSONObject, Object>> handlerMap = new HashMap<>();
        handlerMap.put("unit", jgUseRegistrationServiceImpl::handleUnitHistoryEquip);
        handlerMap.put("vehicle", jgVehicleInformationService::saveOrUpdateHisData);
        handlerMap.put("set_sp", obj -> handleSpecialRegistration(obj, useRegFormUploadObj, uploadMode,
                jgUseRegistrationServiceImpl::handleUseRegistration));
        handlerMap.put("unit_sp", obj -> handleSpecialRegistration(obj, useRegFormUploadObj, uploadMode,
                jgUseRegistrationServiceImpl::handleUnitUseRegistration));
        return handlerMap.getOrDefault(historyEquType, jgUseRegistrationServiceImpl::handleHistoryEquip)
                .apply(jsonObject);
    }

    /**
     * 处理特殊登记逻辑
     */
    private Object handleSpecialRegistration(JSONObject jsonObject, Map<String, Object> useRegFormUploadObj,
                                             String uploadMode, Function<JSONObject, Object> handler) {
        jsonObject.put("regType", "2");
        jsonObject.put("businessCode", "DJ_SY");
        if ("1".equals(uploadMode)) {
            jsonObject.put("submit", Boolean.TRUE);
        }
        jsonObject.putAll(useRegFormUploadObj);
        return handler.apply(jsonObject);
    }

    @Override
    public Object updateHistory(Map<String, Object> map) {
        String historyEquType = (String) map.get(HISTORY_EQU_TYPE);
        String historySubmitType = (String) map.get(HISTORY_SUBMIT_TYPE);
        JSONObject jsonObject = new JSONObject(map);
        jsonObject.put("historySubmitType", historySubmitType);
        switch (historyEquType) {
            case "unit":
//                return jgUseRegistrationServiceImpl.handleUnitHistoryEquip(jsonObject);
                return null;
            case "vehicle":
                return jgVehicleInformationService.updateHistoryByVehicle(jsonObject);
            default:
                return jgUseRegistrationServiceImpl.updateHistoryBySet(jsonObject);
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Object transfer(Map<String, Object> map) {
        if (ObjectUtils.isEmpty(map.get("nextTaskId")) || map.get("nextTaskId") == null) {
            throw new BadRequest("nextTaskId不能为空");
        }
        if (ObjectUtils.isEmpty(map.get("instanceId")) || map.get("instanceId") == null) {
            throw new BadRequest("instanceId不能为空");
        }
        String taskId = map.get("nextTaskId").toString();
        String instanceId = map.get("instanceId").toString();
        String tableName = map.get("tableName").toString();
        String assignee = map.get("assignee").toString();
        String lockKey = buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行前置校验
            this.checkForExecuteFlow(taskId, instanceId);
            FlowTaskVo flowTaskVo = new FlowTaskVo();
            flowTaskVo.setTaskId(taskId);
            flowTaskVo.setAssignee(assignee);
            ProcessTaskDTO processTaskDTO = cmWorkflowService.assign(flowTaskVo);
            // 修改待办
            List<TaskV2Model> collect = taskV2FeignService.selectListByRelationId(instanceId).getResult();
            if (collect.isEmpty()) {
                return null;
            }
            TaskV2Model taskV2Model = collect.get(0);
            taskV2Model.setExecuteUserIds(RequestContext.getExeUserId());
            taskV2Model.setTaskStatus(FlowStatusEnum.TO_BE_TRANSFER.getCode());
            taskV2Model.setTaskStatusLabel(FlowStatusEnum.TO_BE_TRANSFER.getName());
            taskV2Model.setEndUserId(RequestContext.getExeUserId());
            taskV2Model.setEndDate(new Date());
            String routhPath = taskV2Model.getRoutePath().replace("nextExecuteUserIds", "executeUserId") + "&nextExecuteUserIds=" + assignee;
            taskV2Model.setRoutePath(routhPath);
            taskV2FeignService.update(taskV2Model, taskV2Model.getSequenceNbr());
            // 创建新待办
            taskV2Model.setExecuteUserIds(assignee);
            String nextTaskId = processTaskDTO.getNextTask().get(0).getId();
            taskV2Model.setFlowCode(nextTaskId);
            String routhPath1 = routhPath.replace("nextTaskId", "nextTask") + "&nextTaskId=" + nextTaskId;
            taskV2Model.setCreateDate(new Date());
            taskV2Model.setRoutePath(routhPath1);
            taskV2Model.setTaskStatus(0);
            taskV2Model.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
            taskV2Model.setEndUserId(null);
            taskV2Model.setEndDate(null);
            taskV2Model.setSequenceNbr(null);
            taskV2FeignService.create(taskV2Model);

            String id = commonMapper.selectBusinessData(tableName, instanceId);
            id = ObjectUtils.isEmpty(id) ? assignee : id + "," + assignee;
            // 修改业务数据
            commonMapper.updateBusinessData(tableName, assignee, id, instanceId, nextTaskId);
            this.saveExecuteFlowData2Redis(instanceId, InstanceRuntimeData.builder()
                    .nextExecuteUserIds(assignee)
                    .nextTaskId(nextTaskId)
                    .promoter(commonMapper.selectPromoterData(tableName, instanceId)).build());
            return Boolean.TRUE;
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return Boolean.FALSE;
    }

    /**
     * 删除代办及中止流程
     *
     * @param businessId 业务seq
     * @param instanceId 业务流程id
     */
    public void deleteTaskModel(String businessId, String instanceId) {
        // 删除暂存的代办
        deleteTasksByRelationId(businessId);
        // 删除流程中的代办 及 中止流程
        if (!ObjectUtils.isEmpty(instanceId)) {
            deleteTasksAndStopProcess(instanceId, "发起人主动删除业务单");
        }
    }

    /**
     * 删除代办 -根据任务关联
     *
     * @param relationId
     */
    public void deleteTasksByRelationId(String relationId) {
        List<TaskV2Model> tasks = taskV2FeignService.selectListByRelationId(relationId).getResult();
        if (!tasks.isEmpty()) {
            String ids = tasks.stream()
                    .map(TaskV2Model::getSequenceNbr)
                    .map(Object::toString)
                    .collect(Collectors.joining(","));
            taskV2FeignService.delete(ids);
        }
    }

    public void deleteTasksAndStopProcess(String instanceId, String reason) {
        deleteTasksByRelationId(instanceId);
        // 中止流程
        cmWorkflowService.stopProcess(instanceId, reason);
    }

    /**
     * 待办新增接口
     **/
    public void buildTaskModel(List<TaskModelDto> list) {
        List<TaskV2Model> taskV2Models = new ArrayList<>();
        for (TaskModelDto obj : list) {
            // 判断是否是暂存 新增若无下一节点执行人即为暂存
            boolean flag = StringUtils.isEmpty(obj.getNextExecuteUser());
            if (flag) {
                List<TaskV2Model> result = taskV2FeignService.selectListByRelationId(obj.getRelationId()).getResult();
                if (CollectionUtil.isNotEmpty(result) && !result.isEmpty()) {
                    break;
                }
            }
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            TaskV2Model model = new TaskV2Model();
            BeanUtil.copyProperties(obj, model);
            String urlParams = "";
            try {
                urlParams = "&" + toQueryParams(obj.getModel());
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            List<Map> urlList = JsonUtils.getResourceList(urlInfo);
            for (Map map : urlList) {
                // 获取暂存的可编辑页面url
                if (flag && map.get("type").equals(obj.getTaskType())
                        && map.get("pageType").equals("draft")) {
                    model.setRoutePath(map.get("url").toString() + urlParams);
                    break;
                }
                // 维保需特殊获取页面  状态不等于监管单位审核的页面均取对应编辑页面
                else if (map.get("type").equals(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode())
                        && obj.getTaskType().equals(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode())
                        && !obj.getFlowStatus().toString().equals("16723")
                        && map.get("pageType").equals("edit")) {
                    model.setRoutePath(map.get("url").toString().replace("{roleIds}", obj.getNextExecuteUser()) + urlParams + "&nextExecuteUserIds=" + model.getExecuteUserIds());
                    break;
                }
                // 其他逻辑均按详情页面获取
                else if (map.get("type").equals(obj.getTaskType())
                        && map.get("pageType").equals(null == obj.getPageType() ? "look" : obj.getPageType())) {
                    model.setRoutePath(map.get("url").toString().replace("{roleIds}", obj.getNextExecuteUser()) + urlParams + "&nextExecuteUserIds=" + model.getExecuteUserIds());
                    break;
                }
            }
            // 是true则为暂存 除公共部分统一处理
            if (flag) {
                model.setFlowStatus(FlowStatusEnum.TO_BE_SUBMITTED.getCode());
                model.setFlowStatusLabel(FlowStatusEnum.TO_BE_SUBMITTED.getName());
                model.setStartUserId(RequestContext.getExeUserId());
                model.setStartUser(reginParams.getUserModel().getRealName());
                model.setStartUserCompanyName(reginParams.getCompany().getCompanyName());
                model.setStartDate(new Date());
                model.setExecuteUserIds(RequestContext.getExeUserId());
                model.setFlowCreateDate(new Date());
                model.setTaskStatus(FlowStatusEnum.TO_BE_SUBMITTED.getCode());
                model.setTaskTitle("有一条待提交的草稿");
                model.setTaskName(BusinessTypeEnum.getNameByType(obj.getTaskType()));
                model.setTaskTypeLabel(BusinessTypeEnum.getNameByType(obj.getTaskType()));
                //     model.setTaskContent("【申请单号:"+obj.getTaskCode()+"】待提交");
            } else {
                model.setTaskStatus(0);
                model.setTaskTitle(obj.getStartUser() + "发起了" + obj.getTaskName());
            }
            model.setFlowInstanceId(model.getRelationId());
            model.setTaskSource("workFlow");
            model.setExtras(JSON.toJSONString(obj.getModel()));
            // model.setTerminal(params.getOrDefault("terminal","WEB").toString());
            model.setCreateDate(new Date());
            model.setRecUserId(RequestContext.getExeUserId());
            model.setAgencyCode(RequestContext.getAgencyCode());
            taskV2Models.add(model);

        }
        taskV2FeignService.batchAdd(taskV2Models);
    }

    /**
     * 待办编辑接口
     * 参数
     * taskStatus
     * taskStatusLabel 操作名称  6614驳回 6616已完成 6612待受理
     * flowStatusLabel  任务状态枚举code
     * 流程实例id  instanceId
     * flowCode 任务id
     **/
    public TaskV2Model updateTaskModel(Map<String, Object> params) {
        String exeUserId = RequestContext.getExeUserId();
        // 平台接口已调整 按照创建时间倒叙排列
        List<TaskV2Model> collect = taskV2FeignService.selectListByRelationId(params.get("relationId").toString()).getResult();

        if (collect.isEmpty()) {
            return null;
        }
        collect.get(0).setFlowStatus(Integer.valueOf(params.get("flowStatus").toString()));
        collect.get(0).setFlowStatusLabel(params.get("flowStatusLabel").toString());
        collect.get(0).setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
        collect.get(0).setTaskStatusLabel(params.get("taskStatusLabel").toString());
        collect.get(0).setEndUserId(exeUserId);
        collect.get(0).setEndDate(new Date());

//        String[] roleIds = model.getRoutePath().split("roleIds=");
//        String[] userIds = roleIds[1].split("&userId");
//        String url = roleIds[0]+"roleIds="+"55555"+"&userId"+ userIds[1];
//        String tarUrl = url.replaceFirst("&executeUserIds=", "");
//        tarUrl+"&executeUserIds="
        // model.setRoutePath( roleIds[0]+"roleIds="+"55555"+"&userId"+userIds[1]);
        // 当流程完成时将所有待办状态统一修改为已完成
        if (collect.get(0).getFlowStatusLabel().equals(FlowStatusEnum.TO_BE_FINISHED.getName())) {
            String urlParams = "";
            try {
                urlParams = "&" + toQueryParams(params.get("model"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            List<Map> urlList = JsonUtils.getResourceList(urlInfo);
            for (Map map : urlList) {
                if (map.get("type").equals(collect.get(0).getTaskType()) && map.get("pageType").equals("look")) {
                    urlParams = map.get("url").toString().replace("{roleIds}", "") + urlParams + "&taskStatus" + collect.get(0).getTaskStatus() + "&nextExecuteUserIds=";
                    break;
                }
            }
            collect.get(0).setRoutePath(urlParams);
            for (TaskV2Model taskV2Model : collect) {
                taskV2Model.setTaskStatusLabel((FlowStatusEnum.TO_BE_FINISHED.getName()));
                taskV2Model.setTaskStatus(FlowStatusEnum.TO_BE_FINISHED.getCode());
                taskV2Model.setFlowStatusLabel((FlowStatusEnum.TO_BE_FINISHED.getName()));
                taskV2Model.setFlowStatus(FlowStatusEnum.TO_BE_FINISHED.getCode());
            }
            taskV2FeignService.batchUpdate(collect);
        } else {
            collect.get(0).setRoutePath(collect.get(0).getRoutePath().replace("roleIds=", "roleIds=55555&fq="));
            taskV2FeignService.update(collect.get(0), collect.get(0).getSequenceNbr());
        }
        // 修改model并返回 用于组装新待办
        collect.get(0).setEndUserId(null);
        collect.get(0).setTaskStatus(null);
        collect.get(0).setEndDate(null);
        collect.get(0).setSequenceNbr(null);
        collect.get(0).setCreateDate(new Date());
        collect.get(0).setStartDate(new Date());
        return collect.get(0);
    }

    /**
     * 待办编辑接口       【如果没有代办直接返回空，业务判断】   ---- 在用，误删
     * 参数
     * taskStatus
     * taskStatusLabel 操作名称  1驳回 2通过 3重新提交
     * flowStatusLabel  任务状态枚举code
     * 流程实例id  instanceId
     * flowCode 任务id
     **/
    public TaskV2Model updateTaskModelNew(Map<String, Object> params) {
        String exeUserId = RequestContext.getExeUserId();
        // 平台接口已调整 按照创建时间倒叙排列
        List<TaskV2Model> collect = taskV2FeignService.selectListByRelationId(params.get("relationId").toString()).getResult();
        if (null == collect || collect.isEmpty()) {
            TaskV2Model model = new TaskV2Model();
            model.setFlowStatus(Integer.valueOf(params.get("flowStatus").toString()));
            model.setFlowStatusLabel(params.get("flowStatusLabel").toString());
            model.setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
            model.setTaskStatusLabel(params.get("taskStatusLabel").toString());
            return model;
        }
        collect.get(0).setFlowStatus(Integer.valueOf(params.get("flowStatus").toString()));
        collect.get(0).setFlowStatusLabel(params.get("flowStatusLabel").toString());
        collect.get(0).setTaskStatus(Integer.valueOf(params.get("taskStatus").toString()));
        collect.get(0).setTaskStatusLabel(params.get("taskStatusLabel").toString());
        collect.get(0).setEndUserId(exeUserId);
        collect.get(0).setEndDate(new Date());
        // 当流程完成时将所有待办状态统一修改为已完成
        if (collect.get(0).getFlowStatusLabel().equals(FlowStatusEnum.TO_BE_FINISHED.getName())) {
            String urlParams = "";
            try {
                urlParams = "&" + toQueryParams(params.get("model"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            List<Map> urlList = JsonUtils.getResourceList(urlInfo);
            for (Map map : urlList) {
                if (map.get("type").equals(collect.get(0).getTaskType()) && map.get("pageType").equals("look")) {
                    urlParams = map.get("url").toString().replace("{roleIds}", "") + urlParams + "&nextExecuteUserIds=";
                    break;
                }
            }
            collect.get(0).setRoutePath(urlParams);
            for (TaskV2Model taskV2Model : collect) {
                taskV2Model.setTaskStatusLabel((FlowStatusEnum.TO_BE_FINISHED.getName()));
                taskV2Model.setTaskStatus(FlowStatusEnum.TO_BE_FINISHED.getCode());
                taskV2Model.setFlowStatusLabel((FlowStatusEnum.TO_BE_FINISHED.getName()));
                taskV2Model.setFlowStatus(FlowStatusEnum.TO_BE_FINISHED.getCode());
            }
            taskV2FeignService.batchUpdate(collect);
        } else {
            collect.get(0).setRoutePath(collect.get(0).getRoutePath().replace("roleIds=", "roleIds=55555&fq="));
            taskV2FeignService.update(collect.get(0), collect.get(0).getSequenceNbr());
        }
        collect.get(0).setEndUserId(null);
        collect.get(0).setTaskStatus(null);
        collect.get(0).setEndDate(null);
        collect.get(0).setSequenceNbr(null);
        collect.get(0).setCreateDate(new Date());
        collect.get(0).setStartDate(new Date());
        return collect.get(0);
    }

    /**
     * 待办 撤回
     *
     * @param id  工作流实例id
     * @param obj 自己的实体：taskType为BusinessTypeEnum code；nextExecuteUser
     */
    public void rollbackTask(String id, JSONObject obj) {

        List<TaskV2Model> list = taskV2FeignService.selectListByRelationId(id).getResult();
        TaskV2Model model = list.get(0);
        taskV2FeignService.delete(String.valueOf(model.getSequenceNbr()));

        String urlParams = "";
        urlParams = "&" + toQueryParams2(obj);
        List<Map> urlList = JsonUtils.getResourceList(urlInfo);

        if (list.size() > 1) {
            TaskV2Model lastTaskModel = list.get(1);
            lastTaskModel.setEndUserId(null);
            lastTaskModel.setEndDate(null);
            lastTaskModel.setTaskStatus(FlowStatusEnum.TO_SUBMITTED.getCode());
            lastTaskModel.setTaskStatusLabel("重新提交");
            lastTaskModel.setFlowCode(obj.get("nextTaskId").toString());
            if (obj.get("flowStatus") != null) {
                lastTaskModel.setFlowStatus(Integer.valueOf(obj.get("flowStatus").toString()));
            }
            if (obj.get("flowStatusLabel") != null) {
                lastTaskModel.setFlowStatusLabel(obj.get("flowStatusLabel").toString());
            }

            for (Map map : urlList) {
                if (map.get("type").equals(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode()) && obj.getString("taskType").equals(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode()) && map.get("pageType").equals("edit")) {
                    lastTaskModel.setRoutePath(map.get("url").toString().replace("{roleIds}", obj.getString("nextExecuteUser")) + urlParams);
                    break;
                } else if (map.get("type").equals(obj.get("taskType")) && map.get("pageType").equals(obj.getOrDefault("pageType", "edit"))) {
                    lastTaskModel.setRoutePath(map.get("url").toString().replace("{roleIds}", obj.get("nextExecuteUser").toString()) + urlParams);
                    break;
                }
            }
            taskV2FeignService.update(lastTaskModel, lastTaskModel.getSequenceNbr());
        } else if (list.size() == 1) {
            model.setExecuteUserIds(model.getStartUserId());
            model.setTaskStatusLabel("重新提交");
            model.setTaskStatus(FlowStatusEnum.TO_SUBMITTED.getCode());
            model.setSequenceNbr(null);
            if (obj.get("flowStatus") != null) {
                model.setFlowStatus(Integer.valueOf(obj.get("flowStatus").toString()));
            }
            if (obj.get("flowStatusLabel") != null) {
                model.setFlowStatusLabel(obj.get("flowStatusLabel").toString());
            }
            for (Map map : urlList) {
                if (map.get("type").equals(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode()) && obj.getString("taskType").equals(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getCode()) && map.get("pageType").equals("edit")) {
                    model.setRoutePath(map.get("url").toString().replace("{roleIds}", obj.getString("nextExecuteUser")) + urlParams);
                    break;
                } else if (map.get("type").equals(obj.get("taskType")) && map.get("pageType").equals("edit")) {
                    model.setRoutePath(map.get("url").toString().replace("{roleIds}", obj.get("nextExecuteUser").toString()) + urlParams);
                    break;
                }
            }
            taskV2FeignService.create(model);
        }
    }

    public <T> String toQueryParams(T obj) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();

        for (Class<?> clazz = obj.getClass(); !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();

            for (Field field : fields) {
                if (!Modifier.isStatic(field.getModifiers())) {
                    field.setAccessible(true);

                    try {
                        Object value = field.get(obj);

                        if (value != null && !"".equals(value)) {
                            String encodedValue = URLEncoder.encode(value.toString(), "UTF-8");
                            sb.append(field.getName()).append('=').append(encodedValue).append('&');
                        }
                    } catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    /**
     * 根据流程状态name 获取流程状态code
     *
     * @param name 流程状态name
     * @return 流程状态code
     */
    public Integer getDictionaryCodeByName(String name) {
        List<DataDictionary> jggzzz = iDataDictionaryService.getByType("JGGZZZ");
        for (DataDictionary item : jggzzz) {
            if (item.getName().equals(name)) {
                return Integer.parseInt(item.getCode());
            }
        }
        return null;
    }

    /**
     * 根据工作流返回信息，组装业务需要的数据
     *
     * @param processTaskDTOS 工作流返回信息
     * @return 组装后的信息
     */
    public List<WorkflowResultDto> buildWorkFlowInfo(List<ProcessTaskDTO> processTaskDTOS) {
        List<WorkflowResultDto> workflowResultDtoList = new ArrayList<>();
        processTaskDTOS.forEach(item -> {
            WorkflowResultDto workflowResultDto = new WorkflowResultDto();
            if (!ObjectUtils.isEmpty(item.getProcessInstance())) {
                workflowResultDto.setInstanceId(item.getProcessInstance().getId());
            }
            if (!ObjectUtils.isEmpty(item.getTask())) {
                workflowResultDto.setTaskName(item.getTask().getName());
            }
            if (!ObjectUtils.isEmpty(item.getCandidateGroups())) {
                workflowResultDto.setExecutorRoleIds(String.join(",", item.getCandidateGroups()));
            }
            if (!ObjectUtils.isEmpty(item.getStartUser())) {
                workflowResultDto.setStartUserId(item.getStartUser().getUserId());
                workflowResultDto.setStartUserName(item.getStartUser().getRealName());
            }
            if (!ObjectUtils.isEmpty(item.getExecutor())) {
                workflowResultDto.setExecutorId(item.getExecutor().getUserId());
                workflowResultDto.setExecutorName(item.getExecutor().getRealName());
            }
            if (!CollectionUtils.isEmpty(item.getNextTask())) {
                ActTaskDTO actTaskDTO = item.getNextTask().get(item.getNextTask().size() - 1);
                workflowResultDto.setNextTaskId(actTaskDTO.getId());
                workflowResultDto.setNextTaskCode(actTaskDTO.getKey());
                workflowResultDto.setNextTaskName(actTaskDTO.getName());
                List<String> nextGroups = item.getNextCandidateGroups().get(actTaskDTO.getId());
                String join = String.join(",", nextGroups);
                workflowResultDto.setNextExecutorRoleIds(join);
                List<String> nextUserIds = item.getNextTaskExecutor().get(actTaskDTO.getId()).stream().map(AgencyUserModel::getUserId).collect(Collectors.toList());
                String nextUserIdsString = String.join(",", nextUserIds);
                workflowResultDto.setNextExecutorUserIds(nextUserIdsString);
            }
            workflowResultDtoList.add(workflowResultDto);
        });
        return workflowResultDtoList;
    }

    @Override
    public List<LinkedHashMap> getCompanyUser(Long companyId) {
        FeignClientResult result = privilegeFeginService.getCompanyUser(companyId);
        List<LinkedHashMap> list = (List<LinkedHashMap>) result.getResult();
        return list;
    }


    /**
     * 生成使用登记编号
     *
     * @param equipId                设备id
     * @param supervisoryCompanyCode 接收机构单位代码
     * @return 使用登记编号
     */
    public String generateRegistrationCode(String equipId, String supervisoryCompanyCode, boolean isUnit) {
        // 根据设备id查询设备类别、品种
        LambdaQueryWrapper<RegistrationInfo> equipWrapper = new LambdaQueryWrapper<>();
        equipWrapper.eq(RegistrationInfo::getRecord, equipId);
        RegistrationInfo equipRegistrationInfo = tzsJgRegistrationInfoMapper.selectOne(equipWrapper);
        if (!ValidationUtil.isEmpty(equipRegistrationInfo)) {
            String equCategory = equipRegistrationInfo.getEquCategory(); // 设备类别 "3100"
            String equDefine = equipRegistrationInfo.getEquDefine(); // 设备品种 "3110"
            if (!ObjectUtils.isEmpty(equCategory)) {
                // 设备种类简称，如果是气瓶返回瓶
                String equCategoryAbbrName = CylinderTypeEnum.CYLINDER.getCode().equals(equCategory) ?
                        CylinderTypeEnum.CYLINDER.getName() :
                        EquipTypeEnum.getMessage(equCategory.substring(0, 1));
                // 设备代码中间两位
                String equipType2MidDigits = equCategory.substring(1, 3);
                //台套还是取品种的中间两位
                if (!isUnit) {
                    if (!ValidationUtil.isEmpty(equDefine)) {
                        equipType2MidDigits = equDefine.substring(1, 3);
                    }
                }
                // 登记机关代号,特殊区域用特殊区域如韩城-Y、杨凌-V、西咸-U
                String city = "";
                if (!ValidationUtil.isEmpty(supervisoryCompanyCode)) {
                    DataDictionary specialRegionCode = dataDictionaryService.getByCode(supervisoryCompanyCode, SPECIAL_REGION_CODE);
                    if (!ValidationUtil.isEmpty(specialRegionCode)) {  // 特殊的区域
                        city = specialRegionCode.getName();
                    } else {                                           // 普通的地市
                        // 根据接收机构查询对应父级地市code，用于生成登记证号
                        String cityCode = getCityCode(supervisoryCompanyCode);
                        DataDictionary regionCodeDict = equipmentCategoryMapper.getOneDictByTypeAndExtend(EquipmentCategoryEnum.XZQH.getCode(), cityCode);
                        city = regionCodeDict.getCode();
                    }
                }
                return generateUniqueUseRegistrationCode(equCategoryAbbrName, equipType2MidDigits, city);
            }
        }
        return null;
    }

    public String getCityCode(String supervisoryCompanyCode) {
        LinkedHashMap<String, Object> root = getCreatTree().get(0);
        // 根据supervisoryCompanyCode递归匹配regulatorUnitTree，并从中记录级别等于prefecture-level的节点，返回其code
        return findPrefectureLevelInTree(root, supervisoryCompanyCode);
    }

    private String findPrefectureLevelInTree(LinkedHashMap<String, Object> node, String targetCode) {
        // 使用栈实现DFS遍历
        // 节点栈
        Deque<LinkedHashMap<String, Object>> nodeStack = new ArrayDeque<>();
        // 路径栈
        Deque<List<LinkedHashMap<String, Object>>> pathStack = new ArrayDeque<>();

        nodeStack.push(node);
        pathStack.push(new ArrayList<>());

        while (!nodeStack.isEmpty()) {
            LinkedHashMap<String, Object> current = nodeStack.pop();
            List<LinkedHashMap<String, Object>> currentPath = pathStack.pop();

            // 更新当前路径
            List<LinkedHashMap<String, Object>> newPath = new ArrayList<>(currentPath);
            newPath.add(current);

            // 命中目标节点
            if (targetCode.equals(current.get("companyCode"))) {
                return findPrefectureInPath(newPath);
            }

            // 处理子节点
            List<LinkedHashMap<String, Object>> children = (List<LinkedHashMap<String, Object>>) current.get("children");
            if (!CollectionUtils.isEmpty(children)) {
                for (int i = children.size()-1; i >= 0; i--) { // 保持原顺序需逆序压栈
                    nodeStack.push(children.get(i));
                    pathStack.push(new ArrayList<>(newPath));
                }
            }
        }
        return null;
    }

    private String findPrefectureInPath(List<LinkedHashMap<String, Object>> path) {
        // 逆序查找最近的地级节点
        for (int i = path.size()-1; i >= 0; i--) {
            LinkedHashMap<String, Object> node = path.get(i);
            if (CompanyLevelEnum.PREFECTURE_LEVEL.getCode().equals(node.get("level"))) {
                return (String) node.get("companyCode");
            }
        }
        return null;
    }

    /**
     * 生成唯一使用登记编号
     *
     * @param equCategoryAbbrName 设备种类简称
     * @param equipType2MidDigits 设备代码中间两位
     * @param city                登记机关代号
     * @return 唯一使用登记编号
     */
    String generateUniqueUseRegistrationCode(String equCategoryAbbrName, String equipType2MidDigits, String city) {
        String useRegistrationCode;
        JgUseRegistrationManage jgUseRegistrationManage;
        do {
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(equCategoryAbbrName + equipType2MidDigits + "陕" + city);
            useRegistrationCode = stringResponseModel.getResult();
            // 查询是否已有相同登记证号的记录
            jgUseRegistrationManage = jgUseRegistrationManageService.getBaseMapper().selectOne(
                    new LambdaQueryWrapper<JgUseRegistrationManage>()
                            .eq(JgUseRegistrationManage::getUseRegistrationCode, useRegistrationCode)
                            .eq(JgUseRegistrationManage::getIsDelete, 0)
                            .eq(JgUseRegistrationManage::getCertificateStatus, "已登记")
            );
        } while (jgUseRegistrationManage != null);
        return useRegistrationCode;
    }

    /**
     * 检查实际状态是否不等于期望状态
     *
     * @param latestStatus 业务最新状态
     */
    public void checkExpectedStatus(String latestStatus) {
        String expectedStatus = String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode());
        // 检查实际状态是否不等于期望状态
        if (!expectedStatus.equals(latestStatus)) {
            throw new BadRequest("当前业务状态已更新，请返回工作台后重新打开！");
        }
    }

    @Override
    public void checkForExecuteFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 当前流程已经被转办给其他人或者页面按钮问题导致的权限未控制
        String nextExecuteUserIds = instanceRuntimeData.getNextExecuteUserIds();
        if (!nextExecuteUserIds.contains(RequestContext.getExeUserId())) {
            throw new BadRequest("当前登录人无执行权限！");
        }

    }

    private InstanceRuntimeData getInstanceRuntimeData(String instanceId) {
        RBucket<InstanceRuntimeData> rBucket = redissonClient.getBucket(CommonServiceImpl.buildJgInstanceDataKey(instanceId));
        return rBucket.get();
    }

    @Override
    public void saveExecuteFlowData2Redis(String instanceId, InstanceRuntimeData instanceData) {
        redissonClient.getBucket(CommonServiceImpl.buildJgInstanceDataKey(instanceId)).set(instanceData);
    }

    @Override
    public void checkForRevocationFlow(String taskId, String instanceId) {
        InstanceRuntimeData instanceRuntimeData = getInstanceRuntimeData(instanceId);
        if (instanceRuntimeData == null) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        // 前端页面上送任务id与当前任务id不一致时，不让操作，解决老页面没关闭，但是流程已经被被人执行（通过、驳回、撤回），工作流未限制错误
        String currentTaskId = instanceRuntimeData.getNextTaskId();
        if (!taskId.equals(currentTaskId)) {
            throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
        }
        if (!instanceRuntimeData.getPromoter().equals(RequestContext.getExeUserId())) {
            throw new BadRequest("无权限执行该任务");
        }
    }

    @Override
    public void saveOrUpdateHistory(String registrationClass, JSON json, String equipId, String currentDocumentId) {
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        Integer integer = jgRegistrationHistoryService.getBaseMapper().selectCount(lambda);
        if (integer > 0) {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(json));
            jgRegistrationHistoryService.update(jgRegistrationHistory, lambda);
        } else {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(json));
            jgRegistrationHistory.setStatus("new");
            jgRegistrationHistory.setRegistrationClass(registrationClass);
            jgRegistrationHistory.setEquId(equipId);
            jgRegistrationHistory.setCurrentDocumentId(currentDocumentId);
            jgRegistrationHistoryService.save(jgRegistrationHistory);
        }
    }

    @Override
    public JSONObject queryHistoryData(Long currentDocumentId) {
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
        return jgRegistrationHistory != null ? JSONObject.parseObject(jgRegistrationHistory.getChangeData()) : null;
    }

    public JSONObject queryHistoryData(String currentDocumentId) {
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
        return jgRegistrationHistory != null ? JSONObject.parseObject(jgRegistrationHistory.getChangeData()) : null;
    }

    public JSONObject queryHisOldData(String currentDocumentId) {
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
        return jgRegistrationHistory != null ? JSONObject.parseObject(jgRegistrationHistory.getOldData()) : new JSONObject();
    }

    @Override
    public JSONArray queryHistoryDataObj(Long currentDocumentId) {
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
        if (jgRegistrationHistory != null) {
            String changeData = jgRegistrationHistory.getChangeData();
            try {
                // 尝试解析为JSONArray
                return JSON.parseArray(changeData);
            } catch (JSONException e) {
                // 解析失败，尝试将对象转换为JSONArray
                JSONObject jsonObject = JSON.parseObject(changeData);
                JSONArray jsonArray = new JSONArray();
                jsonArray.add(jsonObject);
                return jsonArray;
            }
        }
        return new JSONArray();
    }

    @Override
    public Integer countEquipInUseTimesForEdit(String record) {
        return commonMapper.countEquipInUseTimesForEdit(record);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public Boolean checkEquipIsUsed(String record) {
        Integer useTime = commonMapper.countEquipInUseTimesWithOutZF(record);
        log.info("检查设备是否被使用,设备:{},业务数:{}", record, useTime);
        return useTime > 0;
    }

    /**
     * string转化为jsonObject
     *
     * @param obj        jsonobject/map对象
     * @param jsonFields 要转化的字段数据
     */
    public void convertStringToJsonobject(Object obj, String[] jsonFields) {
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject) obj;
            for (String field : jsonFields) {
                if (jsonObject.get(field) != null && jsonObject.get(field) instanceof String) {
                    jsonObject.put(field, JSON.parse(jsonObject.get(field).toString()));
                }
            }
        } else if (obj instanceof Map) {
            Map<String, Object> map = (Map<String, Object>) obj;
            for (String field : jsonFields) {
                if (map.containsKey(field) && map.get(field) instanceof String) {
                    map.put(field, JSON.parse(map.get(field).toString()));
                }
            }
        } else {
            // 处理其他类型
            System.out.println("Unsupported Object Type");
        }
    }

    /**
     * 设备分类
     *
     * @param type 1，设备种类  2，设备类别  3，设备品种
     *             .c@return
     */
    @Override
    public List<EquipmentCategoryDto> equipmentClassification(String type) {
        List<EquipmentCategoryDto> categoryList = equipmentCategoryMapper.selectClassifyNoStart7();
        List<EquipmentCategoryDto> result = Collections.emptyList();
        switch (type) {
            case "1":
                result = categoryList.stream().filter(category -> Pattern.compile("^[^\\D0]*000$").matcher(category.getCode()).matches()).collect(Collectors.toList());
                break;
            case "2":
                result = categoryList.stream().filter(category -> Pattern.compile("^[^\0]*00$").matcher(category.getCode()).matches()).collect(Collectors.toList());
                break;
            case "3":
                result = categoryList.stream().filter(category -> Pattern.compile("^[^\\D0A-Za-z]*[A-Za-z0-9]*[^0]0$").matcher(category.getCode()).matches()).collect(Collectors.toList());
                break;
        }
        return result;
    }

    @Override
    public List<EquipmentCategoryDto> equipmentPipeType3ByParentCode(String parentCode) {
        List<EquipmentCategoryDto> categoryList = equipmentCategoryMapper.equipmentPipeType3ByParentCode(parentCode);
        return categoryList;
    }

    /**
     * 设备分类
     *
     * @param type 1，设备种类  2，设备类别  3，设备品种
     *             .c@return
     */
    @Override
    public List<EquipmentCategoryDto> equipmentClassificationByParentCode(String type, String parentCode) {
        List<EquipmentCategoryDto> categoryList = equipmentCategoryMapper.selectClassifyNoStart7ByParentCode(parentCode);
        List<EquipmentCategoryDto> result = Collections.emptyList();
        switch (type) {
            case "1":
                result = categoryList.stream().filter(category -> category.getDescription().equals("EQU_LIST")).collect(Collectors.toList());
                break;
            case "2":
                result = categoryList.stream().filter(category -> category.getDescription().equals("EQU_CATEGORY")).collect(Collectors.toList());
                break;
            case "3":
                result = categoryList.stream().filter(category -> category.getDescription().equals("EQU_DEFINE")).collect(Collectors.toList());
                break;
        }
        return result;
    }

    @Override
    public List<EquipmentCategoryDto> equipmentClassificationNoPipeline(String type) {
        List<EquipmentCategoryDto> categoryList = equipmentCategoryMapper.selectClassifyNoStart7And8();
        List<EquipmentCategoryDto> result = Collections.emptyList();
        switch (type) {
            case "1":
                result = categoryList.stream().filter(category -> Pattern.compile("^[^\\D0]*000$").matcher(category.getCode()).matches()).collect(Collectors.toList());
                break;
            case "2":
                result = categoryList.stream().filter(category -> Pattern.compile("^[^\0]*00$").matcher(category.getCode()).matches()).collect(Collectors.toList());
                break;
            case "3":
                result = categoryList.stream().filter(category -> Pattern.compile("^[^\\D0A-Za-z]*[A-Za-z0-9]*[^0]0$").matcher(category.getCode()).matches()).collect(Collectors.toList());
                break;
        }
        return result;
    }

    @Override
    public List<EquipmentCategoryDto> equipmentClassificationNoPipelineByParentCode(String type, String parentCode) {
        List<EquipmentCategoryDto> categoryList = equipmentCategoryMapper.selectClassifyNoStart7And8ByParentCode(parentCode);
        List<EquipmentCategoryDto> result = Collections.emptyList();
        switch (type) {
            case "1":
                result = categoryList.stream().filter(category -> category.getDescription().equals("EQU_LIST")).collect(Collectors.toList());
                break;
            case "2":
                result = categoryList.stream().filter(category -> category.getDescription().equals("EQU_CATEGORY")).collect(Collectors.toList());
                break;
            case "3":
                result = categoryList.stream().filter(category -> category.getDescription().equals("EQU_DEFINE")).collect(Collectors.toList());
                break;
        }
        return result;
    }

    @Override
    public List<EquipmentCategoryDto> getEquDefineByParentId(String parentId) {
        return equipmentCategoryMapper.getEquDefineByParentId(parentId);
    }

    public JSONObject buildFile(String manageType, JSONObject jsonObject) {
        JSONObject formData = new JSONObject();
        formData.putAll(jsonObject);
        //去除值为null的key
        formData.entrySet().removeIf(entry -> entry.getValue() == null);
        // 定义日期格式 若传进来的时间包含时分秒 则进行格式化
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Pattern timePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}");
        //如果是历史无证的修改类型为SP_TT并且枚举没有在登记类型中
        if (Objects.isNull(RegistrationTypeEnum.getNameByType(formData.getString("type"))) && "jg_his_black".equals(formData.getString("dataSource"))) {
            formData.put("type", "SP_TT");
        }

        //登记类型
        if (formData.containsKey("type")) {
            formData.put("registrationType", RegistrationTypeEnum.getNameByType(formData.getString("type")));
        }
        for (String key : formData.keySet()) {
            if (key.contains("Date") && timePattern.matcher(formData.getString(key)).matches()) {
                // 解析原始日期时间字符串
                LocalDateTime dateTime = LocalDateTime.parse(formData.getString(key), inputFormatter);
                // 格式化为仅包含年月日的字符串
                String formattedDate = dateTime.format(outputFormatter);
                formData.put(key, formattedDate);
            }
        }
        //管理员赋值 台套/单位模版
        if (formData.containsKey("safetyManager") && formData.getString("safetyManager").contains("_")) {
            formData.put("safetyManagerName", formData.getString("safetyManager").split("_")[1]);
        }
        //施工单位及检测监管部门赋值 车用气瓶模版
        if (formData.containsKey("installUnitCode") && formData.getString("installUnitCode").contains("_")) {
            formData.put("installUnitName", formData.getString("installUnitCode").split("_")[1]);
        }
        if (formData.containsKey("inspectUnitCreditCode") && formData.getString("inspectUnitCreditCode").contains("_")) {
            formData.put("inspectUnitName", formData.getString("inspectUnitCreditCode").split("_")[1]);
        }
        //管理员赋值 车用气瓶模版
        if (formData.containsKey("safetyManagerId") && formData.getString("safetyManagerId").contains("_")) {
            formData.put("safetyManagerName", formData.getString("safetyManagerId").split("_")[1]);
        }
        formData.put("changeCategory", "达到设计使用年限继续使用");

        //产权单位赋值
        if (formData.containsKey("estateUnitName") && null != formData.getString("estateUnitName") && formData.getString("estateUnitName").contains("_")) {

            LambdaQueryWrapper<TzBaseEnterpriseInfo> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(TzBaseEnterpriseInfo::getUseUnitCode, formData.getString("estateUnitName").split("_")[0]);
            //产权单位联系电话
            TzBaseEnterpriseInfo tzBaseEnterpriseInfo = enterpriseInfoMapper.selectOne(wrapper);
            if (!ValidationUtil.isEmpty(tzBaseEnterpriseInfo)) {
                String contactPhone = tzBaseEnterpriseInfo.getContactPhone();
                if (StringUtils.isNotEmpty(contactPhone)) {
                    formData.put("estatePhone", contactPhone);
                }
            }
            formData.put("CQUnitCode", formData.getString("estateUnitName").split("_")[0]);
            formData.put("estateUnitName", formData.getString("estateUnitName").split("_")[1]);
        }
        if (formData.containsKey("equList")) {
            formData.put("equList", EquipmentClassifityEnum.getNameByCode(formData.getString("equList")));
        }
        //产品名称
        if (formData.containsKey("projectContraption")) {
            formData.put("productName", formData.getString("projectContraption"));
        }
        //单位模版 部分字段需从设备列表中获取
        if (formData.containsKey("equipmentLists")) {
            JSONArray equipmentLists = formData.getJSONArray("equipmentLists");
            List<Map<String, Object>> equips = equipmentLists.stream()
                    .filter(obj -> obj instanceof Map)
                    .map(obj -> (Map<String, Object>) obj).collect(Collectors.toList());
            if (manageType.equals(UNIT) && !CollectionUtils.isEmpty(equips)) {
                //管道计算的是管道长度
                if ("8000".equals(formData.getString("equListCode")) || "8000".equals(formData.getString("EQU_LIST_CODE"))) {
                    formData.put("equNum", calTotalLength(equips) + "(m)");
                } else {
                    //设备数量
                    formData.put("equNum", equipmentLists.size());
                }

                //设备品种
                formData.put("equDefine", equips.get(0).get("equDefineName"));

                Set<String> productNameSet = equips.stream()
                        .filter(Objects::nonNull) // 过滤掉equip为null的情况
                        .map(e -> e.get("productName")) // 获取productName
                        .filter(Objects::nonNull) // 过滤掉productName为null的情况
                        .map(Object::toString) // 转换为String类型
                        .collect(Collectors.toSet()); // 收集到Set中

                // 将set转成字符串逗号拼接
                String productName = "";
                List<String> sortedProductNameList = new
                        ArrayList<>(productNameSet);
                if (sortedProductNameList.size() > 3
                ) {
                    productName = String.join(",", sortedProductNameList.subList(0, 3)) + ",...";
                } else {
                    productName = String.join(",", sortedProductNameList);
                }
                formData.put("productName", productName);
            } else if (manageType.equals(VEHICLE) && !CollectionUtils.isEmpty(equips)) {
                //气瓶数量
                formData.put("gasNum", equips.size());
                //设备品种
                formData.put("equDefineName", equips.get(0).get("equDefineName"));
                // 气瓶压力及容积求和  BUG 27524 【现场需求】监管业务-登记管理-使用登记，气瓶特种设备使用登记表气瓶公称压力取最大值
                // equips.stream().mapToDouble(e -> Optional.ofNullable(e.get("nominalWorkingPressure")).map(v -> Double.valueOf(v.toString())).orElse(0.0)).sum()
                formData.put("workPressure", equips.stream().mapToDouble(e -> Optional.ofNullable(e.get("nominalWorkingPressure")).map(v -> Double.valueOf(v.toString())).orElse(0.0)).max().getAsDouble());
                formData.put("volume", equips.stream().mapToDouble(e -> Optional.ofNullable(e.get("singleBottleVolume")).map(v -> Double.valueOf(v.toString())).orElse(0.0)).sum());
                // BUG 30344 【生产问题】车用气瓶使用登记时，同一车辆可以选择多个充装介质不同的气瓶发起使用登记
                Set<String> chargingMedium = equips.stream().map(e -> String.valueOf(e.get("chargingMedium"))).collect(Collectors.toSet());
                formData.put("chargingMedium", String.join(",", chargingMedium));
                // if (chargingMedium.size() > 1) {
                //     throw new BadRequest("充装介质仅可选择同一类型");
                // } else {
                //     formData.put("chargingMedium", equips.get(0).get("chargingMedium"));
                // }
            }

        }

        //设备类型 台套模版
        if (formData.containsKey("equDefine") && !manageType.equals(UNIT)) {
            EquipmentCategory define = equipmentCategoryMapper.selectOne(new LambdaQueryWrapper<EquipmentCategory>()
                    .eq(EquipmentCategory::getCode, formData.getString("equDefine")));
            formData.put("equDefine", define != null ? define.getName() : null);
        }
        //设备类型 台套模版
        if (formData.containsKey("equCategory")) {
            EquipmentCategory category = equipmentCategoryMapper.selectOne(new LambdaQueryWrapper<EquipmentCategory>()
                    .eq(EquipmentCategory::getCode, formData.getString("equCategory")));
            formData.put("equCategory", category != null ? category.getName() : null);
        }
        //设备类型 车用气瓶模版 单位模版
        if (formData.containsKey("EQU_CATEGORY_CODE")) {
            EquipmentCategory category = equipmentCategoryMapper.selectOne(new LambdaQueryWrapper<EquipmentCategory>()
                    .eq(EquipmentCategory::getCode, formData.getString("EQU_CATEGORY_CODE")));
            formData.put("equCategory", category != null ? category.getName() : null);
        }
        //检验类型  台套模版
        if (formData.containsKey("inspectType")) {
            formData.put("inspectType", JYJCBusinessTypeEnum.getNameByCode(formData.getString("inspectType")).getName());
        }
        //检验结论  台套模版
        if (formData.containsKey("inspectConclusion")) {
            formData.put("inspectConclusion", JYJCResultEnum.getNameByCode(formData.getString("inspectConclusion")).getName());
        }
        if (formData.containsKey("equipId")) {
            //施工单位名称
            LambdaQueryWrapper<ConstructionInfo> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(AbstractEquipBaseEntity::getRecord, formData.getString("equipId"));
            wrapper.orderByDesc(AbstractEquipBaseEntity::getRecDate);
            wrapper.last("limit 1");
            ConstructionInfo constructionInfo = constructionInfoMapper.selectOne(wrapper);
            if (Objects.nonNull(constructionInfo) && StringUtils.isNotEmpty(constructionInfo.getUscUnitName())) {
                formData.put("uscUnitName", constructionInfo.getUscUnitName());
            }
        }
        if (formData.containsKey("useUnitCreditCode")) {

            LambdaQueryWrapper<TzBaseEnterpriseInfo> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(TzBaseEnterpriseInfo::getUseUnitCode, formData.getString("useUnitCreditCode").split("_")[0]);
            TzBaseEnterpriseInfo tzBaseEnterpriseInfo = enterpriseInfoMapper.selectOne(wrapper);
            //使用单位地址
            if (Objects.nonNull(tzBaseEnterpriseInfo) && StringUtils.isNotEmpty(tzBaseEnterpriseInfo.getAddress())) {
                formData.put("useUnitAddress", tzBaseEnterpriseInfo.getAddress());
            }
        }
        //右下角日期
        formData.put("cruDate", DateUtils.convertDateToString(new Date(), DateUtils.CHN_DATE_PATTERN));
        return formData;
    }

    public static String calTotalLength(List<Map<String, Object>> equList) {
        double pipeLengthSum = equList.stream().map(r -> r.get("pipeLength")).filter(Objects::nonNull).mapToDouble(l -> Double.parseDouble(String.valueOf(l))).sum();
        BigDecimal pipeLengthSumBig = new BigDecimal(String.valueOf(pipeLengthSum)).setScale(3, RoundingMode.HALF_UP);
        return pipeLengthSumBig.toPlainString();
    }

    public List<JSONObject> buildFileForOverDesign(JSONObject jsonObject) {
        List<JSONObject> formDataList = new ArrayList<>();
        if (jsonObject.containsKey("equipmentLists")) {
            JSONArray equipmentLists = jsonObject.getJSONArray("equipmentLists");
            List<Map<String, Object>> equips = equipmentLists.stream()
                    .filter(obj -> obj instanceof Map)
                    .map(obj -> (Map<String, Object>) obj)
                    .collect(Collectors.toList());

            if (equips.stream().anyMatch(info -> info.get("safetyAssessmentReport") == null || "".equals(info.get("safetyAssessmentReport")))) {
                throw new BadRequest("请补充设备安全评估报告信息后提交！");
            }
            if ("2000".equals(Objects.toString(jsonObject.get("equListCode")))) {
                if (equips.stream().anyMatch(info -> !"WTJY".equals(info.get("inspectType")))){
                    throw new BadRequest("压力容器需要先做委托检验后提交！");
                }
            }
            if (equips.stream()
                    .map(info -> (String) info.get("nextInspectDate"))
                    .filter(Objects::nonNull)
                    .anyMatch(dateStr -> {
                        try {
                            return LocalDate.parse(dateStr, DateTimeFormatter.ISO_DATE).isBefore(LocalDate.now());
                        } catch (Exception e) {
                            return false;
                        }
                    })) {
                throw new BadRequest("委托检验下次检验日期超期，请重新填写后提交！");
            }
            if (!CollectionUtils.isEmpty(equips)) {
                Map<String, Object> firstEquip = equips.get(0);
                String equList = Objects.toString(firstEquip.get("equList"),"");
                String equDefine = Objects.toString(firstEquip.get("equDefine"),"--");
                String equCategory = Objects.toString(firstEquip.get("equCategory"),"");
                formDataList = equips.stream().map(v -> {
                    JSONObject formData = new JSONObject();
                    formData.putAll(jsonObject);
                    formData.put("equDefine", equDefine);
                    formData.put("equCategory", equCategory);
                    formData.put("equList", equList);
                    formData.entrySet().removeIf(entry -> entry.getValue() == null);
                    DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    Optional.ofNullable(Objects.toString(jsonObject.get("type"), ""))
                            .ifPresent(type -> formData.put("registrationType", RegistrationTypeEnum.getNameByType(type)));
                    Optional.ofNullable(Objects.toString(jsonObject.get("equListCode"), ""))
                            .ifPresent(code -> formData.put("equList", EquipmentClassifityEnum.getNameByCode(code)));
                    String useRegistrationCode = Objects.toString(v.get("useOrgCode"), "");
                    JgUseRegistrationManage manage = jgUseRegistrationManageService.lambdaQuery()
                            .eq(JgUseRegistrationManage::getUseRegistrationCode, useRegistrationCode)
                            .eq(JgUseRegistrationManage::getIsDelete, 0)
                            .eq(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIDENGJI.getName())
                            .one();
                    formData.put("equCode", v.get("equCode"));
                    formData.put("useRegistrationCode", v.get("useOrgCode"));
                    formData.put("produceUnitName", v.get("produceUnitName"));
                    Optional.ofNullable(v.get("produceDate"))
                            .map(Object::toString)
                            .map(String::trim)
                            .filter(s -> !s.isEmpty())
                            .map(s -> LocalDateTime.parse(s, inputFormatter).format(outputFormatter))
                            .ifPresent(s -> formData.put("produceDate", s));
                    formData.put("factoryNum", v.get("factoryNum"));
                    formData.put("productName", v.get("productName"));
                    formData.put("useUnitName", v.get("useUnitName"));
                    if (manage != null && manage.getAuditPassDate() != null) {
                        formData.put("auditPassDate", new SimpleDateFormat("yyyy-MM-dd").format(manage.getAuditPassDate()));
                    }
                    formData.put("receiveCompanyOrgName", manage != null ? manage.getReceiveOrgName() : null);
                    formData.put("applyNo", jsonObject.get("applyNo"));
                    formData.put("cruDate", DateUtils.convertDateToString(new Date(), DateUtils.CHN_DATE_PATTERN));
                    return formData;
                }).collect(Collectors.toList());
            }
        }
        return formDataList;
    }

    @Override
    public Map<String, Object> getRegistrationFormUrl(String manageType, JSONObject jsonObject) {
        JSONObject formData = buildFile(manageType, jsonObject);
        String wordPath;
        String fileName;
        if (UNIT.equals(manageType)) {
            wordPath = "use-registration-form-unit.ftl";
            fileName = "台套使用登记表_";
        } else if (SET.equals(manageType)) {
            wordPath = "use-registration-form-set.ftl";
            fileName = "单位使用登记表_";
        } else if (OVER_DESIGN.equals(manageType)) {
            wordPath = "use-registration-change-certificate.ftl";
            fileName = "特种设备使用登记变更证明_";
        } else {
            wordPath = "use-registration-form-vehicle.ftl";
            fileName = "车用气瓶使用登记表_";
            formData.put("equipBasicInfoList", formData.containsKey("equipmentLists") ? formData.get("equipmentLists") : new JSONArray());
        }
        // word转pdf
        File pdfFile = null;
        try {
            pdfFile = wordToPdf(fileName, wordPath, formData);
            return MapBuilder.<String, Object>create().put("useRegistrationFormUrl", uploadFile(pdfFile, "useRegistrationFormFiles")).build();
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            try {
                Files.deleteIfExists(pdfFile.toPath());
            } catch (Exception e) {
                log.error("文件找不到，删除失败：{}", e);
            }
        }
    }

    @Override
    public void getRegistrationFormStream(JSONObject formData, String manageType, HttpServletResponse response) {
        formData.putAll(buildFile(manageType, formData));
        String wordPath;
        String fileName;
        if (UNIT.equals(manageType)) {
            wordPath = "use-registration-form-unit.ftl";
            fileName = "台套使用登记表_";
        } else if (SET.equals(manageType)) {
            wordPath = "use-registration-form-set.ftl";
            fileName = "单位使用登记表_";
        } else {
            wordPath = "use-registration-form-vehicle.ftl";
            fileName = "车用气瓶使用登记表_";
            formData.put("equipBasicInfoList", formData.get("equipmentLists"));
        }
        // word转pdf
        File pdfFile;
        try {
            pdfFile = wordToPdf(fileName, wordPath, formData);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            byte[] bytes = CommonServiceImpl.file2byte(pdfFile);
            String docTitle = pdfFile.getName();
            FileExporter.exportFile(FileExporter.FileType.valueOf("pdf"), docTitle, bytes, response);
        } catch (Exception e) {
            log.error("pdf文件转换失败：{}", e);
        } finally {
            try {
                Files.deleteIfExists(pdfFile.toPath());
            } catch (Exception e) {
                log.error("文件找不到，删除失败：{}", e);
            }
        }
    }

    @Override
    public Map<String, Object> getRegistrationChangeCertificateUrl(JSONObject jsonObject) {
        String applyNo = jsonObject.getString("applyNo");
        if (StringUtils.isEmpty(applyNo)) {
            ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.CSJ.getCode(), 1);
            if (!ObjectUtils.isEmpty(listResponseModel) && listResponseModel.getStatus() != HttpStatus.OK.value()) {
                throw new BadRequest("超设计使用年限变更申请单单号获取失败！");
            }
            applyNo = listResponseModel.getResult().get(0);
        }
        jsonObject.put("applyNo", applyNo);
        List<JSONObject> formDataList = buildFileForOverDesign(jsonObject);
        Map<String, Object> result = new HashMap<>();

        String wordPath = "use-registration-change-certificate.ftl";
        String fileName = "特种设备使用登记变更证明_";
        List<File> generatedFiles = new ArrayList<>();
        File mergedPdfFile = null;

        try {
            List<File> pdfFiles = formDataList.stream()
                    .map(formData -> {
                        try {
                            File pdfFile = wordToPdf(fileName, wordPath, formData);
                            if (pdfFile != null && pdfFile.exists()) generatedFiles.add(pdfFile);
                            return pdfFile;
                        } catch (Exception e) {
                            log.error("PDF 生成失败", e);
                            return null;
                        }
                    })
                    .filter(Objects::nonNull)
                    .collect(Collectors.toList());
            if (!pdfFiles.isEmpty()) {
                mergedPdfFile = mergePdfFiles(pdfFiles, fileName + "合并.pdf");
                if (mergedPdfFile.exists()) generatedFiles.add(mergedPdfFile);
            }
            String uploadedUrl = uploadFile(mergedPdfFile, "useRegistrationFormFiles");
            result.put("useRegistrationFormUrl", uploadedUrl);
            result.put("applyNo", applyNo);
            return result;
        } catch (Exception e) {
            log.error("生成或上传文件失败", e);
            throw new RuntimeException("文件处理失败", e);
        } finally {
            System.gc();
            try {
                Thread.sleep(100);
            } catch (InterruptedException ignored) {}
            generatedFiles.forEach(this::deleteFileSafely);
        }
    }

    @Override
    public void getRegistrationChangeCertificateFormStream(JSONObject jsonObject, HttpServletResponse response) {
        List<JSONObject> formDataList = buildFileForOverDesign(jsonObject);
        String wordPath = "use-registration-change-certificate.ftl";
        String filePrefix = "特种设备使用登记变更证明_";

        List<File> pdfFiles = new ArrayList<>();

        try {
            for (int i = 0; i < formDataList.size(); i++) {
                String fileName = filePrefix + (i + 1);
                File pdfFile = wordToPdf(fileName, wordPath, formDataList.get(i).getInnerMap());
                pdfFiles.add(pdfFile);
            }

            if (pdfFiles.size() == 1) {
                exportSinglePdf(pdfFiles.get(0), response);
            } else {
                File mergedPdf = mergePdfs(filePrefix + "合并.pdf", pdfFiles);
                exportSinglePdf(mergedPdf, response);
                pdfFiles.add(mergedPdf);
            }
        } catch (Exception e) {
            log.error("PDF 生成或导出失败：{}", e);
            throw new RuntimeException("PDF 生成失败", e);
        } finally {
            // 确保删除所有临时文件
            pdfFiles.forEach(file -> {
                try {
                    Files.deleteIfExists(file.toPath());
                } catch (Exception e) {
                    log.error("文件删除失败：{}", e);
                }
            });
        }
    }

    /**
     * 导出单个 PDF
     */
    private void exportSinglePdf(File pdfFile, HttpServletResponse response) throws IOException {
        byte[] bytes = CommonServiceImpl.file2byte(pdfFile);
        FileExporter.exportFile(FileExporter.FileType.pdf, pdfFile.getName(), bytes, response);
    }

    /**
     * 合并多个 PDF
     */
    private File mergePdfs(String outputFileName, List<File> pdfFiles) throws Exception {
        PDDocument mergedDoc = new PDDocument();
        for (File pdfFile : pdfFiles) {
            try (PDDocument doc = PDDocument.load(pdfFile)) {
                doc.getPages().forEach(mergedDoc::addPage);
            }
        }
        File mergedPdf = new File(outputFileName);
        mergedDoc.save(mergedPdf);
        mergedDoc.close();
        return mergedPdf;
    }

    /**
     * 安全删除文件方法
     */
    private void deleteFileSafely(File file) {
        if (file != null && file.exists()) {
            try {
                Files.deleteIfExists(file.toPath());
            } catch (IOException e) {
                log.error("删除文件失败: {}", file.getAbsolutePath(), e);
            }
        }
    }

    private File mergePdfFiles(List<File> pdfFiles, String outputFileName) throws IOException {
        PDFMergerUtility merger = new PDFMergerUtility();
        File outputFile = new File(System.getProperty("java.io.tmpdir"), outputFileName);
        merger.setDestinationFileName(outputFile.getAbsolutePath());
        for (File pdf : pdfFiles) {
            merger.addSource(pdf);
        }
        merger.mergeDocuments(null);
        return outputFile;
    }

    @Override
    public List<EquipmentClassifyDto> getEquClassifyByCode(String parentCode) {
        List<EquipmentClassifyDto> equipmentCategoryDtos = commonMapper.getEquClassifyByCode(parentCode);
        if (ValidationUtil.isEmpty(equipmentCategoryDtos)) {
            return new ArrayList<>();
        }

        Map<String, EquipmentClassifyDto> idToDtoMap = equipmentCategoryDtos.stream()
                .collect(Collectors.toMap(EquipmentClassifyDto::getCode, dto -> dto));

        List<EquipmentClassifyDto> rootNodes = equipmentCategoryDtos.stream()
                .filter(dto -> dto.getParentId().equals("0"))
                .collect(Collectors.toList());

        equipmentCategoryDtos.forEach(dto -> {
            String parentId = dto.getParentId();
            if (!ValidationUtil.isEmpty(parentId)) {
                EquipmentClassifyDto parent = idToDtoMap.get(parentId);
                if (parent != null) {
                    if (parent.getChildren() == null) {
                        parent.setChildren(new ArrayList<>());
                    }
                    parent.getChildren().add(dto);
                }
            }
        });

        if (!ValidationUtil.isEmpty(parentCode)) {
            return rootNodes.stream()
                    .flatMap(root -> root.getChildren().stream())
                    .collect(Collectors.toList());
        }
        return rootNodes;
    }


    /**
     * 排序  ：页面列表排序功能支持，将 "字段,ascend" 或 "字段,descend" 转化为对应JSONObject
     *
     * @param sort "字段,ascend" 或 "字段,descend"
     * @return JSONObject
     */
    public SortVo sortFieldConversion(String sort) {
        Optional<String> optionalSort = Optional.ofNullable(sort);
        Optional<SortVo> optionalSortMap = optionalSort.filter(s -> !s.isEmpty())
                .map(s -> {
                    String[] sortParts = s.split(",");
                    if (sortParts.length == 2) {
                        String field = sortParts[0];
                        String sortSituation = sortParts[1].contains("asc") ? "ASC" : "DESC";
                        return SortVo.builder()
                                .field(convertToUnderline(field))
                                .sortType(sortSituation)
                                .build();
                    }
                    return null;
                });
        return optionalSortMap.orElse(null);
    }

    /**
     * 排序字段不转下滑线 排序  ：页面列表排序功能支持，将 "字段,ascend" 或 "字段,descend" 转化为对应JSONObject
     *
     * @param sort "字段,ascend" 或 "字段,descend"
     * @return JSONObject
     */
    public SortVo sortFieldConversionNoToUnderline(String sort) {
        Optional<String> optionalSort = Optional.ofNullable(sort);
        Optional<SortVo> optionalSortMap = optionalSort.filter(s -> !s.isEmpty())
                .map(s -> {
                    String[] sortParts = s.split(",");
                    if (sortParts.length == 2) {
                        String field = sortParts[0];
                        String sortSituation = sortParts[1].contains("asc") ? "ASC" : "DESC";
                        return SortVo.builder()
                                .field(field)
                                .sortType(sortSituation)
                                .build();
                    }
                    return null;
                });
        return optionalSortMap.orElse(null);
    }

    @Override
    public void fightUseFlagGenerate(UseFlagParamDto useFlagParamDto, HttpServletResponse response) {
        Objects.requireNonNull(useFlagParamDto, "参数不能为空");
        String printFileName = "套打使用登记标志.pdf";

        Map<String, Object> paramMap = Bean.BeantoMap(useFlagParamDto);

        setNextDate(useFlagParamDto, paramMap);
        setRegName(useFlagParamDto, paramMap);
        // 生成二维码,之前为设备监管码，调整为证编号
        String qrCode = ImageUtils.generateQRCode(getEncodeQrCode(useFlagParamDto.getCertificateNo(), "useFlag", useFlagParamDto.getVersion() + ""), 100, 100);
        paramMap.put("supervisoryCode", qrCode);
        this.fillParamValueToPdf(paramMap, response, selectPdfTemplate(useFlagParamDto.getEquListCode()), printFileName, 9.0f);
    }

    @Override
    public List<String> refreshTheDetailsDataOfCompletedUsageRegistration(String since) {
        return commonMapper.refreshTheDetailsDataOfCompletedUsageRegistration(since);
    }

    @Override
    public CompanyBo getOneCompany(String companyCode) {
        CompanyBo companyBo = commonMapper.queryCompanyInfoByCode(companyCode);
        return companyBo == null ? new CompanyBo() : companyBo;
    }

    @Override
    public Integer checkFactoryNumUniquenessForVehicleCylinder(String factoryNum, String sequenceNbr) {
        return commonMapper.checkFactoryNumUniquenessForVehicleCylinder(factoryNum, sequenceNbr);
    }

    /**
     * 根据设备列表代码选择对应的 PDF 模板
     *
     * @param equListCode 设备代码
     * @return model
     */
    private String selectPdfTemplate(String equListCode) {
        switch (equListCode) {
            case "3000":
                return "templates/use-flag-model-elevator.pdf";
            case "0000":
                return "templates/use-flag-model-vehicle.pdf";
            default:
                return "templates/use-flag-model-other.pdf";
        }
    }

    @Override
    public void updateUnitTypeCache(ReginParams reginParams, String unitType, String selectedRoleSeqs) {
        reginParams.getCompany().setCompanyType(unitType);
        redisUtils.set(RedisKey.buildReginRoleKey(RequestContext.getExeUserId()), unitType);
        redisUtils.set(getSelectedRoleRedisKey(), selectedRoleSeqs, redisRegionTimeSecond);
        redisUtils.set(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken()), JSONObject.toJSONString(reginParams), redisRegionTimeSecond);
    }

    @Override
    public void historicalDataProcessingOfPressurePipeline() {

        LambdaQueryWrapper<JgUseRegistration> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JgUseRegistration::getManageType, "unit");
        queryWrapper.eq(JgUseRegistration::getIsDelete, 0);
        List<JgUseRegistration> jgUseRegistrations = jgUseRegistrationServiceImpl.getBaseMapper().selectList(queryWrapper);

        // 对应的历史表
        jgUseRegistrations.forEach(x -> {
            LambdaQueryWrapper<JgRegistrationHistory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(JgRegistrationHistory::getCurrentDocumentId, x.getSequenceNbr());
            wrapper.eq(JgRegistrationHistory::getIsDelete, false);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(wrapper);
            try {
                if (jgRegistrationHistory.getChangeData().contains("8300")) {
                    JSONObject mapData = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
                    if (!ValidationUtil.isEmpty(mapData.get("equipmentLists"))) {
                        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) mapData.get("equipmentLists");
                        // 遍历 equipmentLists，将 pipeLength 从毫米转换为米
                        equipmentLists.forEach(equ -> {
                            String record = (String) equ.get("record");
                            EquipTechParamPipeline equipTechParamPipeline = equipTechParamPipelineMapper.queryTechParamInUse(record);
                            BigDecimal pipeLengthInM = Optional.ofNullable(equipTechParamPipeline)
                                    .map(EquipTechParamPipeline::getPipeLength)
                                    .orElse(new BigDecimal("0"));
                            equ.put("pipeLength", pipeLengthInM);
                        });
                    }
                    jgRegistrationHistory.setChangeData(JSONObject.toJSONString(mapData));
                    jgRegistrationHistoryService.getBaseMapper().updateById(jgRegistrationHistory);
                }
            } catch (Exception e) {
                log.error("更新压力管道出现错误：{}", e.getMessage());
                e.printStackTrace();
            }
        });
    }

    /**
     * 生成使用登记证书唯一标识
     *
     * @param equType            包含有 设备种类 & 设备类别 & 设备品种 的map
     * @param date               生成证日期 （不传取当前时间）
     * @param receiveCompanyCode 接收机构统一信用代码
     * @return 使用登记证书唯一标识
     */
    public String generateCertificateNo(Map<String, String> equType, Date date, String receiveCompanyCode) {
        String ym = "";
        try {
            ym = Optional.of(DateUtils.dateFormat(date, DateUtils.DATE_PATTERN_MM)).orElse(DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN_MM));
        } catch (ParseException e) {
            log.error("日期转换失败：", e);
        }
        ResponseModel<String> responseModel = null;
        if (StringUtils.isNotBlank(receiveCompanyCode) && isValidCreditCode(receiveCompanyCode)) {
            String equCode = Optional.ofNullable(equType.get("equDefineCode")).orElse(equType.get("equCategoryCode"));
            String registrationCode = equCode + receiveCompanyCode + ym;
            responseModel = tzsServiceFeignClient.deviceRegistrationCode(registrationCode);
        }
        return Optional.ofNullable(responseModel).map(ResponseModel::getResult).orElse("");
    }

    // 校验信用代码是否符合要求
    public static boolean isValidCreditCode(String creditCode) {
        // 检查是否是数字
        if (!creditCode.matches("\\d+")) {
            throw new BadRequest("接收机构编码错误: " + creditCode + "，请联系管理员！");
        }
        return true;
    }

    /**
     * 获取最新的使用登记证书
     *
     * @param useUnitCreditCode 使用单位统一信用代码
     * @param equDefineCode     设备类别编码
     * @return JgUseRegistrationManage
     */
    @Override
    public JgUseRegistrationManage getLatestJgUseRegistrationManage(String useUnitCreditCode, String equDefineCode) {
//        LambdaQueryWrapper<JgUseRegistrationManage> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(JgUseRegistrationManage::getUseUnitCreditCode, useUnitCreditCode)
//                .eq(JgUseRegistrationManage::getEquDefineCode, equDefineCode)
//                .eq(JgUseRegistrationManage::getIsDelete, 0)
//                .eq(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIDENGJI.getName())
//                .orderByDesc(JgUseRegistrationManage::getCertificateNo);
//        return jgUseRegistrationManageMapper.selectList(queryWrapper).stream()
//                .findFirst()
//                .orElse(null);
        return jgUseRegistrationManageMapper.getLatestJgUseRegistrationManage(useUnitCreditCode, equDefineCode);
    }

    /**
     * 根据设备代码检查唯一性
     *
     * @param equCode 设备代码
     * @return
     */
    @Override
    public Boolean checkEquCodeUniqueness(String equCode) {
        Integer count = commonMapper.checkEquCodeUniqueness(equCode);
        return count > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 检查record的唯一性
     *
     * @param record record
     * @return
     */
    @Override
    public Boolean checkRecordUniqueness(String record) {
        Integer count = commonMapper.checkRecordUniqueness(record);
        return count > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    /**
     * 使用登记证编号的全库唯一校验
     *
     * @param useRegistrationCode 登记证编号
     * @return true ： 已经存在      false ：不存在
     */
    public Boolean useRegistrationCertificateAccountUnique(String useRegistrationCode, String equipId) {
        Integer count = commonMapper.useRegistrationCertificateAccountUnique(useRegistrationCode, equipId);
        return count > 0;
    }

    /**
     * 判断使用登记证编号是否被其他单位使用
     *
     * @param useRegistrationCode 使用登记证编号
     * @return
     */
    public String isRegistrationNumberUsedByOtherUnits(String useRegistrationCode) {
        String companyCode = getSelectedOrgInfo().getCompany().getCompanyCode();
        String companyType = getSelectedOrgInfo().getCompany().getCompanyType();
        if ("个人主体".equals(companyType)) {
            companyCode = companyCode.split("_")[1];
        }
        return commonMapper.isRegistrationNumberUsedByOtherUnits(useRegistrationCode, companyCode);
    }

    /**
     *  判断使用登记证编号是否被其他单位使用
     * @param useRegistrationCode 使用登记证编号
     * @param companyCode 使用登记证所在单位编码
     * @return 使用的单位
     */
    public List<String> isRegistrationNumberUsedByOtherUnits(String useRegistrationCode, String companyCode) {
        String companyCodeReal = companyCode.contains("_") ? companyCode.split("_")[1] : companyCode;
        return commonMapper.isRegistrationNumberUsedByOtherUnits2(useRegistrationCode, companyCodeReal);
    }

    /**
     * 根据单位ID查询单位的信用代码及名称-反射使用
     * @param unitSeq 单位seq
     * @return 单位信用代码_单位名称
     */
    public String queryUnitCreditInfoBySeq(String unitSeq) {
        return commonMapper.queryUnitCreditInfoBySeq(unitSeq);
    }

    /**
     * 根据单位信息查询单位seq-反射使用
     * @param unitInfo 单位信息
     * @return 单位seq
     */
    public String queryUnitInfoByCreditCode(String unitInfo) {
        if (StringUtils.isBlank(unitInfo)) {
            return unitInfo;
        }
        String unitCreditCode = unitInfo.split("_")[0];
        return commonMapper.queryUnitInfoByCreditCode(unitCreditCode);
    }

    /**
     * 根据单位ID查询单位的信用代码及名称-反射使用
     * @param unitSeq 单位seq
     * @return 单位信用代码_单位名称
     */
    public String queryTcmUnitCreditCodeAndNameBySeq(String unitSeq, String unitType) {
        Map<String, String> map = commonMapper.queryTcmUnitInfoBySeq(unitSeq, unitType);
        return MapUtil.getStr(map, "unitCodeAndName");
    }

    /**
     * 根据单位ID查询单位的信用代码--反射使用勿调整
     * @param unitSeq 单位seq
     * @return 单位信用代码_单位名称
     */
    public String queryTcmUnitCreditCodeBySeq(String unitSeq, String unitType) {
        Map<String, String> map = commonMapper.queryTcmUnitInfoBySeq(unitSeq, unitType);
        return MapUtil.getStr(map, "unitCode");
    }

    /**
     * 根据单位信息查询单位seq-反射使用
     * @param unitCode 单位信息
     * @return 单位seq
     */
    public String queryTcmUnitSeqByCreditCode(String unitCode, String unitType) {
        if (StringUtils.isBlank(unitCode)) {
            return unitCode;
        }
        String unitCreditCode = unitCode.split("_")[0];
        return commonMapper.queryTcmUnitSeqByCreditCode(unitCreditCode, unitType);
    }

    public static String getCompanyType(CompanyBo companyBo){
        if (companyBo.getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
           return BaseController.COMPANY_TYPE_COMPANY;
        } else {
            return BaseController.COMPANY_TYPE_SUPERVISION;
        }
    }

    /**
     * 数据质量等级枚举转名称描述
     * @param dataQualityScore 等级枚举
     * @param isIntoManagement 是否纳管
     * @return 名称描述
     */
    public String castDataQualityScore2Name(String dataQualityScore, Boolean isIntoManagement){
        String name = dataDictTypeHandler.handle(DATA_QUALITY_SCORE, dataQualityScore);
        return name == null ? "三类" : name;
    }

    public void setDataQualityScore2Json(Map<String, Object> result, String bizId, BusinessTypeEnum businessTypeEnum) {
        result.put("dataQualityScore", String.valueOf(remindServiceImpl.getReminderLevel(bizId, businessTypeEnum.name())));
    }

    public static String genRegTypeByDataSource(String dataSource) {
        if (dataSource.contains("jg_his_black")) {
            return "2";
        } else if (dataSource.contains("jg_his")) {
            return "1";
        } else {
            return "0";
        }
    }

    /**
     * 查询非指定单据的设备或者装置的履历信息
     * @param recordOrPIds 设备或者装置id集合
     * @return 指定单据的设备或者装置的履历信息数组
     */
    public List<JgResumeInfoDto> getResumeInfosBatch(List<String> recordOrPIds, String applyNo){
        return jgResumeInfoService.getBaseMapper().selectResumeInfoByEquips(recordOrPIds, applyNo);
    }

    @Override
    public List<Map<String, Object>> cylinderComplianceCheck(List<String> sequenceCodes) {
        if (ValidationUtil.isEmpty(sequenceCodes)) {
            return Lists.newArrayList();
        }
        List<Map<String, Object>> result = Lists.newArrayList();
        try {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must(QueryBuilders.termQuery("IS_INTO_MANAGEMENT", true));
            for (String sequenceCode : sequenceCodes) {
                String[] keys = sequenceCode.split("-", 2);
                BoolQueryBuilder combinationQuery = QueryBuilders.boolQuery()
                        .filter(QueryBuilders.termQuery("produceUnitCreditCode", keys[0]))
                        .filter(QueryBuilders.termQuery("FACTORY_NUM", keys[1]));

                boolQuery.should(combinationQuery);
            }
            boolQuery.minimumShouldMatch(1);
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder()
                    .query(boolQuery)
                    .size(1000);
            SearchRequest searchRequest = new SearchRequest(IDX_BIZ_EQUIPMENT_INFO)
                    .source(sourceBuilder);
            SearchResponse response = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            Set<String> useRegistrationList = Sets.newHashSet();

            for (SearchHit hit : response.getHits().getHits()) {
                Map<String, Object> src = hit.getSourceAsMap();
                Map<String, Object> map = Maps.newHashMap();
                String nextInspectDate = Objects.toString(src.get("NEXT_INSPECT_DATE"), ""); // 下次检验日期
                String isIntoManagement = Objects.toString(src.get("IS_INTO_MANAGEMENT"), ""); // 是否已纳管
                String useRegistrationCode = Objects.toString(src.get("USE_ORG_CODE"), ""); // 使用登记证号
                map.put("sequenceCode", Objects.toString(src.get("produceUnitCreditCode") + "-" + src.get("FACTORY_NUM"), ""));
                map.put("useRegistrationCode", useRegistrationCode);
                map.put("useUnitName", Objects.toString(src.get("USE_UNIT_NAME"), ""));
                map.put("useUnitCreditCode", Objects.toString(src.get("USE_UNIT_CREDIT_CODE"), ""));
                map.put("carNumber", Objects.toString(src.get("carNumber"), ""));
                map.put("nextInspectDate", nextInspectDate);
                map.put("isIntoManagement", isIntoManagement);
                result.add(map);
                useRegistrationList.add(useRegistrationCode);
            }
            // 判断气瓶合规校验结果
            sequenceCodes.forEach(sequenceCode -> {
                List<Map<String, Object>> useRegistrationCylinders = result.stream().filter(m -> m.get("sequenceCode").equals(sequenceCode)).collect(Collectors.toList());
                if (useRegistrationCylinders.size() > 1) {
                    throw new BadRequest("气瓶序列号：【" + sequenceCode + "】有重复数据，请联系平台处理");
                }
                Map<String, Object> targetCylinder = useRegistrationCylinders.stream().findFirst().orElse(null);
                if (ValidationUtil.isEmpty(targetCylinder)) {
                    Map<String, Object> map = Maps.newHashMap();
                    map.put("sequenceCode", sequenceCode);
                    map.put("checkResult", CylinderComplianceStatus.NOT_EXIST.getDesc());
                    map.put("checkResultCode", CylinderComplianceStatus.NOT_EXIST.getCode());
                    result.add(map);
                } else {
                    if (ValidationUtil.isEmpty(targetCylinder.get("useRegistrationCode")) || !"true".equals(targetCylinder.get("isIntoManagement"))) {
                        targetCylinder.put("checkResult", CylinderComplianceStatus.NOT_REGISTERED.getDesc());
                        targetCylinder.put("checkResultCode", CylinderComplianceStatus.NOT_REGISTERED.getCode());
                    } else if (ValidationUtil.isEmpty(targetCylinder.get("nextInspectDate")) || DateUtil.parse((String) targetCylinder.get("nextInspectDate")).getTime() < System.currentTimeMillis()) {
                        targetCylinder.put("checkResult", CylinderComplianceStatus.EXPIRED_INSPECTION.getDesc());
                        targetCylinder.put("checkResultCode", CylinderComplianceStatus.EXPIRED_INSPECTION.getCode());
                    } else {
                        targetCylinder.put("checkResult", CylinderComplianceStatus.COMPLIANT.getDesc());
                        targetCylinder.put("checkResultCode", CylinderComplianceStatus.COMPLIANT.getCode());
                    }
                }
            });
            // 查询合规气瓶使用登记证的发证登记机关
            useRegistrationList = useRegistrationList.stream().filter(code -> !ValidationUtil.isEmpty(code)).collect(Collectors.toSet());
            if (ValidationUtil.isEmpty(useRegistrationList)) {
                return result;
            }
            List<JgUseRegistrationManage> manageList = jgUseRegistrationManageMapper.selectList(new LambdaQueryWrapper<JgUseRegistrationManage>().in(JgUseRegistrationManage::getUseRegistrationCode, useRegistrationList));
            if (!ValidationUtil.isEmpty(manageList)) {
                result.forEach(map -> {
                    manageList.stream().filter(i -> i.getUseRegistrationCode().equals(map.get("useRegistrationCode"))).findFirst().ifPresent(i -> map.put("registrationAuthority", i.getReceiveOrgName()));
                });
            }
        } catch (IOException e) {
            log.error("查询气瓶合规信息异常", e);
            throw new RuntimeException(e);
        }
        return result;
    }

    public Map<String, String> queryTcmUnitInfoBySeq(String estateUnitSeq, String unitType) {
        Map<String, String> propertyUnitInfo = commonMapper.queryTcmUnitInfoBySeq(estateUnitSeq, unitType);
        if (ValidationUtil.isEmpty(propertyUnitInfo) && !ValidationUtil.isEmpty(estateUnitSeq)) {
            // 未查询到产权信息则保存上送的产权信息
            propertyUnitInfo = Maps.newHashMap();
            Long seqNbr = IdWorker.getId();
            propertyUnitInfo.put("sequenceNbr", String.valueOf(seqNbr));
            propertyUnitInfo.put("unitName", estateUnitSeq);
            propertyUnitInfo.put("unitCode", "TCM" + seqNbr);
            propertyUnitInfo.put("unitType", unitType);
            propertyUnitInfo.put("createDate", String.valueOf(new Date()));

            commonMapper.addTcmUnitInfo(propertyUnitInfo);
        }
        return propertyUnitInfo;
    }
}