package com.yeejoin.amos.boot.biz.common.enums;

import com.yeejoin.amos.boot.biz.common.constants.RuleConstant;

/**
 * 规则请求枚举
 * @author xl
 *
 */
public enum RuleTypeEnum {

	// 防火监督
	计划提交("计划提交", "addPlan","auditPage", RuleConstant.APP_WEB, RuleConstant.TASK),
	计划审核("计划审核", "planAudit", "auditPage", RuleConstant.APP_WEB, RuleConstant.NOTIFY),
	计划审核任务("计划审核", "planAudit", "auditPage", RuleConstant.APP_WEB, RuleConstant.TASK),
	计划审核完成("计划审核完成", "planAuditAll", "formulatePage", RuleConstant.APP_WEB, RuleConstant.TASK),
	消息型计划生成("计划生成", "addPlanTask", null, RuleConstant.APP, RuleConstant.NOTIFY),
	任务型计划生成("计划生成", "addPlanTask", null, RuleConstant.APP, RuleConstant.TASK),
	计划完成("计划完成", "planCompleted", null, RuleConstant.APP_WEB, RuleConstant.NOTIFY),

	// 隐患
	隐患第一次提交("隐患提交", "addLatentDanger", null, null, RuleConstant.TASK),
	隐患审核("隐患审核", "dangerAudit", null, null, RuleConstant.TASK);

	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	/**
	 * 跳转地址
	 */
	private String url;
	/**
	 * 终端标识
	 */
	private String terminal;
	/**
	 * 类别
	 */
	private Integer category;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getTerminal() {
		return terminal;
	}

	public void setTerminal(String terminal) {
		this.terminal = terminal;
	}

	public Integer getCategory() {
		return category;
	}

	public void setCategory(Integer category) {
		this.category = category;
	}

	RuleTypeEnum(String name, String code, String url, String terminal, Integer category) {
		this.name = name;
		this.code = code;
		this.url = url;
		this.terminal = terminal;
		this.category = category;
	}

	public static RuleTypeEnum getEnumByCode(String field){
		for (RuleTypeEnum constants : values()) {
			if (constants.getCode().equals(field)) {
				return constants;
			}
		}
		return null;
	}
}
