package com.yeejoin.amos.supervision.business.dao.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.biz.common.annotations.DataAuth;
import com.yeejoin.amos.supervision.business.entity.mybatis.CheckChkExListBo;
import com.yeejoin.amos.supervision.business.entity.mybatis.PlanTaskPointInputItemBo;
import com.yeejoin.amos.supervision.business.entity.mybatis.PointCheckDetailBo;
import com.yeejoin.amos.supervision.business.param.CheckPtListPageParam;
import com.yeejoin.amos.supervision.business.param.PlanTaskPageParam;
import com.yeejoin.amos.supervision.business.vo.CodeOrderVo;
import com.yeejoin.amos.supervision.business.vo.LeavePlanTaskVo;
import com.yeejoin.amos.supervision.business.vo.PlanTaskVo;
import com.yeejoin.amos.supervision.dao.entity.PlanTask;
import com.yeejoin.amos.supervision.dao.entity.PointInputItem;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface PlanTaskMapper extends BaseMapper<PlanTask>, com.yeejoin.amos.supervision.business.dao.mapper.BaseMapper {
    /**
     * 统计-计划执行
     *
     * @param params
     * @return
     */
    long countPlanTask(PlanTaskPageParam params);

    /**
     * 计划执行查询
     *
     * @param params
     * @return
     */
    List<HashMap<String, Object>> getPlanTaskInfo(PlanTaskPageParam params);

    /**
     * 批量删除
     *
     * @param strArry
     */
    void planTaskDet(String[] strArry);

    /**
     * 更新任务表
     *
     * @param param
     */
    void updatePlanTaskPtInfo(HashMap<String, Object> param);

    /**
     * 查询需删除的任务信息列表
     *
     * @param param
     * @return
     */
    List<Long> getGenPlanTask(HashMap<String, Object> param);

    /**
     * 根据路线id获取关联的计划任务
     *
     * @param routeId
     * @return
     */
    List<PlanTask> getPlanTaskByRouteId(@Param(value = "routeId") Long routeId);

    /**
     * 根据巡检点id获取关联的计划任务
     *
     * @param routeId
     * @return
     */
    List<HashMap<String, Object>> getPlanTaskByPointId(HashMap<String, Object> param);

    /**
     * 根据条件查询计划任务列表
     *
     * @param params
     * @return
     */
    @DataAuth(interfacePath = "api/planTask/queryPlanTask")
    List<HashMap<String, Object>> getPlanTasks(HashMap<String, Object> params);

    /**
     * 根据用户统计待办任务数量
     *
     * @param userId 用户id
     * @return 统计数量
     */
    int countWaitingTaskByUser(@Param(value = "userId") String userId);

    /**
     * 通过计划任务Id获得计划任务信息
     *
     * @param planTaskId
     * @return
     */
    Map queryPlanTaskById(@Param(value = "planTaskId") Long planTaskId);

    /**
     * 通过计划任务Id获取任务所有点信息
     *
     * @param params
     * @return
     */
    List<Map<String, Object>> getPlanTaskPoints(HashMap<String, Object> params);

    long getPlanTaskPointsCount(HashMap<String, Object> params);

    /**
     * 获取用户当前所有可以做的任务个数
     *
     * @param userId
     * @return
     */
    int getCurrentPlanTaskCount(@Param(value = "userId") String userId);

    /**
     * 根据计划任务id获取所有巡检项信息
     *
     * @param planTaskId
     * @return
     */
    List<PlanTaskPointInputItemBo> getPlanTaskPointInputItemByPlanTaskId(@Param(value = "planTaskId") Long planTaskId, @Param(value = "planTaskDetailStatus") String planTaskDetailStatus);

    /**
     * 条件查询数据
     *
     * @param param
     * @return
     */
    List<PlanTaskVo> getPlanTaskInfoList(PlanTaskPageParam param);

    /**
     * 根据ids获取执行计划
     *
     * @param ids
     * @return
     */
    List<PlanTaskVo> getPlanTaskListByIds(@Param("ids") Long[] ids);

    /**
     * 分页统计
     *
     * @param param
     * @return
     */
    long countChkExListData(CheckPtListPageParam param);

    /**
     * 今日执行情况，业务信息查询
     *
     * @param param
     * @return
     */
    List<CheckChkExListBo> getChkExList(CheckPtListPageParam param);

    @DataAuth(interfacePath = "api/planTask/queryPlanTask")
    long getPlanTasksCount(HashMap<String, Object> params);

    Map<String, Object> getPlanTaskStatisticsForApp(HashMap<String, Object> params);


    /**
     * 根据计划id和点id获取点详情
     *
     * @param planTaskId
     * @param pointId
     * @return
     */
    PointCheckDetailBo getPointPlanTaskInfo(@Param("planTaskId") Long planTaskId, @Param("pointId") Long pointId);

    /**
     * 根据路线id和点id获取该点的检查项
     *
     * @param routeId
     * @param pointId
     * @return
     */
    List<PointCheckDetailBo> getPointInputByRouteIdAndPointId(@Param("routeId") Long routeId, @Param("pointId") Long pointId);

    /**
     * 统计当日任务累计完成情况
     *
     * @param loginOrgCode
     * @return
     */
    String getCumulativePlanCountByOrgCode(@Param("orgCode") String loginOrgCode);

    /**
     * 获取用户离线巡检计划任务信息
     *
     * @param params
     * @return
     */
    List<LeavePlanTaskVo> queryLeavePlanTask(HashMap<String, Object> params);

    /**
     * 根据路线id与点id，获取路线点项
     *
     * @param routeId
     * @param pointId
     * @return
     */
    List<PointInputItem> getRoutePointInputItem(@Param(value = "routeId") long routeId, @Param(value = "pointId") long pointId);


    List<CodeOrderVo> queryCodeOrderVo(HashMap<String, Object> params);

    /**
     * 重新统计用户重做日期段内计划任务
     *
     * @param userId
     * @param refDate
     * @param orgCode
     */
    void reformStatistics(@Param(value = "userId") String userId, @Param(value = "refDate") String refDate, @Param(value = "orgCode") String orgCode);

    List<Map<String, Object>> countFinishByPlanIds(List<Long> planIds);

    List<Map<String, Object>> queryPlanTaskTimeAxis(HashMap<String, Object> params);

    List<Map<String, Object>> queryTimeAxis(HashMap<String, Object> params);


}
