package com.yeejoin.amos.api.householdapi.face.model;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Date;

/**
 * 户用光伏-厂商API haders
 *
 * @author system_generator
 * @date 2023-06-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "HouseholdPvApiDto", description = "户用光伏-厂商API haders")
public class HouseholdPvApiDto extends BaseModel {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "厂商id")
    private String producerId;

    @ApiModelProperty(value = "api名称")
    private String apiName;

    @ApiModelProperty(value = "请求方式 GET或者POST")
    private String requestMethod;

    @ApiModelProperty(value = "api地址")
    private String apiUrl;

    @ApiModelProperty(value = "api描述")
    private String apiDescption;

    @ApiModelProperty(value = "参数信息")
    private String paramInfo;

    /**
     * 依赖的apiId
     */
    @ApiModelProperty(value = "依赖的apiId")
    private String dependecyApiId;
    /**
     * 缓存的属性
     */
    @ApiModelProperty(value = "缓存的属性")
    private String cacheField;
    /**
     * 依赖的api属性
     */
    @ApiModelProperty(value = "依赖的api属性")
    private String dependApiParamKey;
    /**
     * result解析结果
     */
    @ApiModelProperty(value = "result解析结果")
    private String resultResolveRule;
    /**
     * 是否分页
     */
    @ApiModelProperty(value = "是否分页")
    private Integer isPage;
    /**
     * 时序库中的表名
     */
    @ApiModelProperty(value = "时序库表名")
    private String measurement;

    /**
     * 页数解析规则
     */
    @ApiModelProperty(value = "pagesize_resolve_rule")
    private String pagesizeResolveRule;

    /**
     * 页码对应的请求中的字段
     */
    @ApiModelProperty( value = "page_field")
    private String pageField;
}
