package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 特岗人员
 *
 * @author system_generator
 * @date 2021-07-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SpecialPositionStaffDto", description = "特岗人员")
public class SpecialPositionStaffDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "岗位名称", index = 0)
    @ExplicitConstraint(type = "GWMC", indexNum = 0, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
    @ApiModelProperty(value = "岗位名称")
    private String positionName;

    @ExcelIgnore
    @ApiModelProperty(value = "岗位名称code")
    private String positionNameCode;

    @ExcelProperty(value = "人数", index = 1)
    @ApiModelProperty(value = "人数")
    private Long personNumber;

    @ExcelProperty(value = "单位名称", index = 2)
    @ExplicitConstraint(indexNum = 2, sourceClass = RoleNameExplicitConstraint.class,method="getUnitTeam") //动态下拉内容
    @ApiModelProperty(value = "单位名称")
    private String company;

    @ExcelIgnore
    @ApiModelProperty(value = "单位id")
    private Long companyId;

    @ExcelIgnore
    @ApiModelProperty(value = "更新人名称")
    private String recUserName;

}
