package com.yeejoin.amos.supervision.business.util;

import com.yeejoin.amos.supervision.business.param.CheckPageParam;
import com.yeejoin.amos.supervision.business.param.CheckRecordParam;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import com.yeejoin.amos.supervision.core.common.request.CommonRequest;
import com.yeejoin.amos.supervision.core.enums.QueryOperatorEnum;
import org.springframework.util.ObjectUtils;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;

public class CheckParamUtil {

    public static CheckRecordParam checkCalendar(List<DaoCriteria> daoCriterias) {
        CheckRecordParam param = new CheckRecordParam();
        for (int i = 0; i < daoCriterias.size(); i++) {
            DaoCriteria daoCriteria = daoCriterias.get(i);
            String operator = daoCriteria.getOperator();
            String name = daoCriteria.getPropertyName();
            if ("checkTime".equals(name)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                param.setCheckTime(daoCriterias.get(i).getValue().toString());
            } else if ("routeId".equals(name)) {
                param.setRouteId(Long.valueOf(daoCriterias.get(i).getValue().toString()));
            } else if ("orgCode".equals(name) && operator.equals(QueryOperatorEnum.EQUAL.getName())) {
                param.setOrgCode(daoCriterias.get(i).getValue().toString() + "%");
            }
        }
        return param;

    }

    public static CheckPageParam fillCheckPageParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
                                                    HashMap<String, Object> perMap) {
        CheckPageParam param = new CheckPageParam();
        if (queryRequests != null && !queryRequests.isEmpty()) {
            for (int i = 0; i < queryRequests.size(); i++) {
                String name = queryRequests.get(i).getName();
                if (ObjectUtils.isEmpty(queryRequests.get(i).getValue())) {
                    continue;
                }
                if ("planId".equals(name)) {
                    param.setPlanId(Long.parseLong(queryRequests.get(i).getValue().toString()));
                } else if ("companyId".equals(name)) {
                    param.setCompanyId(Long.parseLong(queryRequests.get(i).getValue().toString()));
                }
            }
        }
        param.setOrgCode(perMap.get("orgCode").toString());
        if (commonPageable != null) {
            param.setOffset(Integer.parseInt(String.valueOf(commonPageable.getOffset())));
            param.setPageNumber(commonPageable.getPageNumber());
            param.setPageSize(commonPageable.getPageSize());
        }
        return param;

    }
}
