package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_car_property")
@ApiModel(value = "CarProperty对象", description = "")
public class CarProperty extends BaseEntity {

	private static final long serialVersionUID = 1L;

	private Long carId;

	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String value;

	private String remark;

	/**
     * 指标id
     */
    @TableField(value = "equipment_index_id")
	private Long equipmentIndexId;
	
    /**
     * 指标名称
     */
    @TableField(value = "equipment_index_name")
	private String equipmentIndexName;
	
    /**
     * 指标key
     */
    @TableField(value = "equipment_index_key")
	private String equipmentIndexKey;
    


	/**
	 * 颜色
	 */
	@TableField(value = "emergency_level_color")
	private String emergencyLevelColor;

	/**
	 * 是否告警:0-否；1-是
	 */
	@TableField(value = "is_alarm")
	private Integer isAlarm;

	/**
	 * 紧急程度枚举（1：紧急，2：严重，3：轻微，4：正常，5：无效，6：备用，7：其他）
	 */
	@TableField(value = "emergency_level")
	private String emergencyLevel;

	/**
	 * 紧急程度描述
	 */
	@TableField(value = "emergency_level_describe")
	private String emergencyLevelDescribe;
	
	@TableField("update_date")
	@ApiModelProperty(value = "更新时间")
	private Date updateDate;

	@TableField(exist = false)
	private String unitName;
	@TableField(exist = false)
	private String perfQuotaName;
	@TableField(exist = false)
	private String groupName;
	
	@TableField(exist = false)
	private String nameKey;
	
	@TableField(exist = false)
	private String iotCode;
	

}
