package com.yeejoin.amos.fas.common.enums;

/**
 * @author wjk
 */

public enum ExecutionTypeEnum {
    PLANCHECK("预案验证",0),
    FIREMANAGEMENT("火灾处置",1);
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    private ExecutionTypeEnum(String name, Integer code){
        this.name = name;
        this.code = code;
    }

    public static ExecutionTypeEnum getEnum(Integer code) {
        ExecutionTypeEnum checkStatusEnum = null;
        for(ExecutionTypeEnum type: ExecutionTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                checkStatusEnum = type;
                break;
            }
        }
        return checkStatusEnum;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

}

