package com.yeejoin.amos.boot.module.common.api.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.common.api.dto.MaintenanceCompanyDto;
import com.yeejoin.amos.boot.module.common.api.dto.MaintenancePersonExcleDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormColumn;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.entity.MaintenanceCompany;

/**
 * 维保单位接口类
 *
 * @author chenhao
 * @date 2021-07-16
 */
public interface IMaintenanceCompanyService {
	/**
	 * 添加保存维保公司基本信息
	 * 
	 * @param maintenanceCompany
	 * @return
	 */
	public MaintenanceCompany saveCompanyDetail(MaintenanceCompany maintenanceCompany);

	/**
	 * 添加保存维保单位人员基本信息
	 * 
	 * @param maintenanceCompany
	 * @return
	 */
	public MaintenanceCompany savePersonDetail(MaintenanceCompany maintenanceCompany);

	/**
	 * 自定义假删除
	 * 
	 * @param sequenceNbr
	 * @return
	 */
	public boolean deleteById(Long sequenceNbr);

	/**
	 * 获取公司名称的下拉列表
	 * 
	 * @return
	 */
	List<Map<String, Object>> getMaintenanceCompanyDropDownList();

	/**
	 * 添加保存维保单位部门基本信息
	 * 
	 * @param maintenanceCompany
	 * @return
	 */
	public MaintenanceCompany saveDepartmentDetail(MaintenanceCompany maintenanceCompany);

	/**
	 * 检查当前的员工编号是否已经存在
	 * 
	 * @param code 员工编号
	 * @return
	 */
	public boolean checkPersonCodeExists(String code);

	/**
	 * 查询所有的维保人员/单位/部门列表信息，无分页
	 * 
	 * @param maintenanceType 类型（COMPANY单位，PERSON人员，DEPARTMENT部门）
	 * @return
	 */
	List<Map<String, Object>> getAllMaintenanceList(String maintenanceType);

	/**
	 * 查询分页展示的维保人员/单位/部门列表信息
	 * 
	 * @param Map<String,     Object>
	 * @param current         页码起始值
	 * @param size            行数
	 * @param informationCard 是否显示维保单位人员信息卡数据项
	 * @param dataItem        是否显示人员概要信息数据项
	 * @param maintenanceType 类型（COMPANY单位，PERSON人员，DEPARTMENT部门）
	 * @return
	 */
	IPage<Map<String, Object>> getPageMaintenanceList(Map<String, Object> paramsMap);

	/**
	 * 根据主键查询对应的信息
	 * 
	 * @param sequenceNbr 主键
	 * @return
	 */

	Map<String, Object>	findBySequenceNbr(Long sequenceNbr);
	
	/**
	 * 修改维保单位
	 * 
	 * @param model
	 * @return
	 */
	boolean updateMaintenanceCompanyDetail(MaintenanceCompany model) throws Exception;

	/**
	 * 修改维保部门
	 * 
	 * @param model
	 * @return
	 */
	public boolean updateMaintenanceDepartmentDetail(MaintenanceCompany model) throws Exception;

	/**
	 * 修改维保人员
	 * 
	 * @param model
	 * @return
	 */
	public boolean updateMaintenancePersonDetail(MaintenanceCompany model) throws Exception;

	/**
	 * 查询所有的单位-部门树
	 * 
	 * @return
	 */
	public List<MaintenanceCompany> getCompanyAndDepartmentTree();

	/**
	 * 查询制定公司的部门-人树
	 * 
	 * @param sequenceNbr
	 * @return
	 */
	public List<MaintenanceCompany> getDepartmentAndPersonTree(long sequenceNbr);

	/**
	 * 查询当前单位下所有的部门基本信息--下拉列表
	 * 
	 * @param sequenceNbr
	 * @return
	 */
	public List<MaintenanceCompany> getDepartmentList(long sequenceNbr);

	/**
	 * 维保单位人员EXCLE导入时entity的转换方法
	 * 
	 * @param MaintenancePersonExcleDto
	 * @param List<DynamicFormColumn>
	 * @return MaintenanceCompany
	 */
	List<DynamicFormInstance> maintenancePersonExcleDtoToDynamicFormInstanceList(List<DynamicFormColumn> columns,
			MaintenancePersonExcleDto maintenancePersonExcleDto, long instanceId, List<DynamicFormInstance> list);
	/**
	 * 维保单位人员EXCLE导入时分別往动态表单和维保单位主表中插入数据
	 * @param companyList
	 * @param list
	 * @return
	 */
	public boolean saveMaintenanceCompanyBatch(List<MaintenanceCompany> companyList, List<DynamicFormInstance> list);
	/**
	 * 将所有的维保人员导入到excle中
	 * @return
	 */
	public List<MaintenancePersonExcleDto> exportToMaintenancePersonExcel(Map map);

    List<MaintenanceCompany> findByInstanceIdAndType(Long instanceId, String type);

	List<MaintenanceCompany> findByCodeAndType(String code, String type);

	List<MaintenanceCompany> findPersonByAmosOrgId(String code, String userId);

	MaintenanceCompany getOne(Long parentId);

    Object amosIdExist(String amosId);
}
