package com.yeejoin.amos.boot.module.common.api.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.VideoDto;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 装备服务feign
 *
 * @author Dell
 */
@FeignClient(name = "${equip.fegin.name}", path = "equip", configuration = {MultipartSupportConfig.class})
public interface EquipFeignClient {

    /**
     * 获取未列装人员装备列表数据
     *
     * @return
     */
    @RequestMapping(value = "/equipSpecific/getAirEquipSpecificPage", method = RequestMethod.POST)
    ResponseModel<Page<Object>> getAirEquipSpecificPage(@RequestBody Object var1) throws InnerInvokException;

    /**
     * 人员装备列装
     *
     * @return
     */
    @RequestMapping(value = "/stock-detail/airport/person/bind", method = RequestMethod.POST)
    ResponseModel<List<Object>> stockBindEquip(@RequestBody List<Long> ids) throws InnerInvokException;

    /**
     * 人员装备退装
     *
     * @return
     */
    @RequestMapping(value = "/scrap/airport/person", method = RequestMethod.POST)
    ResponseModel<Object> scrapEquip(@RequestBody String id) throws InnerInvokException;

    /**
     * 人员装备回库
     *
     * @return
     */
    @RequestMapping(value = "/stock-detail/airport/person", method = RequestMethod.POST)
    ResponseModel<Object> stockEquip(@RequestBody Map<String, Object> map) throws InnerInvokException;

    /**
     * 装备详情
     *
     * @return
     */
    @RequestMapping(value = "/equipSpecific/getAirEquipSpecificDetail", method = RequestMethod.GET)
    ResponseModel<Object> getAirEquipSpecificDetail(@RequestParam Long stockDetailId) throws InnerInvokException;

    /**
     * 获取车辆列表
     *
     * @return
     */
    @RequestMapping(value = "/car/list-all", method = RequestMethod.GET)
    ResponseModel<Object> getFireCarListAll();




    /**
     * 获取本单位下车辆列表
     *
     * @return
     */
    @RequestMapping(value = "/car/list-allpag", method = RequestMethod.GET)
    ResponseModel<Object> equipmentCarList( @RequestParam Long teamId,
                                                               @RequestParam String name,
                                                               @RequestParam String code ,
                                                               @RequestParam String pageNum,
                                                               @RequestParam String pageSize,
                                                               @RequestParam Long id,
                                                               @RequestParam Boolean isNo );




    /**
     * 车辆树
     **/
    @RequestMapping(value = "/equipment-category/tree/2", method = RequestMethod.GET)
    ResponseModel<Object> gettree();





    /**
     * 获取个队伍下车辆统计
     *
     * @return
     */
    @RequestMapping(value = "/car/list-info", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> getFireCarListAllcount();

    /**
     * 获取消防系统列表
     *
     * @return
     */
    @RequestMapping(value = "/fire-fighting-system/list", method = RequestMethod.GET)
    ResponseModel<Object> getFireSystemListAll();

    /**
     * 获取消防系统列表
     *
     * @return
     */
    @RequestMapping(value = "/building/tree", method = RequestMethod.GET)
    ResponseModel<Object> getBuildingTree();
    /**
     * 获取消防建筑详情
     *
     * @return
     */
    @RequestMapping(value = "/building/getOne", method = RequestMethod.GET)
    ResponseModel<Object> getOne(@RequestParam Long instanceId);
    /**
     * 获取指定建筑的经纬度信息
     *
     * @return
     */
    @RequestMapping(value = "/building/getBuildingToLongitudeAndLatitude", method = RequestMethod.GET)
    ResponseModel<Object> getBuildingToLongitudeAndLatitude(@RequestParam String instanceId);
    /**
     * 更新车辆状态
     *
     * @param carStatusInfo 车辆状态信息
     * @return
     */
    @RequestMapping(value = "/car/status", method = RequestMethod.POST)
    ResponseModel<Object> updateCarStatus(@RequestBody List<Object> carStatusInfo);

    /**
     * 获取装备平面图
     *
     * @return
     */
    @RequestMapping(value = "/sourceFile/findImgByFileCategory", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> findImgByFileCategory(@RequestParam String id, @RequestParam String fileCategory);

    /**
     * 车辆信息
     **/
    @RequestMapping(value = "/car/getTeamCarList", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> getTeamCarList(@RequestParam Double longitude, @RequestParam Double latitude);
    
    
    /**
     * 车辆信息详情
     **/
    @RequestMapping(value = "/car/getCarDetailById/{id}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getCarDetailById(@PathVariable Long id);

    /**
     * 获取消防建筑树
     *
     * @return
     */
    @RequestMapping(value = "/building/BuildingtreeAndEquip", method = RequestMethod.GET)
    ResponseModel<Object> getBuildingTreeAndEquip();


    /**
     *
     *获取视频信息
     * @param
     * @return
     */
    @RequestMapping(value = "/building/video/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> getVideo( @RequestParam long current, @RequestParam long size, @RequestParam Long buildingId);
    @RequestMapping(value = "/building/video/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> getVideopag( @RequestParam String current,
                                                          @RequestParam String size,
                                                          @RequestParam String buildingId,
                                                          @RequestParam String code,
                                                          @RequestParam String equipmentName
    );

    /**
     *
     *获取视频列表
     * @param
     * @return
     */
    @RequestMapping(value = "/video/pageVideo", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> pageVideo( @RequestParam Integer pageNum, @RequestParam Integer pageSize, @RequestParam Double longitude,@RequestParam Double latitude,@RequestParam Double distance);


    @RequestMapping(value = "/video/pageList", method = RequestMethod.GET)
    ResponseModel<Page<VideoDto>> pageList(@RequestParam Integer current,
                                           @RequestParam Integer size,
                                           @RequestParam String code,
                                           @RequestParam String name,
                                           @RequestParam String typeCode);

    @RequestMapping(value = "/building/video/page", method = RequestMethod.GET)
    ResponseModel<Page<Map<String, Object>>> getVideoList( @RequestParam(value = "viewId") Long viewId,
                                                       @RequestParam(value = "videoName" ,required =false) String videoName,
                                                       @RequestParam(value = "videoCode" ,required =false) String videoCode,
                                                       @RequestParam(value = "current") int current,
                                                       @RequestParam(value = "size") int size);


    /**
     *
     *获取视频列表
     * @param
     * @return
     */
    @RequestMapping(value = "/video/getByid", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getByid( @RequestParam Long id);

    /**
     *
     *获取车辆简要信息
     * @param id 消防车id
     * @return
     */
    @RequestMapping(value = "/car/simple/{id}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> queryCarSimpleInfoById(@PathVariable Long id);

    /**
     * 统计
     **/
    @RequestMapping(value = "/equipSpecificAlarm/getCountAlarm/{type}", method = RequestMethod.GET)
    ResponseModel<Integer> getCountAlarm(@PathVariable String type);

    /**
     * 统计
     **/
    @RequestMapping(value = "/equipSpecificAlarm/getcountAlarmHandle/{type}", method = RequestMethod.GET)
    ResponseModel<Integer> getcountAlarmHandle(@PathVariable String type);

    /**
     * 获取装备全路径
     *
     * @return Map<String, Object>
     **/
    @RequestMapping(value = "/building/getBuildingAbsolutePosition", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getBuildingAbsolutePosition();

    /**
     * 根据实例id 获取实例信息 // 需求 958 新增值班区域 值班区域id 字段 获取名称 by kongfm 2021-09-15
     *
     * @return
     */
    @RequestMapping(value = "/building/getFormInstanceById", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getFormInstanceById(@RequestParam Long instanceId);

    /**
     * 查询所有建筑的数据字典 // 需求 958 新增值班区域 值班区域id 字段  获取下拉列表 by kongfm 2021-09-15
     * @return
     */
    @RequestMapping(value = "/building/getAllBuilding", method = RequestMethod.GET)
    ResponseModel<List<LinkedHashMap<String, Object>>> getAllBuilding();

    /**
     * 查询所有建筑的数据字典// BUG 2935 优化项 分类从93060000 取得字典数据 by kongfm 2021-09-17
     * @return
     */
    @RequestMapping(value = "equipment-category/tree/{type}", method = RequestMethod.GET)
    ResponseModel<List<LinkedHashMap<String, Object>>> getEquipmentCategory(@PathVariable String type);

    @RequestMapping(value = "/equipment/listLike/{code}", method = RequestMethod.GET)
    ResponseModel<List<LinkedHashMap<String, Object>>> listLikePage(@PathVariable String code);

    /**
     * 未处理消防告警 by litw 2021年10月25日
     *
     * @return
     */
    @RequestMapping(value = "/confirmAlarm/getFireAlarm", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getFireAlarm();

    /**
     * 未处理消防告警 by litw 2021年10月25日
     *
     * @return
     */
    @RequestMapping(value = "/confirmAlarm/getFaultAlarm", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getFaultAlarm();

    /**
     * 未处理消防告警 by litw 2021年10月25日
     *
     * @return
     */
    @RequestMapping(value = "/confirmAlarm/getMonitorEvent", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getMonitorEvent();
}
