package com.yeejoin.amos.boot.module.tzs.api.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledFormDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledRecordDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertHandlerDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DutyPersonDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DutySeatDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatMyBusinessListDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatMyBussinessDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatMyTaskDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatMyTaskListDto;
import com.yeejoin.amos.boot.module.tzs.api.enums.DispatchPaperEnums;
import org.apache.ibatis.annotations.Param;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;

import java.util.List;

/**
 * 警情接警填报记录接口类
 *
 * @author litw
 * @date 2021-08-03
 */
public interface IAlertCalledService {

    /**
     *
     * 根据灾情id 查询灾情详情
     *
     * **/
    Object selectAlertCalledById( Long id);

    /**
     *
     * 根据警情返回信息，不读取缓存
     *
     * **/
    AlertCalledFormDto selectAlertCalledByIdNoCache(Long id);

    /**
     * 根据查询条件返回警情记录
     * @param workOrderNumber
     * @return
     */
    Page<AlertCalledQueryDto> queryAlertListByQueryDto(IPage<AlertCalledQueryDto> page,
                                                       String workOrderNumber,
                                                       String creator,
                                                       String emergency,
                                                       String emergencyTimeStart,
                                                       String emergencyTimeEnd,
                                                       String emergencyCall,
                                                       String deviceId,
                                                       String elevatorAddress,
                                                       String district,
                                                       String alertType,
                                                       String alertSource,
                                                       String alertStage,
                                                       String alertStatus,
                                                       String sortParam,
                                                       String sortRule);

    /**
     * 更新警情阶段信息
     * @param alertCalledVo
     * @param stage
     * @return
     */
    Boolean updateAlertStage(AlertCalledDto alertCalledVo, DispatchPaperEnums stage);



    AlertHandlerDto getHandlerInfo(String alertId);

    Object getCalledInfo();

    WechatMyBussinessDto getBussinessInfoById(Long alertId);

    List<WechatMyBusinessListDto> getBussinessListByPhonePager(String phone, String bussinessCode, Long current);

    /**
     * 根据条件筛选 接警记录
     * @param callTimeStart
     * @param callTimeEnd
     * @param type
     * @param alertSource
     * @param alarmType
     * @return
     */
    List<AlertCalledRecordDto> queryAlertRecordListByQueryDto(String callTimeStart,String callTimeEnd, String type, String alertSource, String alarmType);

    /**
     * 获取坐席信息
     * @return
     */
    List<DutySeatDto> getSeatInfos();
}
