package com.yeejoin.amos.boot.biz.common.workflow.feign;

import java.util.HashMap;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.alibaba.fastjson.JSONObject;

@FeignClient(name = "AMOS-API-WORKFLOW-CJHENHAO", path = "workflow", configuration = { CommonMultipartSupportConfig.class })
public interface WorkflowFeignService {
	/**
	 * 发起流程
	 * 
	 * @param params
	 * @return
	 */
	@RequestMapping(value = "/task/startProcess", method = RequestMethod.POST)
	JSONObject startByVariable(@RequestBody Object params);

	/**
	 * 完成任务
	 * 
	 * @param taskID
	 * @param variable
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/task/pickupAndCompleteTask/{taskId}", method = RequestMethod.POST)
	JSONObject pickupAndCompleteTask(@PathVariable("taskId") String taskID,
			@RequestBody(required = false) HashMap<String, Object> variable) throws Exception;

	/**
	 * 查询当前流程下所有的可执行任务
	 * 
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/task/list/all/{processInstanceId}", method = RequestMethod.GET)
	JSONObject getTaskList(@PathVariable("processInstanceId") String processInstanceId);

	/**
	 * 查询当前任务的执行用户组
	 * 
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/task/getTaskGroupName/{taskId}", method = RequestMethod.GET)
	JSONObject getTaskGroupName(@PathVariable("taskId") String taskId);
	
	/**
	 * 我的待办
	 * @param processDefinitionKey
	 * @param userId
	 * @return
	 */
	@RequestMapping(value = "/task/all-list", method = RequestMethod.GET)
	 JSONObject getTasksNoAuth(@RequestParam(value="processDefinitionKey", required=false)  String processDefinitionKey,
	    		@RequestParam(value="userId", required=false)  String userId) ;
	/**
	 * 流程信息
	 * @param processDefinitionKey
	 * @param userId
	 * @return
	 */
	@RequestMapping(value = "/activitiHistory/processes/historytasks/list/{processInstanceId}", method = RequestMethod.GET)
	 JSONObject queryHistoryTaskListByProcessId(@PathVariable("processInstanceId") String processInstanceId);

}
