package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.dto.FailureMaintainDto;
import com.yeejoin.amos.boot.module.common.api.dto.FailureRepairlogDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureAudit;
import com.yeejoin.amos.boot.module.common.api.entity.FailureMaintain;
import com.yeejoin.amos.boot.module.common.api.enums.AuditResultEnum;
import com.yeejoin.amos.boot.module.common.api.enums.FailureStatuEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.FailureMaintainMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFailureMaintainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-08-04
 */
@Service
public class FailureMaintainServiceImpl extends BaseService<FailureMaintainDto,FailureMaintain,FailureMaintainMapper> implements IFailureMaintainService {
    @Autowired
    SourceFileServiceImpl sourceFileServiceImpl;
    @Autowired
    FailureDetailsServiceImpl failureDetailsService;
    @Autowired
    FailureRepairlogServiceImpl failureRepairlogService;

    /**
     * 分页查询
     */
    public Page<FailureMaintainDto> queryForFailureMaintainPage(Page<FailureMaintainDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<FailureMaintainDto> queryForFailureMaintainList()   {
        return this.queryForList("" , false);
    }

    /**
     * 添加维修记录
     */
    public FailureMaintainDto savemodel(FailureMaintainDto failureMaintainDto,ReginParams userInfo)   {
        failureDetailsService.checkExcuteTaskAuthMap(failureMaintainDto.getFaultId(),userInfo);

        failureDetailsService.excuteTask(failureMaintainDto.getFaultId(), userInfo, null);
        this.createWithModel(failureMaintainDto);
        //添加完成后修改保修单状态为待验收
        FailureDetailsDto failureDetailsDto = failureDetailsService.queryBySeq(failureMaintainDto.getFaultId());
        failureDetailsDto.setCurrentStatus(FailureStatuEnum.WAITING_ACCEPTANCE.getCode());
        failureDetailsService.updateWithModel(failureDetailsDto);

        //添加报修日志
        String processResult = "维修完成";
        repairlog(failureMaintainDto.getFaultId(),failureMaintainDto.getMaintainMan(),failureMaintainDto.getMaintainTime(),
                failureMaintainDto.getDepartment(),processResult);

        sourceFileServiceImpl.saveSourceFile(failureMaintainDto.getSequenceNbr(),failureMaintainDto.getAttachment());
        return failureMaintainDto;
    }

    /**
     * 根据FaultId查询
     */
    public List<FailureMaintain> findByfaultId(Long faultId) {
        Page<FailureMaintain> page = new Page<>();
        QueryWrapper<FailureMaintain> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fault_id", faultId).orderByDesc("submission_time");
        return baseMapper.selectList(queryWrapper);
    }

    /**
     *根据审核结果更新维修表
     */
    public FailureMaintainDto updateModel(FailureMaintainDto failureMaintainDto, Integer status, ReginParams userInfo)   {

        failureDetailsService.checkExcuteTaskAuthMap(failureMaintainDto.getFaultId(),userInfo);

        this.updateWithModel(failureMaintainDto);
        //根据status修改状态
        String processResult = new String();
        String condition = new String();
        FailureDetailsDto failureDetailsDto = failureDetailsService.queryBySeq(failureMaintainDto.getFaultId());
        if (status == AuditResultEnum.AGREE.getCode()) {//同意状态为已完结
            failureDetailsDto.setCurrentStatus(FailureStatuEnum.FINISH.getCode());
            failureDetailsService.updateWithModel(failureDetailsDto);
            processResult = "验证通过";
            condition= AuditResultEnum.AGREE.getName();
        }else {//不同意状态为已拒绝
            failureDetailsDto.setCurrentStatus(FailureStatuEnum.REFUSE.getCode());
            failureDetailsService.updateWithModel(failureDetailsDto);
            processResult = "验证未通过";
            condition = AuditResultEnum.REFUSE.getName();
        }

        failureDetailsService.excuteTask(failureMaintainDto.getFaultId(), userInfo, condition);

        //添加报修日志
        repairlog(failureMaintainDto.getFaultId(),failureMaintainDto.getMaintainMan(),failureMaintainDto.getMaintainTime(),
                failureMaintainDto.getDepartment(),processResult);
        return failureMaintainDto;
    }
   /**
    * 查询当前故障报修单的流程的审批历史节点
    * @param sequenceNbr
    * @return
    */
	public List<Object> getProcessHistoryList(Long sequenceNbr) {
		// TODO Auto-generated method stub
		return null;
	}

    /**
     * 添加报修日志
     */
    public void repairlog(Long faultId, String processAuditor, Date processTime, String processDepartment, String processResult) {
        FailureRepairlogDto failureRepairlogDto = new FailureRepairlogDto();
        failureRepairlogDto.setFaultId(faultId);
        failureRepairlogDto.setProcessAuditor(processAuditor);
        failureRepairlogDto.setProcessTime(processTime);
        failureRepairlogDto.setProcessDepartment(processDepartment);
        failureRepairlogDto.setProcessResult(processResult);
        failureRepairlogService.createWithModel(failureRepairlogDto);
    }
}