package com.yeejoin.amos.maintenance.business.service.intfc;

import java.util.List;

import org.springframework.data.domain.Page;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.RoleBo;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.maintenance.business.dto.DangerExecuteSubmitDto;
import com.yeejoin.amos.maintenance.business.param.LatentDangerExcuteParam;
import com.yeejoin.amos.maintenance.business.param.LatentDangerListParam;
import com.yeejoin.amos.maintenance.business.param.LatentDangerNormalParam;
import com.yeejoin.amos.maintenance.business.param.LatentDangerPatrolParam;
import com.yeejoin.amos.maintenance.business.param.PageParam;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.vo.DangerTimeAxisVo;
import com.yeejoin.amos.maintenance.core.common.response.DangerListResponse;

/**
 * @author keyong
 * @title: ILatentDangerService
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/1/26 14:44
 */
public interface ILatentDangerService {

    CommonResponse saveNormal(LatentDangerNormalParam latentDangerParam, String userId, String userRealName,
                              String departmentId, String departmentName, String companyId, String orgCode, RoleBo role);

    CommonResponse savePatrol(LatentDangerPatrolParam latentDangerPatrolParam, String userId, String userRealName,
                              String departmentId, String departmentName, String companyId, String orgCode, RoleBo role);

    CommonResponse list(String toke, String product, String appKey, LatentDangerListParam latentDangerListParam, AgencyUserModel user, String loginOrgCode, String deptId);

    DangerExecuteSubmitDto execute(LatentDangerExcuteParam latentDangerExcuteParam, String userId,
                                   String userRealName, String departmentId, String departmentName, RoleBo role);

    CommonResponse detail(String id, String userId,boolean isFinish);

    CommonResponse getByInstanceId(String instanceId);

    DangerExecuteSubmitDto excuteCallBack(String instanceId, Integer actionType, String remark, String token, String userId,
                                          String userRealName, String departmentId, String departmentName);

    void updateDangerStateOfOvertime();

    CommonResponse listFlowRecord(String token, String product, String appKey, Long id);

    void sendLatentDangerExcuteResult(DangerExecuteSubmitDto executeSubmitDto);

    void freshRiskJudgmentLangerCount(LatentDangerExcuteParam latentDangerExcuteParam);

    /**
     * 获取隐患等级字典值
     *
     * @return
     */
    Object getDangerLevel(String token, String product, String appKey, String dictCode);

    /**
     * 根据等级字符串获取等级字典对象
     *
     * @param dangerLevelStr 等级（"1","2","0"）
     * @return
     */
    JSONObject getDangerLevelJsonObject(String dangerLevelStr, String token, String product, String appKey, String dictCode);

    /**
     * 根据隐患id获取评审信息
     *
     * @param dangerId
     * @return
     */
    JSONObject getReviewInfo(Long dangerId);

    Page<DangerListResponse> listDanger(PageParam pageParam);

    List<DangerListResponse> export(PageParam pageParam);

    List<DangerTimeAxisVo> queryExecuteLog(Integer dateTime);
}
