package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.PlanClassifyTree;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

@Repository
public interface IPlanClassifyTreeDao extends BaseDao<PlanClassifyTree, Long> {


    @Query(value = "select * from c_plan_classify_tree  where parent_id = ?1",nativeQuery = true)
    List<PlanClassifyTree> findByParentId(Long parentId);

    @Query(value = "select * from c_plan_classify_tree",nativeQuery = true)
    List<PlanClassifyTree> getAll();

    /**
     * 查询当统计目录下特定名称的个数
     * @param classifyName 名称
     * @param parentId 父ID
     * @return
     */
    int countByClassifyNameAndParentId(String classifyName, Long parentId);

    int deleteByIdIn(Set<Long> allIds);
}
