package com.yeejoin.amos.api.openapi.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;

@AllArgsConstructor
@Getter
public enum InspectionEnum {

    HG("6040", "合格"),
    BHG("6041", "不合格"),
    FJHG("6042", "复检合格"),
    FJBHG("6043", "复检不合格"),
    QT("6044", "其他"),

    JDJC("6038", "监督检查"),
    DQJC("6039", "定期检查"),
    ZXJC("6206", "自行检测(电梯)");

    String code;
    String value;
    public static Map<String,String> codeValue = new HashMap<>();

    static {
        for(InspectionEnum e: InspectionEnum.values()){
            codeValue.put(e.code, e.value);
        }
    }
}
