package com.yeejoin.amos.boot.module.elevator.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 设备告知单
 *
 * @author system_generator
 * @date 2021-12-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_equipment_inform")
public class EquipmentInform extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 施工告知编号
     */
	@TableField("product_code")
    private String productCode;

    /**
     * 施工告知日期
     */
	@TableField("product_inform_date")
    private Date productInformDate;

    /**
     * 施工单位
     */
	@TableField("product_unit")
    private String productUnit;

    /**
     * 施工单位id
     */
	@TableField("product_unit_id")
    private Long productUnitId;

    /**
     * 施工类型
     */
	@TableField("product_type")
    private String productType;

    /**
     * 施工类型code
     */
	@TableField("product_type_code")
    private String productTypeCode;

    /**
     * 生产许可证编号
     */
	@TableField("licence_code")
    private String licenceCode;

    /**
     * 生产许可证有效期
     */
	@TableField("licence_date")
    private Date licenceDate;

    /**
     * 区域编码
     */
	@TableField("region_code")
    private String regionCode;

    /**
     * 省
     */
	@TableField("province")
    private String province;

    /**
     * 市
     */
	@TableField("city")
    private String city;

    /**
     * 县区
     */
	@TableField("district")
    private String district;

    /**
     * 街道
     */
	@TableField("stree")
    private String stree;

    /**
     * 小区
     */
	@TableField("community")
    private String community;

    /**
     * 详细地址
     */
	@TableField("address")
    private String address;

    /**
     * 经度
     */
	@TableField("longitude")
    private String longitude;

    /**
     * 纬度
     */
	@TableField("latitude")
    private String latitude;

    /**
     * 施工负责人
     */
	@TableField("principal")
    private String principal;

    /**
     * 施工负责人id
     */
	@TableField("principal_id")
    private Long principalId;

    /**
     * 施工负责人电话
     */
	@TableField("principal_phone")
    private String principalPhone;

    /**
     * 计划施工日期
     */
	@TableField("plan_product_date")
    private Date planProductDate;

    /**
     * 接收机构
     */
	@TableField("accept_unit")
    private String acceptUnit;

    /**
     * 接收机构id
     */
	@TableField("accept_unit_id")
    private Long acceptUnitId;

    /**
     * 检验机构
     */
	@TableField("inspecton_unit")
    private String inspectonUnit;

    /**
     * 检验机构id
     */
	@TableField("inspecton_unit_id")
    private Long inspectonUnitId;

    /**
     * 使用单位
     */
	@TableField("use_unit")
    private String useUnit;

    /**
     * 使用单位id
     */
	@TableField("use_unit_id")
    private Long useUnitId;

    /**
     * 产权单位
     */
	@TableField("property_unit")
    private String propertyUnit;

    /**
     * 产权单位id
     */
	@TableField("property_unit_id")
    private Long propertyUnitId;

    /**
     * 使用场所
     */
	@TableField("use_site")
    private String useSite;

    /**
     * 使用场所code
     */
	@TableField("use_site_code")
    private String useSiteCode;

    /**
     * 告知书编号
     */
	@TableField("inform_code")
    private String informCode;

    /**
     * 告知单状态 0 暂存 1未接收 2已接收
     */
	@TableField("inform_status")
    private String informStatus;

    /**
     * 流程ID
     */
    @TableField("process_id")
    private String processId;

    /**
     * 流程状态
     */
    @TableField("process_status")
    private String processStatus;
}
