package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 用户资质信息表
 *
 * @author system_generator
 * @date 2024-08-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="TzsUserPermissionDto", description="用户资质信息表")
public class TzsUserPermissionDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主表主键")
    private Long userSeq;

    @ApiModelProperty(value = "检验专用-级别")
    private String permissionLevel;

    @ApiModelProperty(value = "检验专用-资质项目")
    private String permissionItem;

    @ApiModelProperty(value = "人员类型，前端用来分组展示使用,人员类型，前端用来分组展示使用(permissionData{post})")
    private String permissionPost;

    @ApiModelProperty(value = "证书编号")
    private String certNo;

    @ApiModelProperty(value = "有效期至")
    private Date expiryDate;

    @ApiModelProperty(value = "发证机关")
    private String approvedOrgan;

    @ApiModelProperty(value = "发证日期")
    private Date issueDate;

    @ApiModelProperty(value = "证书附件")
    private String certAttachment;

    @ApiModelProperty(value = "证书类型")
    private String certType;

    @ApiModelProperty(value = "作业项目")
    private String jobItem;

    @ApiModelProperty("项目代号")
    private JSONArray itemCode;

    @ApiModelProperty(value = "其他作业项目")
    private String otherItem;

    @ApiModelProperty(value = "备注")
    private String remark;

}
